/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationInvocationException;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceWriteBuildOperationType;
import org.gradle.internal.resource.ReadableContent;
import org.gradle.internal.resource.transfer.AbstractProgressLoggingHandler;
import org.gradle.internal.resource.transfer.ExternalResourceUploader;
import org.gradle.internal.resource.transfer.ResourceOperation;

public class ProgressLoggingExternalResourceUploader
extends AbstractProgressLoggingHandler
implements ExternalResourceUploader {
    private final ExternalResourceUploader delegate;
    private final BuildOperationRunner buildOperationRunner;

    public ProgressLoggingExternalResourceUploader(ExternalResourceUploader delegate, BuildOperationRunner buildOperationRunner) {
        this.delegate = delegate;
        this.buildOperationRunner = buildOperationRunner;
    }

    public void upload(ReadableContent resource, ExternalResourceName destination) throws IOException {
        try {
            this.buildOperationRunner.run((RunnableBuildOperation)new UploadOperation(destination, resource));
        }
        catch (BuildOperationInvocationException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    private class UploadOperation
    implements RunnableBuildOperation {
        private final ExternalResourceName destination;
        private final ReadableContent resource;

        public UploadOperation(ExternalResourceName destination, ReadableContent resource) {
            this.destination = destination;
            this.resource = resource;
        }

        public void run(BuildOperationContext context) throws IOException {
            ResourceOperation uploadOperation = ProgressLoggingExternalResourceUploader.this.createResourceOperation(context, ResourceOperation.Type.upload);
            uploadOperation.setContentLength(this.resource.getContentLength());
            try {
                ProgressLoggingExternalResourceUploader.this.delegate.upload((ReadableContent)new ProgressLoggingReadableContent(this.resource, uploadOperation), this.destination);
            }
            catch (Throwable throwable) {
                context.setResult((Object)new ExternalResourceWriteBuildOperationType.Result(){
                    final /* synthetic */ ResourceOperation val$uploadOperation;
                    {
                        this.val$uploadOperation = resourceOperation;
                    }

                    public long getBytesWritten() {
                        return this.val$uploadOperation.getTotalProcessedBytes();
                    }
                });
                throw throwable;
            }
            context.setResult((Object)new /* invalid duplicate definition of identical inner class */);
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)("Upload " + this.destination.getUri())).progressDisplayName(this.destination.getShortDisplayName()).details((Object)new PutOperationDetails(this.destination.getUri()));
        }
    }

    private static class PutOperationDetails
    extends AbstractProgressLoggingHandler.LocationDetails
    implements ExternalResourceWriteBuildOperationType.Details {
        private PutOperationDetails(URI location) {
            super(location);
        }

        public String toString() {
            return "ExternalResourceWriteBuildOperationType.Details{location=" + this.getLocation() + ", " + '}';
        }
    }

    private static class ProgressLoggingReadableContent
    implements ReadableContent {
        private final ReadableContent delegate;
        private final ResourceOperation uploadOperation;

        private ProgressLoggingReadableContent(ReadableContent delegate, ResourceOperation uploadOperation) {
            this.delegate = delegate;
            this.uploadOperation = uploadOperation;
        }

        public InputStream open() {
            return new AbstractProgressLoggingHandler.ProgressLoggingInputStream(this.delegate.open(), this.uploadOperation);
        }

        public long getContentLength() {
            return this.delegate.getContentLength();
        }
    }
}

