/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import com.google.common.base.Preconditions;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.internal.ExternalProcessStartedListener;
import org.gradle.api.internal.file.DefaultFileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DefaultDirectoryFileTreeFactory;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.tasks.DefaultTaskDependencyFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.util.internal.PatternSets;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.jvm.JavaModuleDetector;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.nativeintegration.services.FileSystems;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.internal.ClientExecHandleBuilderFactory;
import org.gradle.process.internal.DefaultExecAction;
import org.gradle.process.internal.DefaultExecHandleBuilder;
import org.gradle.process.internal.DefaultJavaExecAction;
import org.gradle.process.internal.DefaultJavaForkOptions;
import org.gradle.process.internal.EffectiveJavaForkOptions;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecFactory;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.ExecHandleBuilder;
import org.gradle.process.internal.ExecHandleListener;
import org.gradle.process.internal.JavaExecAction;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.JavaForkOptionsInternal;

public class DefaultExecActionFactory
implements ExecFactory {
    protected final FileResolver fileResolver;
    protected final Executor executor;
    protected final FileCollectionFactory fileCollectionFactory;
    protected final ObjectFactory objectFactory;
    protected final TemporaryFileProvider temporaryFileProvider;
    @Nullable
    protected final JavaModuleDetector javaModuleDetector;
    protected final BuildCancellationToken buildCancellationToken;
    protected final ClientExecHandleBuilderFactory execHandleFactory;
    protected final Instantiator instantiator;
    protected final ExternalProcessStartedListener externalProcessStartedListener;

    private DefaultExecActionFactory(FileResolver fileResolver, FileCollectionFactory fileCollectionFactory, Instantiator instantiator, Executor executor, TemporaryFileProvider temporaryFileProvider, BuildCancellationToken buildCancellationToken, ObjectFactory objectFactory, ClientExecHandleBuilderFactory execHandleFactory, @Nullable JavaModuleDetector javaModuleDetector, @Nullable ExternalProcessStartedListener externalProcessStartedListener) {
        this.fileResolver = fileResolver;
        this.fileCollectionFactory = fileCollectionFactory;
        this.objectFactory = objectFactory;
        this.temporaryFileProvider = temporaryFileProvider;
        this.javaModuleDetector = javaModuleDetector;
        this.buildCancellationToken = buildCancellationToken;
        this.executor = executor;
        this.execHandleFactory = execHandleFactory.withFileResolver((PathToFileResolver)fileResolver);
        this.instantiator = instantiator;
        this.externalProcessStartedListener = externalProcessStartedListener;
    }

    public static DefaultExecActionFactory of(FileResolver fileResolver, FileCollectionFactory fileCollectionFactory, Instantiator instantiator, ExecutorFactory executorFactory, TemporaryFileProvider temporaryFileProvider, BuildCancellationToken buildCancellationToken, ObjectFactory objectFactory, ClientExecHandleBuilderFactory clientExecHandleBuilderFactory) {
        return new DefaultExecActionFactory(fileResolver, fileCollectionFactory, instantiator, (Executor)executorFactory.create("Exec process"), temporaryFileProvider, buildCancellationToken, objectFactory, clientExecHandleBuilderFactory, null, null);
    }

    public ExecAction newDecoratedExecAction() {
        DefaultExecAction execAction = (DefaultExecAction)this.instantiator.newInstance(DefaultExecAction.class, new Object[]{this.execHandleFactory.newExecHandleBuilder()});
        ExecHandleListener listener = this.getExecHandleListener();
        if (listener != null) {
            execAction.listener(listener);
        }
        return execAction;
    }

    @Override
    public ExecAction newExecAction() {
        return new DefaultExecAction(this.execHandleFactory.newExecHandleBuilder());
    }

    @Override
    public JavaForkOptionsInternal newDecoratedJavaForkOptions() {
        DefaultJavaForkOptions forkOptions = (DefaultJavaForkOptions)this.instantiator.newInstance(DefaultJavaForkOptions.class, new Object[]{this.objectFactory, this.fileResolver, this.fileCollectionFactory});
        forkOptions.setExecutable(Jvm.current().getJavaExecutable());
        return forkOptions;
    }

    @Override
    public JavaForkOptionsInternal newJavaForkOptions() {
        DefaultJavaForkOptions forkOptions = (DefaultJavaForkOptions)this.objectFactory.newInstance(DefaultJavaForkOptions.class, new Object[]{this.objectFactory, this.fileResolver, this.fileCollectionFactory});
        if (forkOptions.getExecutable() == null) {
            forkOptions.setExecutable(Jvm.current().getJavaExecutable());
        }
        return forkOptions;
    }

    @Override
    public EffectiveJavaForkOptions toEffectiveJavaForkOptions(JavaForkOptionsInternal options) {
        Factory nonCachingPatternSetFactory = PatternSets.getNonCachingPatternSetFactory();
        DefaultFileCollectionFactory fileCollectionFactory = new DefaultFileCollectionFactory((PathToFileResolver)this.fileResolver, DefaultTaskDependencyFactory.withNoAssociatedProject(), (DirectoryFileTreeFactory)new DefaultDirectoryFileTreeFactory(), nonCachingPatternSetFactory, PropertyHost.NO_OP, FileSystems.getDefault());
        return options.toEffectiveJavaForkOptions((FileCollectionFactory)fileCollectionFactory);
    }

    public JavaExecAction newDecoratedJavaExecAction() {
        JavaForkOptionsInternal forkOptions = this.newDecoratedJavaForkOptions();
        forkOptions.setExecutable(Jvm.current().getJavaExecutable());
        DefaultJavaExecAction javaExecAction = (DefaultJavaExecAction)this.instantiator.newInstance(DefaultJavaExecAction.class, new Object[]{this.newJavaExec()});
        ExecHandleListener listener = this.getExecHandleListener();
        if (listener != null) {
            javaExecAction.listener(listener);
        }
        return javaExecAction;
    }

    @Nullable
    private ExecHandleListener getExecHandleListener() {
        if (this.externalProcessStartedListener == null) {
            return null;
        }
        return new ExecHandleListener(){

            public void beforeExecutionStarted(ExecHandle execHandle) {
                StringBuilder command = new StringBuilder(execHandle.getCommand());
                for (String argument : execHandle.getArguments()) {
                    command.append(' ').append(argument);
                }
                DefaultExecActionFactory.this.externalProcessStartedListener.onExternalProcessStarted(command.toString(), null);
            }

            public void executionStarted(ExecHandle execHandle) {
            }

            public void executionFinished(ExecHandle execHandle, ExecResult execResult) {
            }
        };
    }

    @Override
    public JavaExecAction newJavaExecAction() {
        return new DefaultJavaExecAction(this.newJavaExec());
    }

    public ExecHandleBuilder newExec() {
        return new DefaultExecHandleBuilder(this.execHandleFactory.newExecHandleBuilder());
    }

    @Override
    public JavaExecHandleBuilder newJavaExec() {
        return new JavaExecHandleBuilder(this.fileCollectionFactory, this.objectFactory, this.temporaryFileProvider, this.javaModuleDetector, this.newJavaForkOptions(), this.execHandleFactory.newExecHandleBuilder());
    }

    @Override
    public ExecResult javaexec(Action<? super JavaExecSpec> action) {
        JavaExecAction execAction = this.newDecoratedJavaExecAction();
        action.execute((Object)execAction);
        return execAction.execute();
    }

    @Override
    public ExecResult exec(Action<? super ExecSpec> action) {
        ExecAction execAction = this.newDecoratedExecAction();
        action.execute((Object)execAction);
        return execAction.execute();
    }

    @Override
    public ExecFactory.Builder forContext() {
        return new BuilderImpl(this.executor, this.temporaryFileProvider).withInstantiator(this.instantiator).withExternalProcessStartedListener(this.externalProcessStartedListener).withFileResolver(this.fileResolver).withFileCollectionFactory(this.fileCollectionFactory).withBuildCancellationToken(this.buildCancellationToken).withObjectFactory(this.objectFactory).withJavaModuleDetector(this.javaModuleDetector).withExecHandleFactory(this.execHandleFactory);
    }

    private static class BuilderImpl
    implements ExecFactory.Builder {
        private final Executor executor;
        private final TemporaryFileProvider temporaryFileProvider;
        private FileResolver fileResolver;
        private FileCollectionFactory fileCollectionFactory;
        private Instantiator instantiator;
        private BuildCancellationToken buildCancellationToken;
        private ObjectFactory objectFactory;
        private ClientExecHandleBuilderFactory clientExecHandleBuilderFactory;
        @Nullable
        private JavaModuleDetector javaModuleDetector;
        @Nullable
        private ExternalProcessStartedListener externalProcessStartedListener;

        BuilderImpl(Executor executor, TemporaryFileProvider temporaryFileProvider) {
            this.executor = executor;
            this.temporaryFileProvider = temporaryFileProvider;
        }

        @Override
        public ExecFactory.Builder withFileResolver(FileResolver fileResolver) {
            this.fileResolver = fileResolver;
            return this;
        }

        @Override
        public ExecFactory.Builder withFileCollectionFactory(FileCollectionFactory fileCollectionFactory) {
            this.fileCollectionFactory = fileCollectionFactory;
            return this;
        }

        @Override
        public ExecFactory.Builder withInstantiator(Instantiator instantiator) {
            this.instantiator = instantiator;
            return this;
        }

        @Override
        public ExecFactory.Builder withObjectFactory(ObjectFactory objectFactory) {
            this.objectFactory = objectFactory;
            return this;
        }

        @Override
        public ExecFactory.Builder withJavaModuleDetector(@Nullable JavaModuleDetector javaModuleDetector) {
            this.javaModuleDetector = javaModuleDetector;
            return this;
        }

        @Override
        public ExecFactory.Builder withBuildCancellationToken(BuildCancellationToken buildCancellationToken) {
            this.buildCancellationToken = buildCancellationToken;
            return this;
        }

        @Override
        public ExecFactory.Builder withExternalProcessStartedListener(@Nullable ExternalProcessStartedListener externalProcessStartedListener) {
            this.externalProcessStartedListener = externalProcessStartedListener;
            return this;
        }

        @Override
        public ExecFactory.Builder withExecHandleFactory(ClientExecHandleBuilderFactory execHandleBuilderFactory) {
            this.clientExecHandleBuilderFactory = execHandleBuilderFactory;
            return this;
        }

        @Override
        public ExecFactory.Builder withoutExternalProcessStartedListener() {
            this.externalProcessStartedListener = null;
            return this;
        }

        @Override
        public ExecFactory build() {
            Preconditions.checkState((this.fileResolver != null ? 1 : 0) != 0, (Object)"fileResolver is not set");
            Preconditions.checkState((this.fileCollectionFactory != null ? 1 : 0) != 0, (Object)"fileCollectionFactory is not set");
            Preconditions.checkState((this.instantiator != null ? 1 : 0) != 0, (Object)"instantiator is not set");
            Preconditions.checkState((this.buildCancellationToken != null ? 1 : 0) != 0, (Object)"buildCancellationToken is not set");
            Preconditions.checkState((this.objectFactory != null ? 1 : 0) != 0, (Object)"objectFactory is not set");
            Preconditions.checkState((this.clientExecHandleBuilderFactory != null ? 1 : 0) != 0, (Object)"clientExecHandleFactory is not set");
            return new DefaultExecActionFactory(this.fileResolver, this.fileCollectionFactory, this.instantiator, this.executor, this.temporaryFileProvider, this.buildCancellationToken, this.objectFactory, this.clientExecHandleBuilderFactory, this.javaModuleDetector, this.externalProcessStartedListener);
        }
    }
}

