/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

class CharacterSetAL32UTF8
extends CharacterSet
implements CharacterRepConstants {
    CharacterSetAL32UTF8(int n) {
        super(n);
        this.rep = 6;
    }

    public byte[] convert(String string) throws SQLException {
        return CharacterSet.stringToAL32UTF8(string);
    }

    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n, int n2) throws SQLException {
        byte[] byArray2;
        if (characterSet.rep == 6) {
            byArray2 = CharacterSet.useOrCopy(byArray, n, n2);
        } else {
            String string = characterSet.toString(byArray, n, n2);
            byArray2 = CharacterSet.stringToAL32UTF8(string);
        }
        return byArray2;
    }

    public byte[] convertWithReplacement(String string) {
        return CharacterSet.stringToAL32UTF8(string);
    }

    int decode(CharacterWalker characterWalker) throws SQLException {
        char c;
        byte[] byArray = characterWalker.bytes;
        int n = characterWalker.next;
        int n2 = characterWalker.end;
        if (n >= n2) {
            CharacterSet.failUTFConversion();
        }
        char c2 = byArray[n++];
        int n3 = c2 & 0xF0;
        switch (n3 / 16) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                c = c2;
                break;
            }
            case 12: 
            case 13: {
                byte by;
                if (n >= n2) {
                    CharacterSet.failUTFConversion();
                }
                if (((by = byArray[n++]) & 0xC0) != 128) {
                    CharacterSet.failUTFConversion();
                }
                c = (char)((c2 & 0x1F) << 6 | by & 0x3F);
                break;
            }
            case 14: {
                if (n + 1 >= n2) {
                    CharacterSet.failUTFConversion();
                }
                byte by = byArray[n++];
                byte by2 = byArray[n++];
                if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                    CharacterSet.failUTFConversion();
                }
                c = (char)((c2 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F);
                break;
            }
            case 15: {
                if (n + 2 >= n2) {
                    CharacterSet.failUTFConversion();
                }
                byte by = byArray[n++];
                byte by3 = byArray[n++];
                byte by4 = byArray[n++];
                if ((by & 0xC0) != 128 || (by3 & 0xC0) != 128 || (by4 & 0xC0) != 128) {
                    CharacterSet.failUTFConversion();
                }
                c = (char)(((((c2 & 7) << 2 | (by >> 4 & 3) - 1) & 0xF) << 6 | (by & 0xF) << 2 | by3 >> 4 & 3 | 0xD800) << 16 | ((by3 & 0xF) << 6 | by4 & 0x3F | 0xDC00));
                break;
            }
            default: {
                CharacterSet.failUTFConversion();
                c = '\u0000';
            }
        }
        characterWalker.next = n;
        return c;
    }

    void encode(CharacterBuffer characterBuffer, int n) throws SQLException {
        if (n > 65535) {
            CharacterSet.failUTFConversion();
        } else {
            CharacterSet.need(characterBuffer, 3);
            char[] cArray = new char[]{(char)n};
            int n2 = CharacterSet.javaCharsToAL32UTF8(cArray, 0, 1, characterBuffer.bytes, characterBuffer.next);
            characterBuffer.next += n2;
        }
    }

    public boolean isConvertibleFrom(CharacterSet characterSet) {
        boolean bl = characterSet.rep <= 1024;
        return bl;
    }

    public boolean isLossyFrom(CharacterSet characterSet) {
        return characterSet.isUnicode() ^ true;
    }

    public boolean isUnicode() {
        return true;
    }

    public String toString(byte[] byArray, int n, int n2) throws SQLException {
        char[] cArray = CharacterSet.AL32UTF8ToJavaChar(byArray, n, n2);
        return new String(cArray);
    }

    public String toStringWithReplacement(byte[] byArray, int n, int n2) {
        int n3 = n;
        int n4 = n + n2;
        if (n4 > byArray.length) {
            n4 = byArray.length;
        }
        char[] cArray = new char[CharacterSet.UTFStringLength(byArray, n, n2)];
        int n5 = 0;
        while (n3 < n4) {
            byte by = byArray[n3++];
            int n6 = by & 0xF0;
            switch (n6 / 16) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n5++] = (char)(by & 0xFF);
                    break;
                }
                case 12: 
                case 13: {
                    byte by2;
                    if (n3 >= n4) {
                        cArray[n5++] = 63;
                        n3 = n4;
                        break;
                    }
                    if (((by2 = byArray[n3++]) & 0xC0) != 128) {
                        cArray[n5++] = 63;
                        break;
                    }
                    cArray[n5++] = (char)((by & 0x1F) << 6 | by2 & 0x3F);
                    break;
                }
                case 14: {
                    if (n3 + 1 >= n4) {
                        cArray[n5++] = 63;
                        n3 = n4;
                        break;
                    }
                    byte by2 = byArray[n3++];
                    byte by3 = byArray[n3++];
                    if ((by2 & 0xC0) != 128 || (by3 & 0xC0) != 128) {
                        cArray[n5++] = 63;
                        break;
                    }
                    cArray[n5++] = (char)((by & 0xF) << 12 | (by2 & 0x3F) << 6 | by3 & 0x3F);
                    break;
                }
                case 15: {
                    if (n3 + 2 >= n4) {
                        cArray[n5++] = 63;
                        n3 = n4;
                        break;
                    }
                    byte by2 = byArray[n3++];
                    byte by3 = byArray[n3++];
                    byte by4 = byArray[n3++];
                    if ((by2 & 0xC0) != 128 || (by3 & 0xC0) != 128 || (by4 & 0xC0) != 128) {
                        cArray[n5++] = 63;
                        break;
                    }
                    cArray[n5++] = (char)((((by & 7) << 2 | (by2 >> 4 & 3) - 1) & 0xF) << 6 | (by2 & 0xF) << 2 | by3 >> 4 & 3 | 0xD800);
                    cArray[n5++] = (char)((by3 & 0xF) << 6 | by4 & 0x3F | 0xDC00);
                    break;
                }
                default: {
                    cArray[n5++] = 63;
                }
            }
        }
        return new String(cArray);
    }
}

