/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.basics.accessibility;

import com.jgoodies.application.Application;
import com.jgoodies.binding.list.IndirectListModel;
import com.jgoodies.common.bean.Bean;
import com.jgoodies.dialogs.basics.accessibility.ControlList;
import com.jgoodies.dialogs.core.util.JSDLUtils;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;

public final class ControlListModel
extends Bean {
    static final String PROPERTY_SORT_MODE = "sortMode";
    private static final String KEY_SORT_MODE = "control_list.sort_mode";
    private final List<Component> elements;
    private final List<String> elementNamesSortedByFocus;
    private final List<String> elementNamesSortedByName;
    private final IndirectListModel<String> elementNamesModel;
    private final ListSelectionModel elementNamesSelectionModel;

    ControlListModel(ControlList.ControlListRenderer renderer, List<Component> elements) {
        this.elements = elements;
        this.elementNamesSortedByFocus = ControlListModel.allDisplayStrings(renderer, elements);
        this.elementNamesSortedByName = new ArrayList<String>();
        this.elementNamesSortedByName.addAll(this.elementNamesSortedByFocus);
        Collections.sort(this.elementNamesSortedByName);
        this.elementNamesModel = new IndirectListModel();
        this.elementNamesSelectionModel = new DefaultListSelectionModel();
        this.elementNamesSelectionModel.setSelectionMode(0);
        this.initEventHandling();
    }

    private void initEventHandling() {
        this.addPropertyChangeListener(PROPERTY_SORT_MODE, this::onSortModeChanged);
        this.onSortModeChanged(null);
    }

    public Component getSelectedElement() {
        if (this.getElementNamesSelectionModel().isSelectionEmpty()) {
            return null;
        }
        int selectionIndex = this.getElementNamesSelectionModel().getMinSelectionIndex();
        int originalIndex = this.mapSortedToOriginalIndex(selectionIndex);
        return this.elements.get(originalIndex);
    }

    public ListModel<String> getElementNamesModel() {
        return this.elementNamesModel;
    }

    public ListSelectionModel getElementNamesSelectionModel() {
        return this.elementNamesSelectionModel;
    }

    public SortMode getSortMode() {
        Preferences userRoot = Application.getInstance().getContext().getUserPreferences();
        return SortMode.valueOf(userRoot.get(KEY_SORT_MODE, SortMode.FOCUS_TRAVERSAL_ORDER.name()));
    }

    public void setSortMode(SortMode newValue) {
        SortMode oldValue = this.getSortMode();
        Preferences userRoot = Application.getInstance().getContext().getUserPreferences();
        userRoot.put(KEY_SORT_MODE, newValue.name());
        this.firePropertyChange(PROPERTY_SORT_MODE, (Object)oldValue, (Object)newValue);
    }

    void onMouseDoubleClicked(MouseEvent evt) {
        JSDLUtils.closePaneFor(evt);
    }

    private void onSortModeChanged(PropertyChangeEvent evt) {
        this.elementNamesModel.setList(this.isFocusOrder() ? this.elementNamesSortedByFocus : this.elementNamesSortedByName);
    }

    private boolean isFocusOrder() {
        return this.getSortMode() == SortMode.FOCUS_TRAVERSAL_ORDER;
    }

    private static List<String> allDisplayStrings(ControlList.ControlListRenderer renderer, List<Component> components) {
        return components.stream().map(c -> renderer.displayString((Component)c)).collect(Collectors.toList());
    }

    private int mapSortedToOriginalIndex(int selectionIndex) {
        if (this.isFocusOrder()) {
            return selectionIndex;
        }
        String selectedElementName = this.elementNamesSortedByName.get(selectionIndex);
        return this.elementNamesSortedByFocus.indexOf(selectedElementName);
    }

    static enum SortMode {
        ALPHABETICAL,
        FOCUS_TRAVERSAL_ORDER;

    }
}

