/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.basics.choice.list_builder;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.dialogs.basics.choice.list_builder.AbstractListBuilderModel;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeSelectionModel;

public abstract class AbstractTreeListBuilderModel<E>
extends AbstractListBuilderModel<E> {
    public static final String PROPERTY_OPTIONS_DATA_MODEL = "optionsDataModel";
    public static final String PROPERTY_OPTIONS_SELECTION_MODEL = "optionsSelectionModel";
    private final TreeModelListener optionsTreeModelListener = new OptionsTreeModelListener();
    private final TreeSelectionListener optionsTreeSelectionListener = this::onOptionsTreeSelectionChanged;
    private TreeModel optionsTreeModel;
    private TreeSelectionModel optionsTreeSelectionModel;

    public AbstractTreeListBuilderModel() {
        this.setOptionsSelectionModel(this.createDefaultOptionsSelectionModel());
    }

    public final TreeModel getOptionsDataModel() {
        return this.optionsTreeModel;
    }

    public final void setOptionsDataModel(TreeModel newDataModel) {
        Preconditions.checkNotNull(newDataModel, "The %s must not be null.", "options tree model");
        TreeModel oldDataModel = this.optionsTreeModel;
        if (oldDataModel != null) {
            newDataModel.removeTreeModelListener(this.optionsTreeModelListener);
        }
        this.optionsTreeModel = newDataModel;
        this.handleOptionsDataChanged();
        this.optionsTreeModel.addTreeModelListener(this.optionsTreeModelListener);
        this.firePropertyChange(PROPERTY_OPTIONS_DATA_MODEL, oldDataModel, newDataModel);
    }

    public final TreeSelectionModel getOptionsSelectionModel() {
        return this.optionsTreeSelectionModel;
    }

    public final void setOptionsSelectionModel(TreeSelectionModel newSelectionModel) {
        Preconditions.checkNotNull(newSelectionModel, "The %s must not be null.", "options tree selection model");
        if (this.optionsTreeSelectionModel != null) {
            this.optionsTreeSelectionModel.removeTreeSelectionListener(this.optionsTreeSelectionListener);
        }
        this.optionsTreeSelectionModel = newSelectionModel;
        this.handleOptionsSelectionChange();
        this.optionsTreeSelectionModel.addTreeSelectionListener(this.optionsTreeSelectionListener);
        this.firePropertyChange(PROPERTY_OPTIONS_DATA_MODEL, null, newSelectionModel);
    }

    public final void setOptionsSelectionMode(int mode) {
        this.getOptionsSelectionModel().setSelectionMode(mode);
    }

    private void onOptionsTreeSelectionChanged(TreeSelectionEvent evt) {
        this.handleOptionsSelectionChange();
    }

    protected TreeSelectionModel createDefaultOptionsSelectionModel() {
        return new DefaultTreeSelectionModel();
    }

    private final class OptionsTreeModelListener
    implements TreeModelListener {
        private OptionsTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent evt) {
            AbstractTreeListBuilderModel.this.handleOptionsDataChanged();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent evt) {
            AbstractTreeListBuilderModel.this.handleOptionsDataChanged();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent evt) {
            AbstractTreeListBuilderModel.this.handleOptionsDataChanged();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent evt) {
            AbstractTreeListBuilderModel.this.handleOptionsDataChanged();
        }
    }
}

