/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.shared.util;

import com.jgoodies.application.Application;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.components.util.CompoundIcon;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public final class ExtFileSystemView
extends FileSystemView {
    private static final ResourceMap RESOURCES = Application.getResourceMap(ExtFileSystemView.class);
    private static ExtFileSystemView instance;
    private final JFileChooser fileChooser = new JFileChooser();
    private FileSystemView delegate;
    private Icon absentFolderIcon;
    private Icon absentLeafIcon;
    private Icon floppyDriveIcon;
    private Icon hardDriveIcon;
    private Icon homeFolderIcon;
    private Icon leafIcon;

    private ExtFileSystemView() {
        this.installCachedIcons();
        UIManager.addPropertyChangeListener(evt -> {
            this.delegate = null;
        });
    }

    public static ExtFileSystemView getInstance() {
        if (instance == null) {
            instance = new ExtFileSystemView();
        }
        return instance;
    }

    @Override
    public File[] getFiles(File file, boolean useFileHiding) {
        return this.getDelegate().getFiles(file, useFileHiding);
    }

    @Override
    public File[] getRoots() {
        File[] roots = this.getDelegate().getRoots();
        if (SystemUtils.IS_OS_WINDOWS) {
            return roots;
        }
        File[] nodes = new File[roots.length + 1];
        System.arraycopy(roots, 0, nodes, 1, roots.length);
        nodes[0] = this.getCurrentDirectory();
        return nodes;
    }

    @Override
    public boolean isFileSystem(File file) {
        return this.getDelegate().isFileSystem(file);
    }

    @Override
    public File createNewFolder(File containingDir) throws IOException {
        return this.getDelegate().createNewFolder(containingDir);
    }

    public File getCurrentDirectory() {
        return this.fileChooser.getCurrentDirectory();
    }

    public String getDirectoryName(File directory) {
        return this.getDelegate().getSystemDisplayName(directory);
    }

    public Icon getIcon(File file, boolean isSelected) {
        if (!file.exists()) {
            return this.absentFolderIcon;
        }
        try {
            return this.fileChooser.getIcon(file);
        }
        catch (Exception e) {
            return UIManager.getIcon(isSelected ? "Tree.openIcon" : "Tree.closedIcon");
        }
    }

    public Icon getLeafIcon(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            boolean isRootChild = null == parent.getParentFile();
            String name = file.getName();
            if (isRootChild && ("pagefile.sys".equals(name) || "hiberfil.sys".equals(name))) {
                return this.leafIcon;
            }
        }
        return !file.exists() ? this.absentLeafIcon : this.getIcon(file, false);
    }

    private FileSystemView getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.fileChooser.getFileSystemView();
        }
        return this.delegate;
    }

    private void installCachedIcons() {
        Icon folderIcon;
        this.leafIcon = UIManager.getIcon("FileView.fileIcon");
        if (this.leafIcon == null) {
            this.leafIcon = UIManager.getIcon("Tree.leafIcon");
        }
        if ((folderIcon = UIManager.getIcon("FileView.directoryIcon")) == null) {
            folderIcon = UIManager.getIcon("Tree.closedIcon");
        }
        Icon absentIcon = RESOURCES.getIcon("ExtFileSystemView.absentIcon");
        this.absentFolderIcon = new CompoundIcon(folderIcon, absentIcon, CompoundIcon.Anchor.SOUTHEAST);
        this.absentLeafIcon = new CompoundIcon(this.leafIcon, absentIcon, CompoundIcon.Anchor.SOUTHEAST);
        this.hardDriveIcon = UIManager.getIcon("FileView.hardDriveIcon");
        if (null == this.hardDriveIcon) {
            this.hardDriveIcon = UIManager.getIcon("Tree.closedIcon");
        }
        this.floppyDriveIcon = UIManager.getIcon("FileView.floppyDriveIcon");
        if (null == this.floppyDriveIcon) {
            this.floppyDriveIcon = this.hardDriveIcon;
        }
        this.homeFolderIcon = UIManager.getIcon("FileChooser.homeFolderIcon");
        if (null == this.homeFolderIcon) {
            this.homeFolderIcon = UIManager.getIcon("Tree.closedIcon");
        }
    }

    public static final class DirectoryTreeRenderer
    extends DefaultTreeCellRenderer {
        private final ExtFileSystemView fileSystemView;

        public DirectoryTreeRenderer(ExtFileSystemView fileSystemView) {
            this.fileSystemView = fileSystemView;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean focused) {
            super.getTreeCellRendererComponent(tree, value, isSelected, expanded, false, row, focused);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object userObject = node.getUserObject();
            if (null == userObject || !(userObject instanceof File)) {
                return this;
            }
            File directory = (File)userObject;
            this.setText(this.fileSystemView.getDirectoryName(directory));
            this.setIcon(this.fileSystemView.getIcon(directory, isSelected));
            return this;
        }
    }
}

