/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.base;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import pcgen.cdom.base.BasicClassIdentity;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.base.ChooseInformationUtilities;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.base.Chooser;
import pcgen.cdom.base.ClassIdentity;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.core.PlayerCharacter;
import pcgen.core.chooser.ChoiceManagerList;
import pcgen.core.chooser.UserInputManager;
import pcgen.rules.context.LoadContext;

public class UserChooseInformation
implements ChooseInformation<String>,
Chooser<String> {
    private static final ClassIdentity<String> STRING_INFO = BasicClassIdentity.getInstance(String.class);
    public static final String UCI_NAME = "User Input";
    private String title = null;

    @Override
    public ClassIdentity<String> getClassIdentity() {
        return STRING_INFO;
    }

    @Override
    public ChoiceManagerList<String> getChoiceManager(ChooseDriver owner, int cost) {
        return new UserInputManager(owner, this, cost);
    }

    @Override
    public GroupingState getGroupingState() {
        return GroupingState.ALLOWS_NONE;
    }

    @Override
    public String getLSTformat() {
        return "*USERINPUT";
    }

    @Override
    public String getName() {
        return UCI_NAME;
    }

    @Override
    public Collection<String> getSet(PlayerCharacter pc) {
        return Collections.singletonList("USERINPUT");
    }

    @Override
    public String getTitle() {
        return this.title == null ? "Provide User Input" : this.title;
    }

    @Override
    public CharSequence composeDisplay(Collection<? extends String> collection) {
        return ChooseInformationUtilities.buildEncodedString(this, collection);
    }

    @Override
    public void restoreChoice(PlayerCharacter pc, ChooseDriver owner, String choice) {
        pc.addAssoc(owner, this.getListKey(), choice);
    }

    @Override
    public List<String> getCurrentlySelected(ChooseDriver owner, PlayerCharacter pc) {
        return pc.getAssocList(owner, this.getListKey());
    }

    @Override
    public void applyChoice(ChooseDriver owner, String choice, PlayerCharacter pc) {
        this.restoreChoice(pc, owner, choice);
        List<ChooseSelectionActor<?>> actors = owner.getActors();
        if (actors != null) {
            for (ChooseSelectionActor<String> chooseSelectionActor : actors) {
                this.applyChoice(owner, pc, choice, chooseSelectionActor);
            }
        }
    }

    private void applyChoice(ChooseDriver owner, PlayerCharacter pc, String choice, ChooseSelectionActor<String> csa) {
        csa.applyChoice(owner, choice, pc);
    }

    @Override
    public void removeChoice(PlayerCharacter pc, ChooseDriver owner, String choice) {
        pc.removeAssoc(owner, this.getListKey(), choice);
        List<ChooseSelectionActor<?>> actors = owner.getActors();
        if (actors != null) {
            for (ChooseSelectionActor<?> csa : actors) {
                csa.removeChoice(owner, choice, pc);
            }
        }
    }

    @Override
    public Chooser<String> getChoiceActor() {
        return this;
    }

    @Override
    public void setChoiceActor(Chooser<String> actor) {
    }

    @Override
    public boolean allow(String choice, PlayerCharacter pc, boolean allowStack) {
        return true;
    }

    @Override
    public String decodeChoice(LoadContext context, String choice) {
        return choice;
    }

    @Override
    public String encodeChoice(String choice) {
        return choice;
    }

    public void setTitle(String chooseTitle) {
        this.title = chooseTitle;
    }

    private AssociationListKey<String> getListKey() {
        return AssociationListKey.getKeyFor(String.class, "CHOOSE*USERCHOICE");
    }
}

