/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.fact;

import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.analysis.LevelFacet;
import pcgen.cdom.facet.analysis.LevelTableFacet;
import pcgen.cdom.facet.base.AbstractItemFacet;
import pcgen.util.Logging;

public class XPFacet
extends AbstractItemFacet<CharID, Integer> {
    private LevelFacet levelFacet;
    private LevelTableFacet levelTableFacet;

    public boolean setEarnedXP(CharID id, int earnedXP) {
        return this.set(id, earnedXP);
    }

    public int getEarnedXP(CharID id) {
        Integer earnedXP = (Integer)this.get(id);
        return earnedXP == null ? 0 : earnedXP;
    }

    public int getXP(CharID id) {
        return this.getEarnedXP(id) + this.getLAXP(id);
    }

    private int getLAXP(CharID id) {
        return this.levelTableFacet.minXPForLevel(this.levelFacet.getLevelAdjustment(id) + 1, id);
    }

    public boolean setXP(CharID id, int xp) {
        int realXP = xp - this.getLAXP(id);
        if (realXP < 0) {
            Logging.errorPrint("ERROR: too little experience: " + realXP);
            realXP = 0;
        }
        return this.setEarnedXP(id, realXP);
    }

    public void setLevelFacet(LevelFacet levelFacet) {
        this.levelFacet = levelFacet;
    }

    public void setLevelTableFacet(LevelTableFacet levelTableFacet) {
        this.levelTableFacet = levelTableFacet;
    }
}

