/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.input;

import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.DomainSelectionFacet;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.PlayerCharacterTrackingFacet;
import pcgen.cdom.facet.model.DomainFacet;
import pcgen.cdom.helper.ClassSource;
import pcgen.core.Domain;
import pcgen.core.PlayerCharacter;
import pcgen.core.analysis.ChooseActivation;
import pcgen.core.chooser.ChoiceManagerList;
import pcgen.core.chooser.ChooserUtilities;

public class DomainInputFacet {
    private DomainFacet domainFacet;
    private DomainSelectionFacet domainSelectionFacet;
    private final PlayerCharacterTrackingFacet trackingFacet = FacetLibrary.getFacet(PlayerCharacterTrackingFacet.class);

    public boolean add(CharID id, Domain obj, ClassSource source) {
        PlayerCharacter pc = this.trackingFacet.getPC(id);
        if (pc.isAllowInteraction() && ChooseActivation.hasNewChooseToken(obj)) {
            ChoiceManagerList aMan = ChooserUtilities.getChoiceManager(obj, pc);
            return this.processChoice(id, pc, obj, aMan, source);
        }
        this.directSet(id, obj, null, source);
        return true;
    }

    private <T> boolean processChoice(CharID id, PlayerCharacter pc, Domain obj, ChoiceManagerList<T> aMan, ClassSource source) {
        List<T> newSelections;
        ArrayList selectedList = new ArrayList();
        ArrayList availableList = new ArrayList();
        aMan.getChoices(pc, availableList, selectedList);
        if (availableList.isEmpty()) {
            return false;
        }
        if (!selectedList.isEmpty()) {
            // empty if block
        }
        if ((newSelections = aMan.doChooser(pc, availableList, selectedList, new ArrayList<String>())).size() != 1) {
            return false;
        }
        for (T sel : newSelections) {
            this.directSet(id, obj, sel, source);
        }
        return true;
    }

    public void importSelection(CharID id, Domain obj, String choice, ClassSource source) {
        PlayerCharacter pc = this.trackingFacet.getPC(id);
        if (ChooseActivation.hasNewChooseToken(obj)) {
            String[] assoc;
            ChoiceManagerList aMan = ChooserUtilities.getChoiceManager(obj, pc);
            for (String string : assoc = choice.split(",", -1)) {
                if (string.startsWith("FEAT?")) {
                    int openloc = string.indexOf(40);
                    int closeloc = string.lastIndexOf(41);
                    string = string.substring(openloc + 1, closeloc);
                }
                this.processImport(id, obj, aMan, string, source);
            }
        } else {
            this.directSet(id, obj, null, source);
        }
    }

    private <T> void processImport(CharID id, Domain obj, ChoiceManagerList<T> aMan, String choice, ClassSource source) {
        this.directSet(id, obj, aMan.decodeChoice(choice), source);
    }

    public <T> void directSet(CharID id, Domain obj, T sel, ClassSource source) {
        this.domainFacet.add(id, obj, source);
        if (sel != null) {
            this.domainSelectionFacet.set(id, obj, sel);
        }
    }

    public void remove(CharID id, Domain obj) {
        PlayerCharacter pc = this.trackingFacet.getPC(id);
        if (pc.isAllowInteraction()) {
            this.domainSelectionFacet.remove(id, obj);
        }
        this.domainFacet.remove(id, obj);
    }

    public void setDomainSelectionFacet(DomainSelectionFacet domainSelectionFacet) {
        this.domainSelectionFacet = domainSelectionFacet;
    }

    public void setDomainFacet(DomainFacet domainFacet) {
        this.domainFacet = domainFacet;
    }
}

