/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import pcgen.base.util.HashMapToList;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Categorized;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.base.MasterListInterface;
import pcgen.cdom.content.ACControl;
import pcgen.cdom.content.RollMethod;
import pcgen.cdom.content.TabInfo;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.TransparentCategorizedReferenceManufacturer;
import pcgen.cdom.reference.TransparentReference;
import pcgen.core.AbilityCategory;
import pcgen.core.BioSet;
import pcgen.core.ClassType;
import pcgen.core.LevelInfo;
import pcgen.core.PlayerCharacter;
import pcgen.core.PointBuyCost;
import pcgen.core.PointBuyMethod;
import pcgen.core.SettingsHandler;
import pcgen.core.UnitSet;
import pcgen.core.XPTable;
import pcgen.core.character.WieldCategory;
import pcgen.core.system.LoadInfo;
import pcgen.facade.core.GameModeFacade;
import pcgen.rules.context.AbstractReferenceContext;
import pcgen.rules.context.ConsolidatedListCommitStrategy;
import pcgen.rules.context.GameReferenceContext;
import pcgen.rules.context.LoadContext;
import pcgen.rules.context.RuntimeLoadContext;
import pcgen.rules.context.RuntimeReferenceContext;
import pcgen.rules.context.TrackingReferenceContext;
import pcgen.system.PCGenSettings;
import pcgen.system.PropertyContext;
import pcgen.util.ComparableComparator;
import pcgen.util.Logging;
import pcgen.util.enumeration.Tab;

public final class GameMode
implements Comparable<Object>,
GameModeFacade {
    private static PropertyContext prefsContext = PCGenSettings.getInstance().createChildContext("gameMode");
    private PropertyContext gamemodePrefsContext = prefsContext.createChildContext("gameMode");
    private List<String> allowedModes;
    private List<String> bonusFeatLevels = new ArrayList<String>();
    private List<String> bonusStackList = new ArrayList<String>();
    private List<String> bonusStatLevels = new ArrayList<String>();
    private List<ClassType> classTypeList = new ArrayList<ClassType>();
    private List<String> defaultDataSetList = new ArrayList<String>();
    private List<String> defaultDeityList = new ArrayList<String>();
    private Map<String, XPTable> xpTableInfo = new HashMap<String, XPTable>();
    private List<String> loadStrings = new ArrayList<String>();
    private List<String> skillMultiplierLevels = new ArrayList<String>();
    private HashMapToList<String, ACControl> ACTypeAddMap = new HashMapToList();
    private HashMapToList<String, ACControl> ACTypeRemoveMap = new HashMapToList();
    private Map<String, String> plusCalcs;
    private Map<String, String> spellRangeMap = new HashMap<String, String>();
    private String acAbbrev = "";
    private String acName = "";
    private String alignmentName = "";
    private String althpAbbrev = "";
    private String althpName = "";
    private String babAbbrev = null;
    private String currencyUnit = "";
    private String currencyUnitAbbrev = "";
    private String damageResistance = "";
    private String defaultSpellBook = "Known Spells";
    private String defaultUnitSet = "Imperial";
    private UnitSet selectedUnitSet = null;
    private String displayName = "";
    private String displayVariable2Name = "";
    private String displayVariable2Text = "";
    private String displayVariable3Name = "";
    private String displayVariable3Text = "";
    private String displayVariableName = "";
    private String displayVariableText = "";
    private String folderName = "";
    private String hpAbbrev = "";
    private String hpName = "";
    private String levelUpMessage = "";
    private String menuToolTip = "";
    private String name = "";
    private String spellBaseDC = "0";
    private String spellBaseConcentration = "";
    private String wcStepsFormula = "";
    private String weaponCategories = "";
    private String weaponTypes = "";
    private String weaponReachFormula = "";
    private Map<Integer, Integer> xpAwardsMap = new HashMap<Integer, Integer>();
    private Map<Integer, String> crStepsMap = new HashMap<Integer, String>();
    private String crThreshold = null;
    private String rankModFormula = "";
    private String addWithMetamagic = "";
    private boolean allowAutoResize = false;
    private boolean bonusStatAllowsStack = false;
    private boolean showClassDefense;
    private int babAttCyc = 5;
    private int babMaxAtt = Integer.MAX_VALUE;
    private int babMaxLvl = Integer.MAX_VALUE;
    private int babMinVal = 1;
    private int maxNonEpicLevel = Integer.MAX_VALUE;
    private int checksMaxLvl = Integer.MAX_VALUE;
    private int displayOrder = Integer.MAX_VALUE;
    private final List<String> schoolsList = new ArrayList<String>(20);
    private int skillCosts_Class = 1;
    private int skillCost_CrossClass = 2;
    private int skillCost_Exclusive = 0;
    private String pointPoolName = "";
    private String hpFormula = "";
    private int nonProfPenalty = -4;
    private double squareSize = 5.0;
    private int shortRangeDistance;
    private int rangePenalty;
    private RollMethod activeRollMethod = null;
    private SortedMap<Integer, PointBuyCost> pointBuyStatCosts = null;
    private int[] abilityScoreCost = null;
    private String purchaseMethodName = "";
    private int rollMethod = 0;
    private int allStatsValue = 10;
    private int statMin = 3;
    private int statMax = 18;
    private TreeMap<Integer, String> statDisplayText = null;
    private String statDisplayTextAppend = "+";
    private TreeMap<Integer, String> skillRankDisplayText = null;
    private String thePreviewDir;
    private String theDefaultPreviewSheet;
    private String theInfoSheet;
    private String theInfoSheetSkill;
    private String outputSheetDirectory;
    private Map<String, String> outputSheetDefaultMap = new HashMap<String, String>();
    private int[] dieSizes;
    private int maxDieSize = 12;
    private int minDieSize = 4;
    private List<String> resizableTypeList = new ArrayList<String>();
    private List<String> characterTypeList = new ArrayList<String>();
    private List<String> monsterRoleList = new ArrayList<String>();
    private String monsterRoleDefault = "";
    private Map<Class<?>, Set<String>> hiddenTypes = new HashMap();
    private List<String> xpTableNames = new ArrayList<String>();
    private String defaultXPTableName;
    private String defaultCharacterType;
    private BioSet bioSet = new BioSet();
    private Map<CDOMSingleRef<TabInfo>, Boolean> visibleTabs;
    private Map<String, String> equipTypeIconMap = new HashMap<String, String>();
    private Map<String, Integer> equipTypeIconPriorityMap = new HashMap<String, Integer>();
    private AbilityCategory featTemplate;
    private ConsolidatedListCommitStrategy masterLCS = new ConsolidatedListCommitStrategy();
    private LoadContext context = new RuntimeLoadContext(this.getRefContext(), this.masterLCS);
    private GameReferenceContext gameRefContext = new GameReferenceContext();
    private LoadContext modeContext = new RuntimeLoadContext(this.gameRefContext, this.masterLCS);
    private String defaultSourceTitle;

    public GameMode(String modeName) {
        this.name = modeName;
        this.folderName = modeName;
        this.displayName = modeName;
        this.thePreviewDir = modeName;
        this.theDefaultPreviewSheet = "preview.html";
    }

    public void applyPreferences() {
        this.gamemodePrefsContext = prefsContext.createChildContext(this.name);
        String rollMethodExpr = this.gamemodePrefsContext.getProperty("rollMethodExpression");
        if (StringUtils.isNotBlank(rollMethodExpr)) {
            this.activeRollMethod = this.getModeContext().getReferenceContext().silentlyGetConstructedCDOMObject(RollMethod.class, rollMethodExpr);
            if (this.activeRollMethod == null) {
                Logging.errorPrint("Could not find roll method '" + rollMethodExpr + "' while loading game mode " + this.name);
            }
        }
        this.rollMethod = this.gamemodePrefsContext.getInt("rollMethod");
        this.allStatsValue = this.gamemodePrefsContext.initInt("allStatsValue", 10);
        this.purchaseMethodName = this.gamemodePrefsContext.getProperty("purchaseMethodName");
    }

    public void setACAbbrev(String aString) {
        this.acAbbrev = aString;
    }

    public void setACText(String aString) {
        this.acName = aString;
    }

    public List<ACControl> getACTypeAddString(String ACType) {
        return this.ACTypeAddMap.getListFor((Object)ACType);
    }

    public List<ACControl> getACTypeRemoveString(String ACType) {
        return this.ACTypeRemoveMap.getListFor((Object)ACType);
    }

    public String getACTypeName(String acType) {
        if (this.ACTypeAddMap.containsListFor((Object)acType) || this.ACTypeRemoveMap.containsListFor((Object)acType)) {
            return acType;
        }
        for (String acKey : this.ACTypeAddMap.getKeySet()) {
            if (!acKey.equalsIgnoreCase(acType)) continue;
            return acKey;
        }
        for (String acKey : this.ACTypeRemoveMap.getKeySet()) {
            if (!acKey.equalsIgnoreCase(acType)) continue;
            return acKey;
        }
        return acType;
    }

    public void setAlignmentText(String aString) {
        this.alignmentName = aString;
    }

    public void setAllowedModes(String argAllowedModes) {
        StringTokenizer aTok = new StringTokenizer(argAllowedModes, "|", false);
        while (aTok.hasMoreTokens()) {
            String aString = aTok.nextToken();
            if (this.allowedModes == null) {
                this.allowedModes = new ArrayList<String>();
            }
            this.allowedModes.add(aString);
        }
    }

    public void setAltHPAbbrev(String aString) {
        this.althpAbbrev = aString;
    }

    public void setAltHPText(String aString) {
        this.althpName = aString;
    }

    public void setAllowAutoResize(boolean allow) {
        this.allowAutoResize = allow;
    }

    public boolean getAllowAutoResize() {
        return this.allowAutoResize;
    }

    public void setBabAbbrev(String aString) {
        this.babAbbrev = aString;
    }

    public String getBabAbbrev() {
        return this.babAbbrev;
    }

    public void setBabMinVal(int arg) {
        this.babMinVal = arg;
    }

    public int getBabMinVal() {
        return this.babMinVal;
    }

    public void setBonusStatLevels(String aString) {
        this.bonusStatLevels.add(aString);
    }

    public void setChecksMaxLvl(int arg) {
        this.checksMaxLvl = arg;
    }

    public int getChecksMaxLvl() {
        return this.checksMaxLvl;
    }

    public ClassType getClassTypeByName(String aClassKey) {
        for (ClassType classType : this.classTypeList) {
            if (!classType.getName().equalsIgnoreCase(aClassKey)) continue;
            return classType;
        }
        return null;
    }

    public void setCurrencyUnit(String aString) {
        this.currencyUnit = aString;
    }

    public void setCurrencyUnitAbbrev(String aString) {
        this.currencyUnitAbbrev = aString;
    }

    public void setDamageResistanceText(String aString) {
        this.damageResistance = aString;
    }

    public void setDefaultSpellBook(String aString) {
        this.defaultSpellBook = aString;
    }

    public void setDefaultUnitSet(String aString) {
        this.defaultUnitSet = aString;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayOrder(String aString) {
        try {
            this.displayOrder = Integer.parseInt(aString);
        }
        catch (NumberFormatException exc) {
            Logging.errorPrint("Will use default for displayOrder: " + this.displayOrder, exc);
        }
    }

    public void setBonusFeatLevels(String aString) {
        this.bonusFeatLevels.add(aString);
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setHPAbbrev(String aString) {
        this.hpAbbrev = aString;
    }

    public void setHPText(String aString) {
        this.hpName = aString;
    }

    public void setRankModFormula(String aString) {
        this.rankModFormula = aString;
    }

    public XPTable getLevelInfo(String xpTableName) {
        return this.xpTableInfo.get(xpTableName);
    }

    public void addLevelInfo(String xpTableName, LevelInfo levInfo) {
        XPTable xpTable = this.xpTableInfo.get(xpTableName);
        if (xpTable == null) {
            xpTable = new XPTable(xpTableName);
            this.xpTableInfo.put(xpTableName, xpTable);
        }
        xpTable.addLevelInfo(levInfo.getLevelString(), levInfo);
    }

    public void setLevelUpMessage(String aString) {
        this.levelUpMessage = aString;
    }

    public String getLevelUpMessage() {
        return this.levelUpMessage;
    }

    public String getMenuToolTip() {
        if (this.menuToolTip == null) {
            return "";
        }
        return this.menuToolTip;
    }

    public void setModeName(String modeName) {
        this.displayName = modeName;
    }

    public void setModeToolTip(String aString) {
        this.menuToolTip = aString;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPlusCalculation(String type) {
        String aString = null;
        if (this.plusCalcs != null) {
            aString = this.plusCalcs.get(type.toUpperCase());
        }
        return aString;
    }

    public void setShortRangeDistance(int aShortRange) {
        this.shortRangeDistance = aShortRange;
    }

    public int getShortRangeDistance() {
        return this.shortRangeDistance;
    }

    public void setShowClassDefense(boolean argShowDef) {
        this.showClassDefense = argShowDef;
    }

    public void setSkillMultiplierLevels(String pipeList) {
        StringTokenizer aTok = new StringTokenizer(pipeList, "|", false);
        this.skillMultiplierLevels.clear();
        while (aTok.hasMoreTokens()) {
            this.skillMultiplierLevels.add(aTok.nextToken());
        }
    }

    public void setSpellBaseDC(String arg) {
        this.spellBaseDC = arg;
    }

    public String getSpellBaseDC() {
        return this.spellBaseDC;
    }

    public void setSpellBaseConcentration(String arg) {
        this.spellBaseConcentration = arg;
    }

    public String getSpellBaseConcentration() {
        return this.spellBaseConcentration;
    }

    public void setSpellRangeFormula(String aString) {
        StringTokenizer aTok = new StringTokenizer(aString, "|", false);
        if (aTok.countTokens() < 2) {
            return;
        }
        String aRange = aTok.nextToken().toUpperCase();
        String aFormula = aTok.nextToken();
        this.spellRangeMap.put(aRange, aFormula);
    }

    public String getSpellRangeFormula(String aRange) {
        String aString = null;
        if (this.spellRangeMap != null) {
            aString = this.spellRangeMap.get(aRange);
        }
        return aString;
    }

    public void setBabAttCyc(int arg) {
        this.babAttCyc = arg;
    }

    public int getBabAttCyc() {
        return this.babAttCyc;
    }

    public void setBabMaxAtt(int arg) {
        this.babMaxAtt = arg;
    }

    public int getBabMaxAtt() {
        return this.babMaxAtt;
    }

    public void setBabMaxLvl(int arg) {
        this.babMaxLvl = arg;
    }

    public int getBabMaxLvl() {
        return this.babMaxLvl;
    }

    public void setVariableDisplay2Name(String aString) {
        this.displayVariable2Name = aString;
    }

    public void setVariableDisplay2Text(String aString) {
        this.displayVariable2Text = aString;
    }

    public void setVariableDisplay3Name(String aString) {
        this.displayVariable3Name = aString;
    }

    public void setVariableDisplay3Text(String aString) {
        this.displayVariable3Text = aString;
    }

    public void setVariableDisplayName(String aString) {
        this.displayVariableName = aString;
    }

    public void setVariableDisplayText(String aString) {
        this.displayVariableText = aString;
    }

    public void setWCStepsFormula(String aString) {
        this.wcStepsFormula = aString;
    }

    public String getWCStepsFormula() {
        return this.wcStepsFormula;
    }

    public String getWeaponCategories() {
        return this.weaponCategories;
    }

    public String getWeaponTypes() {
        return this.weaponTypes;
    }

    public String getWeaponReachFormula() {
        return this.weaponReachFormula;
    }

    public Map<Integer, Integer> getXPAwards() {
        return this.xpAwardsMap;
    }

    public Map<Integer, String> getCRSteps() {
        return this.crStepsMap;
    }

    public Integer getCRInteger(String cr) {
        if (cr.startsWith("1/")) {
            for (Map.Entry<Integer, String> entry : this.crStepsMap.entrySet()) {
                if (!entry.getValue().equals(cr)) continue;
                return entry.getKey();
            }
            return null;
        }
        return Integer.parseInt(cr);
    }

    public String getCRThreshold() {
        return this.crThreshold;
    }

    public boolean isValidACType(String ACType) {
        return this.ACTypeAddMap.containsListFor((Object)ACType) || this.ACTypeRemoveMap.containsListFor((Object)ACType);
    }

    public void addACRemoves(String ACType, Collection<ACControl> controls) {
        this.ACTypeRemoveMap.addAllToListFor((Object)ACType, controls);
    }

    public void addACAdds(String ACType, Collection<ACControl> controls) {
        this.ACTypeAddMap.addAllToListFor((Object)ACType, controls);
    }

    public void addClassType(String aString) {
        if (".CLEAR".equals(aString)) {
            this.classTypeList = null;
            return;
        }
        if (this.classTypeList == null) {
            this.classTypeList = new ArrayList<ClassType>();
        }
        ClassType aClassType = new ClassType();
        StringTokenizer aTok = new StringTokenizer(aString, "\t");
        aClassType.setName(aTok.nextToken().intern());
        while (aTok.hasMoreTokens()) {
            String bString = aTok.nextToken();
            if (bString.startsWith("CRFORMULA:")) {
                aClassType.setCRFormula(bString.substring(10));
                continue;
            }
            if (bString.startsWith("CRMOD:")) {
                aClassType.setCRMod(bString.substring(6));
                continue;
            }
            if (bString.startsWith("CRMODPRIORITY:")) {
                try {
                    aClassType.setCRModPriority(new Integer(bString.substring(14)));
                }
                catch (NumberFormatException e) {
                    Logging.errorPrint("Illegal value for miscinfo.CLASSTYPE.CRMODPRIORITY: " + bString.substring(14));
                }
                continue;
            }
            if (bString.startsWith("XPPENALTY:")) {
                aClassType.setXPPenalty(bString.substring(10).equals("YES"));
                continue;
            }
            if (bString.startsWith("ISMONSTER:")) {
                aClassType.setMonster(bString.substring(10).equals("YES"));
                continue;
            }
            Logging.errorPrint("Incorrect tag in miscinfo.CLASSTYPE: " + bString);
        }
        this.classTypeList.add(aClassType);
    }

    public void addDefaultDataSet(String dataSetKey) {
        if (this.defaultDataSetList == null) {
            this.defaultDataSetList = new ArrayList<String>();
        }
        this.defaultDataSetList.add(dataSetKey);
    }

    public void clearDefaultDataSetList() {
        this.defaultDataSetList.clear();
    }

    public void addDeityList(String argDeityLine) {
        if (".CLEAR".equals(argDeityLine)) {
            this.defaultDeityList = null;
            return;
        }
        if (this.defaultDeityList == null) {
            this.defaultDeityList = new ArrayList<String>();
        }
        this.defaultDeityList.add(argDeityLine);
    }

    public void addLoadString(String aString) {
        this.loadStrings.add(aString);
    }

    public void addPlusCalculation(String aString) {
        int idx = aString.indexOf(124);
        if (idx > 0) {
            if (this.plusCalcs == null) {
                this.plusCalcs = new HashMap<String, String>();
            }
            this.plusCalcs.put(aString.substring(0, idx).toUpperCase(), aString.substring(idx + 1));
        }
    }

    public void addWeaponCategory(String aString) {
        this.weaponCategories = this.weaponCategories + '|' + aString;
    }

    public void addWeaponType(String aString) {
        this.weaponTypes = this.weaponTypes + '|' + aString;
    }

    public void addWieldCategory(WieldCategory wCat) {
        this.getModeContext().getReferenceContext().importObject(wCat);
    }

    public void setXPAwards(String aString) {
        String sTmp = "";
        StringTokenizer aTok = new StringTokenizer(aString, "|", false);
        while (aTok.hasMoreTokens()) {
            try {
                sTmp = aTok.nextToken();
                String[] xpAward = sTmp.split("=");
                this.xpAwardsMap.put(this.getCRInteger(xpAward[0]), new Integer(xpAward[1]));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Logging.errorPrint("Illegal value for miscinfo.XPAWARD: " + sTmp);
            }
            catch (NumberFormatException e) {
                Logging.errorPrint("Illegal value for miscinfo.XPAWARD: " + sTmp);
            }
        }
    }

    public void setCRSteps(String aString) {
        StringTokenizer aTok = new StringTokenizer(aString, "|", false);
        Integer index = 0;
        while (aTok.hasMoreTokens()) {
            this.crStepsMap.put(index, aTok.nextToken());
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index - 1);
        }
    }

    public void setCRThreshold(String aString) {
        this.crThreshold = aString;
    }

    @Override
    public int compareTo(Object obj) {
        if (obj != null) {
            int iOrder = ((GameMode)obj).getDisplayOrder();
            if (iOrder < this.displayOrder) {
                return 1;
            }
            if (iOrder > this.displayOrder) {
                return -1;
            }
            return this.name.compareToIgnoreCase(((GameMode)obj).name);
        }
        return 1;
    }

    public void setWeaponReachFormula(String aString) {
        this.weaponReachFormula = aString;
    }

    String getACAbbrev() {
        return this.acAbbrev;
    }

    public String getACText() {
        return this.acName;
    }

    String getAlignmentText() {
        return this.alignmentName;
    }

    public List<String> getAllowedModes() {
        if (this.allowedModes == null) {
            ArrayList<String> modes = new ArrayList<String>(1);
            modes.add(this.name);
            return modes;
        }
        return this.allowedModes;
    }

    String getAltHPAbbrev() {
        return this.althpAbbrev;
    }

    String getAltHPText() {
        return this.althpName;
    }

    List<String> getBonusFeatLevels() {
        return this.bonusFeatLevels;
    }

    List<String> getBonusStatLevels() {
        return this.bonusStatLevels;
    }

    @Override
    public String getCurrencyDisplay() {
        return this.currencyUnitAbbrev;
    }

    public String getDamageResistanceText() {
        return this.damageResistance;
    }

    String getDefaultSpellBook() {
        return this.defaultSpellBook;
    }

    String getDefaultUnitSet() {
        return this.defaultUnitSet;
    }

    List<String> getDeityList() {
        return this.defaultDeityList;
    }

    @Override
    public List<String> getDefaultDataSetList() {
        return this.defaultDataSetList;
    }

    int getDisplayOrder() {
        return this.displayOrder;
    }

    String getHPAbbrev() {
        return this.hpAbbrev;
    }

    String getHPText() {
        return this.hpName;
    }

    List<String> getLoadStrings() {
        return this.loadStrings;
    }

    String getLongCurrencyDisplay() {
        return this.currencyUnit;
    }

    public String getRankModFormula() {
        return this.rankModFormula;
    }

    boolean getShowClassDefense() {
        return this.showClassDefense;
    }

    List<String> getSkillMultiplierLevels() {
        return this.skillMultiplierLevels;
    }

    String getVariableDisplay2Name() {
        return this.displayVariable2Name;
    }

    String getVariableDisplay2Text() {
        return this.displayVariable2Text;
    }

    String getVariableDisplay3Name() {
        return this.displayVariable3Name;
    }

    String getVariableDisplay3Text() {
        return this.displayVariable3Text;
    }

    String getVariableDisplayName() {
        return this.displayVariableName;
    }

    String getVariableDisplayText() {
        return this.displayVariableText;
    }

    public void setRangePenalty(int value) {
        this.rangePenalty = value;
    }

    public int getRangePenalty() {
        return this.rangePenalty;
    }

    public void setSkillCost_Class(int value) {
        this.skillCosts_Class = value;
    }

    public void setSkillCost_CrossClass(int value) {
        this.skillCost_CrossClass = value;
    }

    public void setSkillCost_Exclusive(int value) {
        this.skillCost_Exclusive = value;
    }

    public int getSkillCost_Class() {
        return this.skillCosts_Class;
    }

    public int getSkillCost_CrossClass() {
        return this.skillCost_CrossClass;
    }

    public int getSkillCost_Exclusive() {
        return this.skillCost_Exclusive;
    }

    public void setPointPoolName(String argPoolName) {
        this.pointPoolName = argPoolName;
    }

    public String getPointPoolName() {
        return this.pointPoolName;
    }

    public void setNonProfPenalty(int argPenalty) {
        this.nonProfPenalty = argPenalty;
    }

    public int getNonProfPenalty() {
        return this.nonProfPenalty;
    }

    public void setHPFormula(String argFormula) {
        this.hpFormula = argFormula;
    }

    public String getHPFormula() {
        return this.hpFormula;
    }

    public void setAddWithMetamagicMessage(String argMsg) {
        this.addWithMetamagic = argMsg;
    }

    @Override
    public String getAddWithMetamagicMessage() {
        return this.addWithMetamagic;
    }

    public void setSquareSize(double argSize) {
        this.squareSize = argSize;
    }

    public double getSquareSize() {
        return this.squareSize;
    }

    public UnitSet getUnitSet() {
        return this.selectedUnitSet;
    }

    public boolean selectUnitSet(String unitSetName) {
        UnitSet ui = this.getModeContext().getReferenceContext().silentlyGetConstructedCDOMObject(UnitSet.class, unitSetName);
        if (ui == null) {
            return false;
        }
        this.selectedUnitSet = ui;
        return true;
    }

    public boolean selectDefaultUnitSet() {
        UnitSet ui = this.getModeContext().getReferenceContext().silentlyGetConstructedCDOMObject(UnitSet.class, this.defaultUnitSet);
        if (ui == null) {
            return false;
        }
        this.selectedUnitSet = ui;
        return true;
    }

    public void addPointBuyStatCost(PointBuyCost pbc) {
        if (this.pointBuyStatCosts == null) {
            this.pointBuyStatCosts = new TreeMap(new ComparableComparator());
        }
        this.abilityScoreCost = null;
        this.pointBuyStatCosts.put(pbc.getStatValue(), pbc);
    }

    public void clearPointBuyStatCosts() {
        this.pointBuyStatCosts = null;
        this.abilityScoreCost = null;
    }

    public SortedMap<Integer, PointBuyCost> getPointBuyStatCostMap() {
        return this.pointBuyStatCosts;
    }

    public PointBuyMethod getPurchaseMethodByName(String methodName) {
        return this.getModeContext().getReferenceContext().silentlyGetConstructedCDOMObject(PointBuyMethod.class, methodName);
    }

    public void setPurchaseMethodName(String argMethodName) {
        if (argMethodName.length() != 0) {
            this.setRollMethod(2);
        }
        this.purchaseMethodName = argMethodName;
        this.gamemodePrefsContext.setProperty("purchaseMethodName", argMethodName);
    }

    public int getPurchaseModeBaseStatScore(PlayerCharacter aPC) {
        int minVal = this.getPurchaseScoreMin(aPC);
        int x = this.getPurchaseScoreMax() - this.getPurchaseScoreMin() + 1;
        for (int i = 0; i < x; ++i) {
            if (this.getAbilityScoreCost(i) != 0 || this.getPurchaseScoreMin() + i < minVal) continue;
            return this.getPurchaseScoreMin() + i;
        }
        if (this.getPurchaseScoreMin() == minVal && --minVal < this.statMin) {
            minVal = this.statMin;
        }
        return minVal;
    }

    public String getPurchaseModeMethodName() {
        if (!this.isPurchaseStatMode()) {
            return null;
        }
        return this.purchaseMethodName;
    }

    public String getPurchaseModeMethodPoolFormula() {
        if (!this.isPurchaseStatMode()) {
            return "-1";
        }
        return this.getPurchaseMethodByName(this.purchaseMethodName).getPointFormula();
    }

    public int getPurchaseScoreMax() {
        if (this.pointBuyStatCosts == null) {
            return -1;
        }
        return this.pointBuyStatCosts.lastKey();
    }

    public int getPurchaseScoreMax(PlayerCharacter pc) {
        if (pc == null) {
            return this.getPurchaseScoreMax();
        }
        int lastStat = -1;
        if (this.pointBuyStatCosts != null) {
            for (Integer statValue : this.pointBuyStatCosts.keySet()) {
                PointBuyCost pbc = (PointBuyCost)this.pointBuyStatCosts.get(statValue);
                if (!pbc.qualifies(pc, null)) continue;
                lastStat = statValue;
            }
        }
        return lastStat;
    }

    public int getPurchaseScoreMin() {
        if (this.pointBuyStatCosts == null) {
            return -1;
        }
        return this.pointBuyStatCosts.firstKey();
    }

    public int getPurchaseScoreMin(PlayerCharacter pc) {
        if (pc == null) {
            return this.getPurchaseScoreMin();
        }
        int lastStat = -1;
        if (this.pointBuyStatCosts != null) {
            for (int statValue : this.pointBuyStatCosts.keySet()) {
                PointBuyCost pbc = (PointBuyCost)this.pointBuyStatCosts.get(statValue);
                if (!pbc.qualifies(pc, null)) continue;
                lastStat = statValue;
                break;
            }
        }
        return lastStat;
    }

    public boolean isPurchaseStatMode() {
        if (this.pointBuyStatCosts == null || this.pointBuyStatCosts.size() == 0 || this.getRollMethod() != 2 || this.purchaseMethodName.length() == 0) {
            return false;
        }
        return this.getPurchaseMethodByName(this.purchaseMethodName) != null;
    }

    public void setRollMethod(int argRollMethod) {
        this.rollMethod = argRollMethod;
        this.gamemodePrefsContext.setInt("rollMethod", argRollMethod);
        if (argRollMethod != 2) {
            this.setPurchaseMethodName("");
        }
    }

    public int getRollMethod() {
        return this.rollMethod;
    }

    public int[] getAbilityScoreCost() {
        if (!this.isPurchaseStatModeAllowed()) {
            return null;
        }
        if (this.abilityScoreCost != null) {
            return this.abilityScoreCost;
        }
        this.abilityScoreCost = new int[this.getPurchaseScoreMax() - this.getPurchaseScoreMin() + 1];
        int i = 0;
        int lastStat = Integer.MIN_VALUE;
        int lastCost = 0;
        for (int statValue : this.pointBuyStatCosts.keySet()) {
            if (lastStat != Integer.MIN_VALUE && lastStat + 1 != statValue) {
                for (int x = lastStat + 1; x < statValue; ++x) {
                    this.abilityScoreCost[i++] = lastCost;
                }
            }
            int statCost = ((PointBuyCost)this.pointBuyStatCosts.get(statValue)).getBuyCost();
            lastStat = statValue;
            lastCost = statCost;
            this.abilityScoreCost[i++] = lastCost;
        }
        return this.abilityScoreCost;
    }

    public int getAbilityScoreCost(int abilityScoreIndex) {
        int[] asc = this.getAbilityScoreCost();
        if (asc == null) {
            return 0;
        }
        return asc[abilityScoreIndex];
    }

    public void setRollMethodExpressionByName(String aString) {
        this.activeRollMethod = this.getModeContext().getReferenceContext().silentlyGetConstructedCDOMObject(RollMethod.class, aString);
        if (this.activeRollMethod == null) {
            this.setRollMethod(0);
        } else {
            this.setRollMethod(3);
        }
        this.gamemodePrefsContext.setProperty("rollMethodExpression", aString);
    }

    public String getRollMethodExpression() {
        if (this.activeRollMethod != null) {
            return this.activeRollMethod.getMethodRoll();
        }
        return "";
    }

    public String getRollMethodExpressionName() {
        if (this.activeRollMethod != null) {
            return this.activeRollMethod.getDisplayName();
        }
        return "";
    }

    public boolean isPurchaseStatModeAllowed() {
        return this.pointBuyStatCosts != null && this.pointBuyStatCosts.size() != 0;
    }

    public void setAllStatsValue(int argAllStatsValue) {
        this.allStatsValue = argAllStatsValue;
        this.gamemodePrefsContext.setInt("allStatsValue", argAllStatsValue);
    }

    public int getAllStatsValue() {
        return this.allStatsValue;
    }

    public RollMethod getCurrentRollingMethod() {
        return this.activeRollMethod;
    }

    public void setStatMin(int argMin) {
        this.statMin = argMin;
    }

    public int getStatMin() {
        return this.statMin;
    }

    public void setStatMax(int argMax) {
        this.statMax = argMax;
    }

    public int getStatMax() {
        return this.statMax;
    }

    public List<String> getUnmodifiableSchoolsList() {
        return Collections.unmodifiableList(this.schoolsList);
    }

    public void addToSchoolList(String school) {
        if (!this.schoolsList.contains(school)) {
            this.schoolsList.add(school);
        }
    }

    public void addStatDisplayText(int statValue, String statText) {
        if (this.statDisplayText == null) {
            this.statDisplayText = new TreeMap(new ComparableComparator());
        }
        this.statDisplayText.put(statValue, statText);
    }

    public String getStatDisplayText(int statValue) {
        String statText;
        if (this.statDisplayText == null) {
            statText = Integer.toString(statValue);
        } else {
            statText = this.statDisplayText.get(statValue);
            if (statText == null) {
                int firstKey = this.statDisplayText.firstKey();
                if (statValue < firstKey) {
                    statText = "???" + Integer.toString(statValue) + "???";
                } else {
                    int lastKey = this.statDisplayText.lastKey();
                    statText = this.getStatDisplayText(lastKey) + this.statDisplayTextAppend + this.getStatDisplayText(statValue - lastKey);
                }
            }
        }
        return statText;
    }

    public boolean hasSkillRankDisplayText() {
        return this.skillRankDisplayText != null;
    }

    public void addSkillRankDisplayText(int rankValue, String rankText) {
        if (this.skillRankDisplayText == null) {
            this.skillRankDisplayText = new TreeMap(new ComparableComparator());
        }
        this.skillRankDisplayText.put(rankValue, rankText);
    }

    public String getSkillRankDisplayText(int rankValue) {
        String rankText;
        if (this.skillRankDisplayText == null) {
            rankText = Integer.toString(rankValue);
        } else {
            rankText = this.skillRankDisplayText.get(rankValue);
            if (rankText == null) {
                int firstKey = this.skillRankDisplayText.firstKey();
                if (rankValue < firstKey) {
                    rankText = "???" + Integer.toString(rankValue) + "???";
                } else {
                    int lastKey = this.skillRankDisplayText.lastKey();
                    rankText = this.getSkillRankDisplayText(lastKey) + this.statDisplayTextAppend + this.getSkillRankDisplayText(rankValue - lastKey);
                }
            }
        }
        return rankText;
    }

    public void addToBonusStackList(String item) {
        if (!this.bonusStackList.contains(item)) {
            this.bonusStackList.add(item);
        }
    }

    public void clearBonusStacksList() {
        this.bonusStackList.clear();
    }

    public List<String> getUnmodifiableBonusStackList() {
        return Collections.unmodifiableList(this.bonusStackList);
    }

    public AbilityCategory getAbilityCategory(String aKey) {
        AbilityCategory ac = this.silentlyGetAbilityCategory(aKey);
        if (aKey == null || ac == null && aKey.length() > 0) {
            Logging.errorPrint("Attempt to fetch AbilityCategory: " + aKey + "... but it does not exist");
        }
        return ac;
    }

    public AbilityCategory silentlyGetAbilityCategory(String aKey) {
        AbilityCategory cat = this.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(AbilityCategory.class, aKey);
        if (cat != null) {
            return cat;
        }
        if (AbilityCategory.LANGBONUS.getKeyName().equals(aKey)) {
            return AbilityCategory.LANGBONUS;
        }
        return null;
    }

    public Collection<AbilityCategory> getAllAbilityCategories() {
        return this.getContext().getReferenceContext().getConstructedCDOMObjects(AbilityCategory.class);
    }

    public Collection<AbilityCategory> getAllAbilityCatsForKey(String key) {
        if (key == null) {
            return Collections.emptyList();
        }
        ArrayList<AbilityCategory> catList = new ArrayList<AbilityCategory>();
        for (AbilityCategory cat : this.getAllAbilityCategories()) {
            if (!key.equals(cat.getKeyName()) && !key.equals(cat.getParentCategory().getKeyName())) continue;
            catList.add(cat);
        }
        return Collections.unmodifiableCollection(catList);
    }

    public void setPreviewDir(String aDir) {
        this.thePreviewDir = aDir;
    }

    public String getPreviewDir() {
        return this.thePreviewDir;
    }

    public void setDefaultPreviewSheet(String aSheet) {
        this.theDefaultPreviewSheet = aSheet;
    }

    public String getDefaultPreviewSheet() {
        return this.theDefaultPreviewSheet;
    }

    public void setDieSizes(String value) {
        StringTokenizer aTok = new StringTokenizer(value, ",", false);
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (aTok.hasMoreTokens()) {
            String aString = aTok.nextToken();
            aString = aString.trim();
            try {
                int die;
                if (aString.contains("MIN=")) {
                    String[] t = aString.split("MIN=");
                    String minValue = t[1];
                    die = Integer.parseInt(minValue);
                    this.setMinDieSize(die);
                    list.add(die);
                    continue;
                }
                if (aString.contains("MAX=")) {
                    String[] t = aString.split("MAX=");
                    String maxValue = t[1];
                    die = Integer.parseInt(maxValue);
                    this.setMaxDieSize(die);
                    list.add(die);
                    continue;
                }
                int die2 = Integer.parseInt(aString);
                list.add(die2);
            }
            catch (NumberFormatException e) {
                Logging.errorPrint("Invalid integer value for DIESIZES: " + aString + ".  Original value: DIESIZES:" + value);
            }
        }
        if (list.size() == 0) {
            return;
        }
        int[] dieSizes = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            dieSizes[i] = (Integer)list.get(i);
        }
        list = null;
        this.setDieSizes(dieSizes);
    }

    public int getMaxDieSize() {
        return this.maxDieSize;
    }

    public void setMaxDieSize(int dice) {
        this.maxDieSize = dice;
    }

    public int getMinDieSize() {
        return this.minDieSize;
    }

    public void setMinDieSize(int dice) {
        this.minDieSize = dice;
    }

    public int[] getDieSizes() {
        return this.dieSizes;
    }

    public void setDieSizes(int[] die) {
        this.dieSizes = die;
    }

    public List<String> getResizableTypeList() {
        return Collections.unmodifiableList(this.resizableTypeList);
    }

    public void setResizableTypeList(List<String> resizableTypeList) {
        this.resizableTypeList = resizableTypeList;
    }

    public List<String> getCharacterTypeList() {
        return Collections.unmodifiableList(this.characterTypeList);
    }

    public void setCharacterTypeList(List<String> characterTypeList) {
        this.characterTypeList = characterTypeList;
    }

    public List<String> getMonsterRoleList() {
        return Collections.unmodifiableList(this.monsterRoleList);
    }

    public void setMonsterRoleList(List<String> monsterRoleList) {
        this.monsterRoleList = monsterRoleList;
    }

    public List<String> getMonsterRoleDefaultList() {
        return new ArrayList<String>(Arrays.asList(this.monsterRoleDefault));
    }

    public void setMonsterRoleDefault(String monsterRoleDefault) {
        this.monsterRoleDefault = monsterRoleDefault;
    }

    public void clearLoadContext() {
        this.masterLCS = new ConsolidatedListCommitStrategy();
        AbstractReferenceContext referenceContext = this.getRefContext();
        this.resolveInto(referenceContext);
        this.context = new RuntimeLoadContext(referenceContext, this.masterLCS);
    }

    public void resolveInto(AbstractReferenceContext referenceContext) {
        for (ReferenceManufacturer<?> rm : this.gameRefContext.getAllManufacturers()) {
            GameMode.resolveReferenceManufacturer(referenceContext, rm);
        }
    }

    private AbstractReferenceContext getRefContext() {
        if (SettingsHandler.inputUnconstructedMessages()) {
            return new TrackingReferenceContext();
        }
        return new RuntimeReferenceContext();
    }

    public static <T extends Loadable> void resolveReferenceManufacturer(AbstractReferenceContext rc, ReferenceManufacturer<T> rm) {
        ReferenceManufacturer mfg;
        Class c = rm.getReferenceClass();
        if (Categorized.class.isAssignableFrom(c)) {
            TransparentCategorizedReferenceManufacturer tcrm = (TransparentCategorizedReferenceManufacturer)rm;
            String category = tcrm.getCDOMCategory();
            Class catClass = tcrm.getCategoryClass();
            mfg = rc.getManufacturer(c, catClass, category);
        } else {
            mfg = rc.getManufacturer(c);
        }
        for (CDOMReference<T> ref : rm.getAllReferences()) {
            ((TransparentReference)((Object)ref)).resolve(mfg);
        }
        rm.injectConstructed(mfg);
    }

    public LoadContext getContext() {
        return this.context;
    }

    public LoadContext getModeContext() {
        return this.modeContext;
    }

    public MasterListInterface getMasterLists() {
        return this.masterLCS;
    }

    public void addHiddenType(Class<?> cl, String s) {
        Set<String> set = this.hiddenTypes.get(cl);
        if (set == null) {
            set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            this.hiddenTypes.put(cl, set);
        }
        set.add(s);
    }

    public String getDefaultXPTableName() {
        if (this.defaultXPTableName == null || this.defaultXPTableName.equals("") || !this.xpTableNames.contains(this.defaultXPTableName)) {
            if (this.xpTableNames.isEmpty()) {
                this.xpTableNames.add("Default");
            }
            this.defaultXPTableName = this.xpTableNames.get(0);
        }
        return this.defaultXPTableName;
    }

    public void setDefaultXPTableName(String xpTableName) {
        this.defaultXPTableName = xpTableName;
    }

    public List<String> getXPTableNames() {
        return this.xpTableNames;
    }

    public void addXPTableName(String xpTableName) {
        this.xpTableNames.add(xpTableName);
    }

    public String getDefaultCharacterType() {
        if (this.defaultCharacterType == null || this.defaultCharacterType.equals("") || !this.characterTypeList.contains(this.defaultCharacterType)) {
            if (this.characterTypeList.isEmpty()) {
                this.characterTypeList.add("Default");
            }
            this.defaultCharacterType = this.characterTypeList.get(0);
        }
        return this.defaultCharacterType;
    }

    public void setDefaultCharacterType(String characterType) {
        this.defaultCharacterType = characterType;
    }

    public boolean isBonusStatAllowsStack() {
        return this.bonusStatAllowsStack;
    }

    public void setBonusStatAllowsStack(boolean bonusStatAllowsStack) {
        this.bonusStatAllowsStack = bonusStatAllowsStack;
    }

    public BioSet getBioSet() {
        return this.bioSet;
    }

    public void setBioSet(BioSet bioSet) {
        this.bioSet = bioSet;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public void setDefaultSourceTitle(String title) {
        this.defaultSourceTitle = title;
    }

    @Override
    public String getDefaultSourceTitle() {
        return this.defaultSourceTitle;
    }

    @Override
    public String getTabName(Tab tab) {
        TabInfo ti = this.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(TabInfo.class, tab.toString());
        return ti.getResolvedName();
    }

    @Override
    public boolean getTabShown(Tab tab) {
        TabInfo ti = this.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(TabInfo.class, tab.toString());
        return ti.isVisible();
    }

    public void setTabVisible(CDOMSingleRef<TabInfo> ref, Boolean set) {
        if (this.visibleTabs == null) {
            this.visibleTabs = new HashMap<CDOMSingleRef<TabInfo>, Boolean>();
        }
        this.visibleTabs.put(ref, set);
    }

    public Boolean getTabVisibility(TabInfo ti) {
        if (this.visibleTabs == null) {
            return null;
        }
        for (Map.Entry<CDOMSingleRef<TabInfo>, Boolean> me : this.visibleTabs.entrySet()) {
            if (!ti.equals(me.getKey().resolvesTo())) continue;
            return me.getValue();
        }
        return null;
    }

    public LoadInfo getLoadInfo() {
        return this.getModeContext().getReferenceContext().silentlyGetConstructedCDOMObject(LoadInfo.class, this.getName());
    }

    @Override
    public String getInfoSheet() {
        return this.theInfoSheet;
    }

    public void setInfoSheet(String theInfoSheet) {
        this.theInfoSheet = theInfoSheet;
    }

    @Override
    public String getInfoSheetSkill() {
        return this.theInfoSheetSkill;
    }

    public void setInfoSheetSkill(String theInfoSheetSkill) {
        this.theInfoSheetSkill = theInfoSheetSkill;
    }

    public void setOutputSheetDirectory(String theOutputSheetDirectory) {
        this.outputSheetDirectory = theOutputSheetDirectory;
    }

    @Override
    public String getOutputSheetDirectory() {
        return this.outputSheetDirectory;
    }

    public void setOutputSheetDefault(String type, String sheet) {
        this.outputSheetDefaultMap.put(type, sheet);
    }

    @Override
    public String getOutputSheetDefault(String type) {
        return this.outputSheetDefaultMap.get(type);
    }

    public void setEquipTypeIcon(String equipType, String iconPath, int priority) {
        this.equipTypeIconMap.put(equipType.toUpperCase(), iconPath);
        this.equipTypeIconPriorityMap.put(equipType.toUpperCase(), priority);
    }

    public String getEquipTypeIcon(String equipType) {
        return this.equipTypeIconMap.get(equipType.toUpperCase());
    }

    public int getEquipTypeIconPriority(String equipType) {
        Integer priority = this.equipTypeIconPriorityMap.get(equipType.toUpperCase());
        return priority == null ? 0 : priority;
    }

    @Override
    public String getCharSheetDir() {
        return this.getPreviewDir();
    }

    @Override
    public String getDefaultCharSheet() {
        return this.getDefaultPreviewSheet();
    }

    @Override
    public String getHeightUnit() {
        if ("ftin".equals(this.getUnitSet().getHeightUnit())) {
            return "inches";
        }
        return this.getUnitSet().getHeightUnit();
    }

    @Override
    public String getWeightUnit() {
        return this.getUnitSet().getWeightUnit();
    }

    public AbilityCategory getFeatTemplate() {
        return this.featTemplate;
    }

    public void setFeatTemplate(AbilityCategory featTemplate) {
        this.featTemplate = featTemplate;
    }

    public void setMaxNonEpicLevel(int i) {
        this.maxNonEpicLevel = i;
    }

    public int getMaxNonEpicLevel() {
        return this.maxNonEpicLevel;
    }
}

