/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.mutable.MutableInt;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.CharacterLevelFacade;
import pcgen.facade.core.CharacterLevelsFacade;
import pcgen.facade.core.ClassFacade;
import pcgen.gui2.tools.Utility;
import pcgen.gui2.util.table.TableCellUtilities;
import pcgen.system.LanguageBundle;

public class PostLevelUpDialog
extends JDialog
implements ActionListener {
    private final CharacterLevelsFacade levels;
    private final LevelTableModel tableModel;
    private final int oldLevel;
    private int numLevels;

    private PostLevelUpDialog(Frame frame, CharacterFacade character, int oldLevel) {
        super(frame, true);
        this.oldLevel = oldLevel;
        this.levels = character.getCharacterLevelsFacade();
        this.numLevels = character.getCharacterLevelsFacade().getSize() - oldLevel;
        this.tableModel = new LevelTableModel();
        this.initComponents();
        this.pack();
    }

    public static void showPostLevelUpDialog(Component parent, CharacterFacade character, int oldLevel) {
        int size = character.getCharacterLevelsFacade().getSize();
        if (size - oldLevel + 1 < 1) {
            return;
        }
        Frame frame = JOptionPane.getFrameForComponent(parent);
        PostLevelUpDialog dialog = new PostLevelUpDialog(frame, character, oldLevel);
        Utility.setDialogRelativeLocation(frame, dialog);
        dialog.setVisible(true);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        JTable table = new JTable(this.tableModel){

            @Override
            public TableCellEditor getCellEditor(int row, int column) {
                if (column == 3 && row < PostLevelUpDialog.this.numLevels) {
                    String hd = PostLevelUpDialog.this.levels.getClassTaken((CharacterLevelFacade)PostLevelUpDialog.this.levels.getElementAt(row + PostLevelUpDialog.this.oldLevel)).getHD();
                    int max = NumberUtils.toInt(hd);
                    return new TableCellUtilities.SpinnerEditor(new SpinnerNumberModel(1, 1, max, 1));
                }
                return super.getCellEditor(row, column);
            }

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                if (column == 3 && row < PostLevelUpDialog.this.numLevels) {
                    return new TableCellUtilities.SpinnerRenderer();
                }
                return super.getCellRenderer(row, column);
            }
        };
        table.setCellSelectionEnabled(false);
        table.setRowHeight(new JSpinner().getPreferredSize().height);
        JTableHeader header = table.getTableHeader();
        header.setReorderingAllowed(false);
        JScrollPane scrollPane = new JScrollPane(table);
        pane.add((Component)scrollPane, "Center");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        JButton button = new JButton(LanguageBundle.getString("in_close"));
        button.setMnemonic(LanguageBundle.getMnemonic("in_mn_close"));
        button.setActionCommand("Close");
        button.addActionListener(this);
        box.add(button);
        pane.add((Component)box, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                PostLevelUpDialog.this.levels.removeHitPointListener(PostLevelUpDialog.this.tableModel);
            }
        });
        Utility.installEscapeCloseOperation(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }

    private class LevelTableModel
    extends AbstractTableModel
    implements CharacterLevelsFacade.HitPointListener {
        public static final int COL_LEVEL = 0;
        public static final int COL_CLASS = 1;
        public static final int COL_GAINED_HP = 2;
        public static final int COL_ROLLED_HP = 3;
        public static final int COL_SKILL_POINTS = 4;
        private final Object[] columns = new Object[]{LanguageBundle.getString("in_level"), LanguageBundle.getString("in_classString"), LanguageBundle.getString("in_luGainedHp"), LanguageBundle.getString("in_luRolledHp"), LanguageBundle.getString("in_luSkillPoints")};
        private final Object[][] data;
        private Map<ClassFacade, MutableInt> classLevelMap;

        public LevelTableModel() {
            this.data = new Object[PostLevelUpDialog.this.numLevels + 1][5];
            this.classLevelMap = new HashMap<ClassFacade, MutableInt>();
            int gainedTotal = 0;
            int rolledTotal = 0;
            int pointTotal = 0;
            for (int i = PostLevelUpDialog.this.oldLevel; i < PostLevelUpDialog.this.numLevels + PostLevelUpDialog.this.oldLevel; ++i) {
                CharacterLevelFacade level = (CharacterLevelFacade)PostLevelUpDialog.this.levels.getElementAt(i);
                Object[] dataRow = this.data[i - PostLevelUpDialog.this.oldLevel];
                dataRow[0] = i + 1;
                ClassFacade classFacade = PostLevelUpDialog.this.levels.getClassTaken(level);
                dataRow[1] = classFacade;
                if (!this.classLevelMap.containsKey(classFacade)) {
                    this.classLevelMap.put(classFacade, new MutableInt(0));
                }
                this.classLevelMap.get(classFacade).increment();
                dataRow[2] = PostLevelUpDialog.this.levels.getHPGained(level);
                gainedTotal += ((Integer)dataRow[2]).intValue();
                dataRow[3] = PostLevelUpDialog.this.levels.getHPRolled(level);
                rolledTotal += ((Integer)dataRow[3]).intValue();
                dataRow[4] = PostLevelUpDialog.this.levels.getGainedSkillPoints(level);
                pointTotal += ((Integer)dataRow[4]).intValue();
            }
            this.data[((PostLevelUpDialog)PostLevelUpDialog.this).numLevels][0] = LanguageBundle.getString("in_sumTotal");
            StringBuilder builder = new StringBuilder(100);
            Iterator<ClassFacade> classes = this.classLevelMap.keySet().iterator();
            while (classes.hasNext()) {
                ClassFacade c = classes.next();
                builder.append(c.getAbbrev()).append(' ');
                builder.append('(').append(this.classLevelMap.get(c)).append(')');
                if (!classes.hasNext()) continue;
                builder.append(", ");
            }
            this.data[((PostLevelUpDialog)PostLevelUpDialog.this).numLevels][1] = builder;
            this.data[((PostLevelUpDialog)PostLevelUpDialog.this).numLevels][2] = gainedTotal;
            this.data[((PostLevelUpDialog)PostLevelUpDialog.this).numLevels][3] = rolledTotal;
            this.data[((PostLevelUpDialog)PostLevelUpDialog.this).numLevels][4] = pointTotal;
            PostLevelUpDialog.this.levels.addHitPointListener(this);
        }

        @Override
        public int getRowCount() {
            return PostLevelUpDialog.this.numLevels + 1;
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 3: {
                    return rowIndex < PostLevelUpDialog.this.numLevels;
                }
            }
            return false;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 2: 
                case 3: 
                case 4: {
                    return Integer.class;
                }
            }
            return Object.class;
        }

        @Override
        public String getColumnName(int column) {
            return this.columns[column].toString();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data[rowIndex][columnIndex];
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            CharacterLevelFacade level = (CharacterLevelFacade)PostLevelUpDialog.this.levels.getElementAt(rowIndex + PostLevelUpDialog.this.oldLevel);
            PostLevelUpDialog.this.levels.setHPRolled(level, (Integer)aValue);
        }

        @Override
        public void hitPointsChanged(CharacterLevelsFacade.CharacterLevelEvent e) {
            int gainedTotal = 0;
            int rolledTotal = 0;
            for (int i = PostLevelUpDialog.this.oldLevel; i < PostLevelUpDialog.this.numLevels + PostLevelUpDialog.this.oldLevel; ++i) {
                CharacterLevelFacade level = (CharacterLevelFacade)PostLevelUpDialog.this.levels.getElementAt(i);
                Object[] dataRow = this.data[i - PostLevelUpDialog.this.oldLevel];
                dataRow[2] = PostLevelUpDialog.this.levels.getHPGained(level);
                gainedTotal += ((Integer)dataRow[2]).intValue();
                dataRow[3] = PostLevelUpDialog.this.levels.getHPRolled(level);
                rolledTotal += ((Integer)dataRow[3]).intValue();
            }
            this.data[((PostLevelUpDialog)PostLevelUpDialog.this).numLevels][2] = gainedTotal;
            this.data[((PostLevelUpDialog)PostLevelUpDialog.this).numLevels][3] = rolledTotal;
            this.fireTableRowsUpdated(0, this.data.length);
        }
    }
}

