/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang.StringUtils;
import pcgen.facade.core.CampaignFacade;
import pcgen.facade.core.InfoFacade;
import pcgen.gui2.filter.DisplayableFilter;
import pcgen.gui2.filter.FilterHandler;
import pcgen.gui2.tools.Icons;
import pcgen.system.LanguageBundle;

public class SearchFilterPanel
extends JPanel
implements DisplayableFilter<Object, Object>,
DocumentListener,
ActionListener {
    private FilterHandler filterHandler;
    private JTextField searchField = new JTextField();
    private JButton clearButton = new JButton(Icons.CloseX9.getImageIcon());

    public SearchFilterPanel() {
        this.searchField.getDocument().addDocumentListener(this);
        this.clearButton.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel(LanguageBundle.getString("in_filterLabel")), "West");
        this.add((Component)this.searchField, "Center");
        this.add((Component)this.clearButton, "East");
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.refreshFilter();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.refreshFilter();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.refreshFilter();
    }

    private void refreshFilter() {
        String text = this.searchField.getText();
        this.filterHandler.setSearchEnabled(text != null && text.length() > 0);
        this.filterHandler.refilter();
        this.filterHandler.scrollToTop();
    }

    @Override
    public boolean accept(Object context, Object element) {
        String typeStr = "";
        String abbStr = "";
        if (element instanceof InfoFacade) {
            typeStr = ((InfoFacade)element).getType();
        } else if (element instanceof CampaignFacade) {
            typeStr = ((CampaignFacade)element).getBookTypes();
            abbStr = ((CampaignFacade)element).getSourceShort();
        }
        String searchText = this.searchField.getText();
        return StringUtils.containsIgnoreCase(element.toString(), searchText) || StringUtils.containsIgnoreCase(typeStr, searchText) || StringUtils.containsIgnoreCase(abbStr, searchText);
    }

    @Override
    public Component getFilterComponent() {
        return this;
    }

    @Override
    public void setFilterHandler(FilterHandler handler) {
        this.filterHandler = handler;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.searchField.setText("");
    }
}

