/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.TreeSet;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.Ungranted;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.helper.FollowerLimit;
import pcgen.cdom.list.CompanionList;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.utils.ParsingSeparator;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class FollowersLst
implements CDOMPrimaryToken<CDOMObject> {
    @Override
    public String getTokenName() {
        return "FOLLOWERS";
    }

    @Override
    public ParseResult parseToken(LoadContext context, CDOMObject obj, String value) {
        if (obj instanceof Ungranted) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Ungranted object type: " + obj.getClass().getSimpleName(), context);
        }
        if (value == null || value.length() == 0) {
            return new ParseResult.Fail("Argument in " + this.getTokenName() + " cannot be empty", context);
        }
        ParsingSeparator sep = new ParsingSeparator(value, '|');
        String followerType = sep.next();
        if (followerType.length() == 0) {
            return new ParseResult.Fail("Follower Type in " + this.getTokenName() + " cannot be empty", context);
        }
        if (!sep.hasNext()) {
            return new ParseResult.Fail(this.getTokenName() + " has no PIPE character: " + "Must be of the form <follower type>|<formula>", context);
        }
        String followerNumber = sep.next();
        if (sep.hasNext()) {
            return new ParseResult.Fail(this.getTokenName() + " has too many PIPE characters: " + "Must be of the form <follower type>|<formula", context);
        }
        if (followerNumber.length() == 0) {
            return new ParseResult.Fail("Follower Count in " + this.getTokenName() + " cannot be empty", context);
        }
        CDOMSingleRef<CompanionList> cl = context.getReferenceContext().getCDOMReference(CompanionList.class, followerType);
        Formula num = FormulaFactory.getFormulaFor(followerNumber);
        if (!num.isValid()) {
            return new ParseResult.Fail("Number of Followers in " + this.getTokenName() + " was not valid: " + num.toString(), context);
        }
        context.getObjectContext().addToList(obj, ListKey.FOLLOWERS, new FollowerLimit(cl, num));
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject obj) {
        Changes<FollowerLimit> changes = context.getObjectContext().getListChanges(obj, ListKey.FOLLOWERS);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        TreeSet<String> returnSet = new TreeSet<String>();
        for (FollowerLimit fl : changes.getAdded()) {
            String followerType = fl.getCompanionList().getLSTformat(false);
            Formula followerNumber = fl.getValue();
            returnSet.add(followerType + "|" + followerNumber.toString());
        }
        return returnSet.toArray(new String[returnSet.size()]);
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

