/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.SkillCost;
import pcgen.cdom.reference.PatternMatchingReference;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Domain;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class CcskillToken
extends AbstractTokenWithSeparator<Domain>
implements CDOMPrimaryToken<Domain>,
ChooseSelectionActor<Skill> {
    private static final Class<Skill> SKILL_CLASS = Skill.class;

    @Override
    public String getTokenName() {
        return "CCSKILL";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, Domain obj, String value) {
        boolean first = true;
        boolean foundAny = false;
        boolean foundOther = false;
        StringTokenizer tok = new StringTokenizer(value, "|");
        while (tok.hasMoreTokens()) {
            String tokText = tok.nextToken();
            if (".CLEAR".equals(tokText)) {
                if (!first) {
                    return new ParseResult.Fail("  Non-sensical " + this.getTokenName() + ": .CLEAR was not the first list item", context);
                }
                context.getObjectContext().removeList(obj, ListKey.LOCALCCSKILL);
            } else if (tokText.startsWith(".CLEAR.")) {
                String clearText = tokText.substring(7);
                if ("ALL".equals(clearText)) {
                    context.getObjectContext().removeFromList(obj, ListKey.LOCALCCSKILL, context.getReferenceContext().getCDOMAllReference(SKILL_CLASS));
                } else if ("LIST".equals(clearText)) {
                    context.getObjectContext().removeFromList(obj, ListKey.NEW_CHOOSE_ACTOR, this);
                } else {
                    CDOMReference<Skill> ref = TokenUtilities.getTypeOrPrimitive(context, SKILL_CLASS, clearText);
                    if (ref == null) {
                        return new ParseResult.Fail("  Error was encountered while parsing " + this.getTokenName(), context);
                    }
                    context.getObjectContext().removeFromList(obj, ListKey.LOCALCCSKILL, ref);
                }
            } else if ("ALL".equals(tokText)) {
                foundAny = true;
                context.getObjectContext().addToList(obj, ListKey.LOCALCCSKILL, context.getReferenceContext().getCDOMAllReference(SKILL_CLASS));
            } else {
                foundOther = true;
                if ("LIST".equals(tokText)) {
                    context.getObjectContext().addToList(obj, ListKey.NEW_CHOOSE_ACTOR, this);
                } else {
                    CDOMReference<Skill> ref = this.getSkillReference(context, tokText);
                    if (ref == null) {
                        return new ParseResult.Fail("  Error was encountered while parsing " + this.getTokenName(), context);
                    }
                    context.getObjectContext().addToList(obj, ListKey.LOCALCCSKILL, ref);
                }
            }
            first = false;
        }
        if (foundAny && foundOther) {
            return new ParseResult.Fail("Non-sensical " + this.getTokenName() + ": Contains ANY and a specific reference: " + value, context);
        }
        return ParseResult.SUCCESS;
    }

    private CDOMReference<Skill> getSkillReference(LoadContext context, String tokText) {
        if (tokText.endsWith("%")) {
            return new PatternMatchingReference<Skill>(Skill.class, context.getReferenceContext().getCDOMAllReference(SKILL_CLASS), tokText);
        }
        return TokenUtilities.getTypeOrPrimitive(context, SKILL_CLASS, tokText);
    }

    @Override
    public String[] unparse(LoadContext context, Domain obj) {
        Collection<ChooseSelectionActor<?>> listAdded;
        Collection<CDOMReference<Skill>> added;
        Collection<ChooseSelectionActor<?>> listRemoved;
        Changes<CDOMReference<Skill>> changes = context.getObjectContext().getListChanges(obj, ListKey.LOCALCCSKILL);
        Changes<ChooseSelectionActor<?>> listChanges = context.getObjectContext().getListChanges(obj, ListKey.NEW_CHOOSE_ACTOR);
        ArrayList<String> list = new ArrayList<String>();
        Collection<CDOMReference<Skill>> removedItems = changes.getRemoved();
        if (removedItems != null && !removedItems.isEmpty()) {
            if (changes.includesGlobalClear()) {
                context.addWriteMessage("Non-sensical relationship in " + this.getTokenName() + ": global .CLEAR and local .CLEAR. performed");
                return null;
            }
            list.add(".CLEAR." + ReferenceUtilities.joinLstFormat(removedItems, "|.CLEAR."));
        }
        if ((listRemoved = listChanges.getRemoved()) != null && !listRemoved.isEmpty() && listRemoved.contains(this)) {
            list.add(".CLEAR.LIST");
        }
        if (changes.includesGlobalClear()) {
            list.add(".CLEAR");
        }
        if ((added = changes.getAdded()) != null && !added.isEmpty()) {
            list.add(ReferenceUtilities.joinLstFormat(added, "|"));
        }
        if ((listAdded = listChanges.getAdded()) != null && !listAdded.isEmpty()) {
            for (ChooseSelectionActor<?> cra : listAdded) {
                if (!cra.getSource().equals(this.getTokenName())) continue;
                try {
                    list.add(cra.getLstFormat());
                }
                catch (PersistenceLayerException e) {
                    context.addWriteMessage("Error writing Prerequisite: " + e);
                    return null;
                }
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public Class<Domain> getTokenClass() {
        return Domain.class;
    }

    @Override
    public void applyChoice(ChooseDriver obj, Skill skill, PlayerCharacter pc) {
        PCClass pcc = pc.getDomainSource((Domain)obj).getPcclass();
        pc.addLocalCost(pcc, skill, SkillCost.CROSS_CLASS, obj);
    }

    @Override
    public void removeChoice(ChooseDriver obj, Skill skill, PlayerCharacter pc) {
        PCClass pcc = pc.getDomainSource((Domain)obj).getPcclass();
        pc.removeLocalCost(pcc, skill, SkillCost.CROSS_CLASS, obj);
    }

    @Override
    public String getSource() {
        return this.getTokenName();
    }

    @Override
    public String getLstFormat() {
        return "LIST";
    }

    @Override
    public Class<Skill> getChoiceClass() {
        return SKILL_CLASS;
    }
}

