/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OneToOneMap<K, V> {
    private final Map<K, V> forwardMap = new HashMap();
    private final Map<V, K> reverseMap = new HashMap<V, K>();

    public void clear() {
        this.forwardMap.clear();
        this.reverseMap.clear();
    }

    public boolean containsKey(Object key) {
        return this.forwardMap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.reverseMap.containsKey(value);
    }

    public V get(Object key) {
        return this.forwardMap.get(key);
    }

    public K getKeyFor(Object key) {
        return this.reverseMap.get(key);
    }

    public boolean isEmpty() {
        return this.forwardMap.isEmpty();
    }

    public Set<K> keySet() {
        return new HashSet<K>(this.forwardMap.keySet());
    }

    public V put(K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("Key may not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value may not be null");
        }
        K oldKey = this.reverseMap.get(value);
        V oldValue = this.forwardMap.get(key);
        this.forwardMap.remove(oldKey);
        this.reverseMap.remove(oldValue);
        this.forwardMap.put(key, value);
        this.reverseMap.put(value, key);
        return oldValue;
    }

    public V remove(Object key) {
        V value = this.forwardMap.remove(key);
        this.reverseMap.remove(value);
        return value;
    }

    public int size() {
        return this.forwardMap.size();
    }

    public Collection<V> values() {
        return new HashSet<V>(this.reverseMap.keySet());
    }

    public String toString() {
        return "OneToOneMap: " + this.forwardMap.toString();
    }
}

