/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools.ant;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.UniqueIdentity;
import org.java.plugin.tools.ant.BaseJpfTask;
import org.java.plugin.tools.configuration.PluginArchiver;

public class SingleFilePluginTask
extends BaseJpfTask {
    private File destDir;

    public void setDestDir(File file) {
        this.destDir = file;
    }

    public void execute() throws BuildException {
        File file;
        UniqueIdentity uniqueIdentity;
        if (this.destDir == null) {
            throw new BuildException("destdir attribute must be set!", this.getLocation());
        }
        this.initRegistry(true);
        this.log("Creating plug-in files...");
        int n = 0;
        Iterator iterator = this.getRegistry().getPluginDescriptors().iterator();
        while (iterator.hasNext()) {
            uniqueIdentity = (PluginDescriptor)iterator.next();
            file = new File(this.destDir, uniqueIdentity.getId() + "-" + uniqueIdentity.getVersion() + ".zip");
            try {
                PluginArchiver.pack((PluginDescriptor)uniqueIdentity, this.getPathResolver(), file);
            }
            catch (IOException iOException) {
                throw new BuildException("failed building plug-in file " + file, (Throwable)iOException, this.getLocation());
            }
            if (this.getVerbose()) {
                this.log("Created plug-in file " + file);
            }
            ++n;
        }
        iterator = this.getRegistry().getPluginFragments().iterator();
        while (iterator.hasNext()) {
            uniqueIdentity = (PluginFragment)iterator.next();
            file = new File(this.destDir, uniqueIdentity.getId() + "-" + uniqueIdentity.getVersion() + ".zip");
            try {
                PluginArchiver.pack((PluginFragment)uniqueIdentity, this.getPathResolver(), file);
            }
            catch (IOException iOException) {
                throw new BuildException("failed building plug-in fragment file " + file, (Throwable)iOException, this.getLocation());
            }
            if (this.getVerbose()) {
                this.log("Created plug-in fragment file " + file);
            }
            ++n;
        }
        this.log("... " + n + " plug-in files created");
    }
}

