/* 
    TowBowlTactics: Adaptation of the tabletop game Blood Bowl

    Copyright (C) 2001-2003 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef TEAM_H
#define TEAM_H

#include "global.h"
#include "Player.h"
#include "Formation.h"
#include "Dice.h"

/**
 * Classe representant une equipe de blood bowl
 * @doc 
 * @author Toweld
 * @version 0.5
*/

class Team{
 public:

	/** Constructeur par defaut */
//	Team();
	/** Constructeur avec 7 parametres 
	* @param n nom de l'equipe
	* @param c nom du coach
	* @param a race de l'equipe
	* @param t valeur du tresor 
	* @param cl nombre pom-pom-girls (tres important!!!)
	* @param h nombre d'assistant
	* @param r nombre de relances
	* @param p popularite 
	* @param rc prix d'une relance
	* @param e embleme
	* @param i id de l'equipe TEAM1 ou TEAM2
	*/
	Team(char*,char*,char*,int,int,int,int,int,int,char*,int);

	/// Destructeur
	~Team();
	/** Changer le nom de l'equipe
	* @param n nouveau nom de l'equipe
	*/

	void set_team_id(int);
	void set_name(char*);

	/** Obtenir le nom de l'equipe
	* @return le nom actuel de l'equipe
	*/
	char* get_name();
	/** Changer la race de l'equipe
	* @param n nouvelle race de l'equipe
	*/
	void set_race(char*);
	/** Obtenir la race de l'equipe
	* @return la race de l'equipe
	*/
	char* get_race();
	/** Changer l'id de l'equipe
	* @param id nouvel id de l'equipe
	*/
	void set_id(int);
	/** Obtenir l'id de l'equipe
	* @return l'id actuel de l'equipe
	*/
	int get_id();
	void set_reroll_cost(int);
	int get_reroll_cost();
	/** Changer le nom du coach
	* @param c nouveau nom du coach
	*/
	void set_coach(char*);
	/** Obtenir le nom du coach
	* @return le nom actuel du coach
	*/
	char* get_coach();
	void set_formations_file(char*);
	char* get_formations_file();

	void set_apothecary(int);
	int get_apothecary();

	void set_wizard(int);
	int get_wizard();
 
	void set_treasury(int);
	int get_treasury();
  
	void set_rating(int);
	int get_rating();
  
	/** Changer le nombre de pom-pom-girls d'une equipe
	* @param cl nouveau nombre de pom-pom-girls
	*/
	void set_cheer_leaders(int);
	/** Obtenir le nombre de pom-pom-girls
	* @return le nombre de pom-pom-girls
	*/
	int get_cheer_leaders();
	/** Changer le nombre d'assistant
	* @param h nombre d'assistant
	*/
	void set_assistant(int);
	/** Obtenir le nombre d'assistant
	* @return nombre d'assistant
	*/
	int get_assistant();
	/** Changer le nombre de relances
	* @param r nombre de relances
	*/
	void set_reroll(int);
	/** Obtenir le nombre de relance restante
	* @return le nombre de relance restante
	*/
	void set_reroll_init(int);
	int get_reroll();
	/** Changer le score de l'equipe
	* @param s nouveau score
	*/
	void set_score(int);
	/** Obtenir le score de l'equipe
	* @return score de l'equipe
	*/
	int get_score();
	/** Changer le turn de l'equipe
	* @param s nouveau turn
	*/
	void set_fan_factor(int);
	int get_fan_factor();
	void set_turn(int);
	/** Obtenir le tour de l'equipe
	* @return tour de l'equipe
	*/
	int get_turn();
	/** Associer une lot de joueur a une equipe
	* @param lot pointeur sur ensemble de joueur du type map<int,Player*> 
	*/
	void set_players(map<int,Player*>*);
	/** Obtenir les joueurs d'une equipe
	* @return un pointeur sur une structure du type map<int,Player*> 
	*/
	map<int,Player*>* get_players();
	/** Pour savoir si une equipe a deja utilise une relance d'equipe
	* @return true si deja utilisee, false sinon 
	*/
	bool is_reroll_used();
	/** Pour rajouter un joueur dans l'equipe
	* @param p pointeur sur Player a ajouter a l'equipe 
	*/

	void add_player(Player*);
 	void add_player(Player*,int);

	/** Pour virer un joueur de l'equipe
	* @param i number du joueur a virer
	*/
	void remove_player(int);
	/** Pour obtenir un joueur de l'equipe grace a sa number 
	* @param i number du joueur qu'on veut
	* @return pointeur sur Player
	*/
	Player* get_player(int); 
	/** Pour ajouter une formation  
	* @param f pointeur sur Formation a ajouter 
	*/
	void add_formation(Formation*); 
	/** Pour supprimer une formation  
	* @param s identifiant de la formation a supprimer 
	*/
	void remove_formation(int);
	/** Pour consulter une formation par son identifiant
	* @param i id de la formation
	* @return pointeur sur Formation
	*/
	Formation* get_formation(int);
	/** Resultat du coup d'envoi
	* @return entier entre 2 et 12, representant le resultat obtenu sur le tableau des resultats du coup d'envoi 
	*/
	int get_kick_off_result();
	/** Resultat du coup d'envoi
	* @return nombre de case de deviation pour le ballon 
	*/
	int get_kick_off_distance(); 
	/** Resultat du coup d'envoi
	* @return direction prise par le ballon sur le coup d'envoi 
	*/
	int get_kick_off_direction(); 
	/** Obtenir un joueur au hasard parmis ceux sur le terrain
	* @return pointeur sur Player choisit 
	*/
	Player* get_random_player();
	/** Obtenir un joueur au hasard parmis ceux sur le terrain
	* @return number du joueur choisit
	*/
	int get_random_player_num(); 
	/** Pour savoir si un joueur appartient bien a une equipe
	* @return true, si appratient, false sinon
	*/
	bool contain_player_num(int); 
	/** Pour discuter les decisions de l'arbitre
	* @return 1 si l'arbitre ne veut rien entendre et conchie le coach, 2-5 si l 'arbitre s'en bat les couil... , 6, si l'arbitre admet qu'il a tord
	*/
	int buy_referee(); 
	/** Savoir s'il est possible d'effectuer une relance
	* @return true, si possibilite d'effectuer une relance, false sinon
	*/
	bool can_reroll(); 
	
	bool can_complain();
	void set_can_complain(bool);

	void prepare_for_next_turn();

	void set_blitz_done(bool);
	bool is_blitz_done();
 
	void set_aggress_done(bool);
	bool is_aggress_done();
  
	void set_throw_done(bool);
	bool is_throw_done();
 
	void set_throw_team_mate_done(bool);
	bool is_throw_team_mate_done();
 
	void set_transmit_done(bool);
	bool is_transmit_done();

	void inc_turn(void);
	void inc_score(void);

	void set_referee_intimidated(bool);
	bool has_intimidated_referee(void);

	void set_has_free_turn(bool);
	bool has_free_turn(void);

	void set_ejected(int);
	int get_ejected();
	
	void set_ko(int);
	int get_ko();
	
	void set_out(int);
	int get_out();
	
	void set_reserve(int);
	int get_reserve();

	void inc_ejected(void);
	void inc_ko(void);
	void inc_out(void);
	void inc_reserve(void);

	void inc_reroll(void);
	void decr_reroll(void);
 
	void reset_reroll(void);

	void set_reroll_used(bool);

	int on_playground_player_count(void);
	
	void transfer_players_to_reserve(void);

	void set_emblem(char*);
	char* get_emblem(void);

	void adopt_formation(int);
	void adopt_formation(Formation*);

	bool is_placed(void);
	void set_placed(bool);

	void save_state(FILE *,int);

	bool can_use_kick_skill();


 protected:
	char* name; // nom de l'equipe
	char* coach; // nom du coach
	char* race; // race de l'equipe
	char* emblem;
	char* formations_file;
	int treasury; // valeur du tresor
	int cheer_leaders; // nombre de cheer_leaders
	int assistant; // nombre d'assistant
	int reroll; // nmbre de relance d'equipe
	int reroll_cost; // prix d'une relance
	int score; // score de l'equipe
	int turn; // tour de l'equipe
	map<int,Player*> *players; // joueurs d'une equipe
	map<int,Formation*> *formations; // formations d'une equipe
	bool reroll_used; // a deja utilise une relance sur ce tour
	int id;
	bool blitz_done;
	bool aggress_done;
	bool throw_done;
	bool throw_team_mate_done;
	bool transmit_done;
	int ejected;
	int out;
	int reserve;
	int ko;
	bool complain_ok;
	int fan_factor;
	int reroll_init;
	bool referee_intimidated;
	bool free_turn;
	int apothecary;
	int wizard;
	int rating;
	bool placed;

	Dice *d6;
	Dice *d8;
	Dice *d16;
};

#endif


