/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.streams.Steps;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SimpleType;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.module.AbstractPipelineModuleImpl;
import org.dita.dost.module.reader.TempFileNameScheme;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.reader.GenListModuleReader;
import org.dita.dost.reader.KeyrefReader;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.KeyDef;
import org.dita.dost.util.KeyScope;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.ConkeyrefFilter;
import org.dita.dost.writer.KeyrefParser;
import org.dita.dost.writer.TopicFragmentFilter;
import org.xml.sax.XMLFilter;

final class KeyrefModule
extends AbstractPipelineModuleImpl {
    private TempFileNameScheme tempFileNameScheme;
    final Set<URI> normalProcessingRole = new HashSet<URI>();
    final Map<URI, Integer> usage = new HashMap<URI, Integer>();

    KeyrefModule() {
    }

    @Override
    public void setJob(Job job) {
        super.setJob(job);
        try {
            this.tempFileNameScheme = (TempFileNameScheme)Class.forName(job.getProperty("temp-file-name-scheme")).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        this.tempFileNameScheme.setBaseDir(job.getInputDir());
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        Collection fis;
        if (this.fileInfoFilter == null) {
            this.fileInfoFilter = f -> f.format == null || f.format.equals("dita") || f.format.equals("ditamap");
        }
        if (!(fis = (Collection)this.job.getFileInfo(this.fileInfoFilter).stream().filter(f -> f.hasKeyref).collect(Collectors.toSet())).isEmpty()) {
            try {
                String cls = Optional.ofNullable(this.job.getProperty("temp-file-name-scheme")).orElse(Configuration.configuration.get("temp-file-name-scheme"));
                this.tempFileNameScheme = (TempFileNameScheme)Class.forName(cls).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            this.tempFileNameScheme.setBaseDir(this.job.getInputDir());
            KeyrefReader reader = new KeyrefReader();
            reader.setLogger(this.logger);
            reader.setXmlUtils(this.xmlUtils);
            Job.FileInfo in = this.job.getFileInfo(fi -> fi.isInput).iterator().next();
            URI mapFile = in.uri;
            XdmNode doc = this.readMap(in);
            this.logger.info("Reading " + String.valueOf(this.job.tempDirURI.resolve(mapFile)));
            reader.read(this.job.tempDirURI.resolve(mapFile), doc);
            KeyScope startScope = reader.getKeyDefinition();
            Collection<Job.FileInfo> resourceMapFis = this.job.getFileInfo(fi -> fi.isInputResource && Objects.equals(fi.format, "ditamap"));
            KeyScope rootScope = resourceMapFis.stream().map(fi -> {
                try {
                    XdmNode d = this.readMap((Job.FileInfo)fi);
                    this.logger.info("Reading " + String.valueOf(this.job.tempDirURI.resolve(fi.uri)));
                    KeyrefReader r = new KeyrefReader();
                    r.setLogger(this.logger);
                    r.read(this.job.tempDirURI.resolve(fi.uri), d);
                    KeyScope s = r.getKeyDefinition();
                    this.logger.debug("Writing " + String.valueOf(this.job.tempDirURI.resolve(fi.uri)));
                    this.writeMap((Job.FileInfo)fi, d);
                    return s;
                }
                catch (DITAOTException e) {
                    throw new RuntimeException(e);
                }
            }).reduce(startScope, KeyScope::merge);
            Set topicsInMap = doc.select(Steps.descendant(Constants.MAP_TOPICREF.matcher()).where(XMLUtils.isDitaFormat()).then(Steps.attribute((String)"href"))).map(node -> {
                URI href = URLUtils.stripFragment(this.job.tempDirURI.resolve(mapFile).resolve(node.getStringValue()));
                return this.job.tempDirURI.relativize(href).toString();
            }).collect(Collectors.toSet());
            Collection<Job.FileInfo> resourceTopicsFis = this.job.getFileInfo(fi -> !topicsInMap.contains(fi.uri) && (Objects.equals(fi.format, "dita") || fi.format == null));
            List<Job.FileInfo> resourceFis = Stream.concat(resourceMapFis.stream(), resourceTopicsFis.stream()).toList();
            List<ResolveTask> jobs = this.collectProcessingTopics(in, resourceFis, rootScope, doc);
            ConcurrentHashMap topicIdCache = new ConcurrentHashMap();
            (this.parallel ? (Stream)jobs.stream().parallel() : jobs.stream()).filter(r -> r.out != null).forEach(r -> this.processFile((ResolveTask)r, topicIdCache));
            (this.parallel ? (Stream)jobs.stream().parallel() : jobs.stream()).filter(r -> r.out == null).forEach(r -> this.processFile((ResolveTask)r, topicIdCache));
            for (URI file : this.normalProcessingRole) {
                Job.FileInfo f2 = this.job.getFileInfo(file);
                if (f2 == null) continue;
                f2.isResourceOnly = false;
                this.job.add(f2);
            }
            try {
                this.job.write();
            }
            catch (IOException e) {
                throw new DITAOTException("Failed to store job state: " + e.getMessage(), e);
            }
        }
        return null;
    }

    private List<ResolveTask> collectProcessingTopics(Job.FileInfo map, Collection<Job.FileInfo> fis, KeyScope rootScope, XdmNode doc) throws DITAOTException {
        assert (doc.getNodeKind() == XdmNodeKind.DOCUMENT);
        ArrayList<ResolveTask> res = new ArrayList<ResolveTask>();
        res.add(new ResolveTask(rootScope, map, null));
        Destination destination = null;
        try {
            URI file = this.job.tempDirURI.resolve(map.uri);
            this.logger.debug("Writing " + String.valueOf(file));
            destination = this.job.getStore().getDestination(file);
            PipelineConfiguration pipe = doc.getUnderlyingNode().getConfiguration().makePipelineConfiguration();
            NamespaceReducer receiver = new NamespaceReducer(destination.getReceiver(pipe, new SerializationProperties()));
            receiver.open();
            this.walkMap(map, doc, Collections.singletonList(rootScope), res, (Receiver)receiver);
            receiver.close();
        }
        catch (IOException | SaxonApiException | XPathException e) {
            throw new DITAOTException("Failed to write map: " + e.getMessage(), e);
        }
        finally {
            try {
                destination.close();
            }
            catch (SaxonApiException e) {
                throw new DITAOTException("Failed to write map: " + e.getMessage(), e);
            }
        }
        for (Job.FileInfo f : fis) {
            if (this.usage.containsKey(f.uri)) continue;
            res.add(this.processTopic(f, rootScope, f.isResourceOnly));
        }
        List<ResolveTask> deduped = this.removeDuplicateResolveTargets(res);
        if (this.fileInfoFilter != null) {
            return this.adjustResourceRenames(deduped.stream().filter(rs -> this.fileInfoFilter.test(rs.in)).collect(Collectors.toList()));
        }
        return this.adjustResourceRenames(deduped);
    }

    private List<ResolveTask> removeDuplicateResolveTargets(List<ResolveTask> renames) {
        return renames.stream().collect(Collectors.groupingBy(rt -> rt.scope, Collectors.toMap(rt -> rt.in.uri, Function.identity(), (rt1, rt2) -> rt1))).values().stream().flatMap(m -> m.values().stream()).collect(Collectors.toList());
    }

    List<ResolveTask> adjustResourceRenames(List<ResolveTask> renames) {
        Map<KeyScope, List<ResolveTask>> scopes = renames.stream().collect(Collectors.groupingBy(rt -> rt.scope));
        ArrayList<ResolveTask> res = new ArrayList<ResolveTask>();
        for (Map.Entry<KeyScope, List<ResolveTask>> group : scopes.entrySet()) {
            KeyScope scope = group.getKey();
            List<ResolveTask> tasks = group.getValue();
            Map<URI, URI> rewrites = tasks.stream().filter(t -> t.out != null).collect(Collectors.toMap(t -> t.in.uri, t -> t.out.uri));
            KeyScope resScope = this.rewriteScopeTargets(scope, rewrites);
            tasks.stream().map(t -> new ResolveTask(resScope, t.in, t.out)).forEach(res::add);
        }
        return res;
    }

    KeyScope rewriteScopeTargets(KeyScope scope, Map<URI, URI> rewrites) {
        HashMap<String, KeyDef> newKeys = new HashMap<String, KeyDef>();
        for (Map.Entry<String, KeyDef> key : scope.keyDefinition().entrySet()) {
            KeyDef oldKey = key.getValue();
            URI href = oldKey.href;
            if (href != null && rewrites.containsKey(URLUtils.stripFragment(href))) {
                href = URLUtils.setFragment(rewrites.get(URLUtils.stripFragment(href)), href.getFragment());
            }
            KeyDef newKey = new KeyDef(oldKey.keys, href, oldKey.scope, oldKey.format, oldKey.source, oldKey.element, oldKey.version);
            newKeys.put(key.getKey(), newKey);
        }
        return new KeyScope(scope.id(), scope.name(), newKeys, scope.childScopes().stream().map(c -> this.rewriteScopeTargets((KeyScope)c, rewrites)).collect(Collectors.toList()));
    }

    private QName getReferenceAttribute(XdmNode elem) {
        assert (elem.getNodeKind() == XdmNodeKind.ELEMENT);
        QName rewriteAttrName = new QName("copy-to");
        if (elem.getAttributeValue(rewriteAttrName) != null) {
            return rewriteAttrName;
        }
        rewriteAttrName = new QName("href");
        if (elem.getAttributeValue(rewriteAttrName) != null) {
            return rewriteAttrName;
        }
        if (Constants.SUBMAP.matches(elem) && elem.getAttributeValue(rewriteAttrName = new QName("dita-ot", "http://dita-ot.sourceforge.net/ns/201007/dita-ot", "orig-href")) != null) {
            return rewriteAttrName;
        }
        return null;
    }

    void walkMap(Job.FileInfo map, XdmNode node, List<KeyScope> scope, List<ResolveTask> res, Receiver receiver) throws XPathException {
        switch (node.getNodeKind()) {
            case ELEMENT: {
                if (Constants.MAP_MAP.matches(node) || Constants.MAP_TOPICREF.matches(node)) {
                    URI referenceValue;
                    List<KeyScope> ss = node.attribute("keyscope") != null ? Stream.of(node.attribute("keyscope").trim().split("\\s+")).flatMap(keyscope -> scope.stream().map(s -> s.getChildScope((String)keyscope))).filter(Objects::nonNull).collect(Collectors.toList()) : scope;
                    NodeInfo ni = node.getUnderlyingNode();
                    AttributeMap atts = ni.attributes();
                    QName rewriteAttrName = this.getReferenceAttribute(node);
                    if (rewriteAttrName != null && (referenceValue = URLUtils.toURI(node.getAttributeValue(rewriteAttrName))) != null) {
                        for (KeyScope s : ss) {
                            ResolveTask resolveTask;
                            URI resolved = map.uri.resolve(referenceValue);
                            String fragment = resolved.getFragment();
                            URI href = URLUtils.stripFragment(resolved);
                            Job.FileInfo fi = this.job.getFileInfo(href);
                            if (fi == null || !fi.hasKeyref) continue;
                            int count = this.usage.getOrDefault(fi.uri, 0);
                            Optional<ResolveTask> existing = res.stream().filter(rt -> rt.scope.equals(s) && rt.in.uri.equals(fi.uri)).findAny();
                            if (count != 0 && existing.isPresent()) {
                                resolveTask = existing.get();
                                if (resolveTask.out == null) continue;
                                referenceValue = this.tempFileNameScheme.generateTempFileName(resolveTask.out.result);
                                if (fragment == null || referenceValue.getFragment() != null) continue;
                                referenceValue = URLUtils.setFragment(referenceValue, fragment);
                                continue;
                            }
                            resolveTask = this.processTopic(fi, s, DitaUtils.isResourceOnly(node));
                            res.add(resolveTask);
                            Integer used = this.usage.get(fi.uri);
                            if (used <= 1) continue;
                            referenceValue = this.tempFileNameScheme.generateTempFileName(resolveTask.out.result);
                            this.fixKeyDefRefs(s, fi.uri, referenceValue);
                            if (fragment == null || referenceValue.getFragment() != null) continue;
                            referenceValue = URLUtils.setFragment(referenceValue, fragment);
                        }
                        atts = atts.put(new AttributeInfo(this.toNodeName(rewriteAttrName), (SimpleType)BuiltInAtomicType.STRING, referenceValue.toString(), (Location)Loc.NONE, 0));
                    }
                    receiver.startElement(NameOfNode.makeName((NodeInfo)ni), ni.getSchemaType(), atts, ni.getAllNamespaces(), ni.saveLocation(), 0);
                    for (XdmNode c : node.children()) {
                        this.walkMap(map, c, ss, res, receiver);
                    }
                    receiver.endElement();
                    break;
                }
                NodeInfo ni = node.getUnderlyingNode();
                receiver.startElement((NodeName)new FingerprintedQName(ni.getPrefix(), ni.getNamespaceUri(), ni.getLocalPart()), ni.getSchemaType(), ni.attributes(), ni.getAllNamespaces(), ni.saveLocation(), 0);
                for (XdmNode c : node.children()) {
                    this.walkMap(map, c, scope, res, receiver);
                }
                receiver.endElement();
                break;
            }
            case DOCUMENT: {
                receiver.startDocument(0);
                for (XdmNode c : node.children()) {
                    this.walkMap(map, c, scope, res, receiver);
                }
                receiver.endDocument();
                break;
            }
            default: {
                receiver.append((Item)node.getUnderlyingNode());
            }
        }
    }

    private NodeName toNodeName(QName qName) {
        StructuredQName structuredQName = qName.getStructuredQName();
        return new FingerprintedQName(structuredQName.getPrefix(), structuredQName.getNamespaceUri(), structuredQName.getLocalPart());
    }

    private void fixKeyDefRefs(KeyScope scope, URI original, URI renamed) {
        block0: for (KeyDef keyDef : scope.keyDefinition().values()) {
            if (keyDef == null || !Objects.equals(keyDef.href, original) || keyDef.keys == null) continue;
            String prefix = scope.name() + ".";
            for (String key : keyDef.keys.split("\\s")) {
                if (!key.startsWith(prefix)) continue;
                keyDef.href = renamed;
                continue block0;
            }
        }
    }

    private ResolveTask processTopic(Job.FileInfo f, KeyScope scope, boolean isResourceOnly) {
        int increment = isResourceOnly && !GenListModuleReader.isFormatDita(f.format) ? 0 : 1;
        Integer used = this.usage.containsKey(f.uri) ? this.usage.get(f.uri) + increment : increment;
        this.usage.put(f.uri, used);
        if (used > 1) {
            URI result = URLUtils.addSuffix(f.result, "-" + (used - 1));
            URI out = this.tempFileNameScheme.generateTempFileName(result);
            Job.FileInfo fo = new Job.FileInfo.Builder(f).uri(out).result(result).build();
            this.job.add(fo);
            return new ResolveTask(scope, f, fo);
        }
        return new ResolveTask(scope, f, null);
    }

    private void processFile(ResolveTask r, Map<URI, String> topicIdCache) {
        ArrayList<XMLFilter> filters = new ArrayList<XMLFilter>();
        ConkeyrefFilter conkeyrefFilter = new ConkeyrefFilter();
        conkeyrefFilter.setLogger(this.logger);
        conkeyrefFilter.setJob(this.job);
        conkeyrefFilter.setKeyDefinitions(r.scope);
        conkeyrefFilter.setCurrentFile(this.job.tempDirURI.resolve(r.in.uri));
        filters.add(conkeyrefFilter);
        TopicFragmentFilter topicFragmentFilter = new TopicFragmentFilter("conref", "conrefend");
        filters.add(topicFragmentFilter);
        KeyrefParser parser = new KeyrefParser();
        parser.setLogger(this.logger);
        parser.setJob(this.job);
        parser.setKeyDefinition(r.scope);
        parser.setCurrentFile(this.job.tempDirURI.resolve(r.in.uri));
        parser.setTopicIdCache(topicIdCache);
        filters.add(parser);
        try {
            this.logger.debug("Using " + (String)(r.scope.name() != null ? r.scope.name() + " scope" : "root scope"));
            if (r.out != null) {
                this.logger.info("Processing " + String.valueOf(this.job.tempDirURI.resolve(r.in.uri)) + " to " + String.valueOf(this.job.tempDirURI.resolve(r.out.uri)));
                this.job.getStore().transform(this.job.tempDirURI.resolve(r.in.uri), this.job.tempDirURI.resolve(r.out.uri), filters);
            } else {
                this.logger.info("Processing " + String.valueOf(this.job.tempDirURI.resolve(r.in.uri)));
                this.job.getStore().transform(this.job.tempDirURI.resolve(r.in.uri), filters);
            }
            this.normalProcessingRole.addAll(parser.getNormalProcessingRoleTargets());
        }
        catch (DITAOTException e) {
            this.logger.error("Failed to process key references: " + e.getMessage(), e);
        }
    }

    private XdmNode readMap(Job.FileInfo input) throws DITAOTException {
        try {
            URI in = this.job.tempDirURI.resolve(input.uri);
            return this.job.getStore().getImmutableNode(in);
        }
        catch (Exception e) {
            throw new DITAOTException("Failed to parse map: " + e.getMessage(), e);
        }
    }

    private void writeMap(Job.FileInfo in, XdmNode doc) throws DITAOTException {
        try {
            URI file = this.job.tempDirURI.resolve(in.uri);
            this.job.getStore().writeDocument(doc, file);
        }
        catch (IOException e) {
            throw new DITAOTException("Failed to write map: " + e.getMessage(), e);
        }
    }

    record ResolveTask(KeyScope scope, Job.FileInfo in, Job.FileInfo out) {
        public ResolveTask {
            Objects.requireNonNull(scope);
            Objects.requireNonNull(in);
        }
    }
}

