/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.parser.core;

import com.vladsch.flexmark.ast.BlockQuote;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.util.Parsing;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.parser.core.FencedCodeBlockParser;
import com.vladsch.flexmark.parser.core.HeadingParser;
import com.vladsch.flexmark.parser.core.HtmlBlockParser;
import com.vladsch.flexmark.parser.core.IndentedCodeBlockParser;
import com.vladsch.flexmark.parser.core.ListBlockParser;
import com.vladsch.flexmark.parser.core.ThematicBreakParser;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.mappers.SpecialLeadInHandler;
import com.vladsch.flexmark.util.sequence.mappers.SpecialLeadInStartsWithCharsHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockQuoteParser
extends AbstractBlockParser {
    public static final char MARKER_CHAR = '>';
    private final BlockQuote block = new BlockQuote();
    private final boolean allowLeadingSpace;
    private final boolean continueToBlankLine;
    private final boolean ignoreBlankLine;
    private final boolean interruptsParagraph;
    private final boolean interruptsItemParagraph;
    private final boolean withLeadSpacesInterruptsItemParagraph;
    private int lastWasBlankLine = 0;

    public BlockQuoteParser(DataHolder options, BasedSequence marker) {
        this.block.setOpeningMarker(marker);
        this.continueToBlankLine = (Boolean)Parser.BLOCK_QUOTE_EXTEND_TO_BLANK_LINE.get(options);
        this.allowLeadingSpace = (Boolean)Parser.BLOCK_QUOTE_ALLOW_LEADING_SPACE.get(options);
        this.ignoreBlankLine = (Boolean)Parser.BLOCK_QUOTE_IGNORE_BLANK_LINE.get(options);
        this.interruptsParagraph = (Boolean)Parser.BLOCK_QUOTE_INTERRUPTS_PARAGRAPH.get(options);
        this.interruptsItemParagraph = (Boolean)Parser.BLOCK_QUOTE_INTERRUPTS_ITEM_PARAGRAPH.get(options);
        this.withLeadSpacesInterruptsItemParagraph = (Boolean)Parser.BLOCK_QUOTE_WITH_LEAD_SPACES_INTERRUPTS_ITEM_PARAGRAPH.get(options);
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean isPropagatingLastBlankLine(BlockParser lastMatchedBlockParser) {
        return false;
    }

    @Override
    public boolean canContain(ParserState state, BlockParser blockParser, Block block) {
        return true;
    }

    @Override
    public BlockQuote getBlock() {
        return this.block;
    }

    @Override
    public void closeBlock(ParserState state) {
        this.block.setCharsFromContent();
        if (!((Boolean)Parser.BLANK_LINES_IN_AST.get((DataHolder)state.getProperties())).booleanValue()) {
            this.removeBlankLines();
        }
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        boolean isMarker;
        int nextNonSpace = state.getNextNonSpaceIndex();
        if (!state.isBlank() && ((isMarker = BlockQuoteParser.isMarker(state, nextNonSpace, false, false, this.allowLeadingSpace, this.interruptsParagraph, this.interruptsItemParagraph, this.withLeadSpacesInterruptsItemParagraph)) || this.continueToBlankLine && this.lastWasBlankLine == 0)) {
            int newColumn = state.getColumn() + state.getIndent();
            this.lastWasBlankLine = 0;
            if (isMarker) {
                ++newColumn;
                if (Parsing.isSpaceOrTab((CharSequence)state.getLine(), nextNonSpace + 1)) {
                    ++newColumn;
                }
            }
            return BlockContinue.atColumn(newColumn);
        }
        if (this.ignoreBlankLine && state.isBlank()) {
            ++this.lastWasBlankLine;
            int newColumn = state.getColumn() + state.getIndent();
            return BlockContinue.atColumn(newColumn);
        }
        return BlockContinue.none();
    }

    static boolean isMarker(ParserState state, int index, boolean inParagraph, boolean inParagraphListItem, boolean allowLeadingSpace, boolean interruptsParagraph, boolean interruptsItemParagraph, boolean withLeadSpacesInterruptsItemParagraph) {
        BasedSequence line = state.getLine();
        if (!(inParagraph && !interruptsParagraph || index >= line.length() || line.charAt(index) != '>' || !allowLeadingSpace && state.getIndent() != 0 || inParagraphListItem && !interruptsItemParagraph)) {
            if (inParagraphListItem && !withLeadSpacesInterruptsItemParagraph) {
                return state.getIndent() == 0;
            }
            return state.getIndent() < state.getParsing().CODE_BLOCK_INDENT;
        }
        return false;
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private final boolean allowLeadingSpace;
        private final boolean interruptsParagraph;
        private final boolean interruptsItemParagraph;
        private final boolean withLeadSpacesInterruptsItemParagraph;

        BlockFactory(DataHolder options) {
            super(options);
            this.allowLeadingSpace = (Boolean)Parser.BLOCK_QUOTE_ALLOW_LEADING_SPACE.get(options);
            this.interruptsParagraph = (Boolean)Parser.BLOCK_QUOTE_INTERRUPTS_PARAGRAPH.get(options);
            this.interruptsItemParagraph = (Boolean)Parser.BLOCK_QUOTE_INTERRUPTS_ITEM_PARAGRAPH.get(options);
            this.withLeadSpacesInterruptsItemParagraph = (Boolean)Parser.BLOCK_QUOTE_WITH_LEAD_SPACES_INTERRUPTS_ITEM_PARAGRAPH.get(options);
        }

        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            boolean inParagraphListItem;
            int nextNonSpace = state.getNextNonSpaceIndex();
            BlockParser matched = matchedBlockParser.getBlockParser();
            boolean inParagraph = matched.isParagraphParser();
            boolean bl = inParagraphListItem = inParagraph && matched.getBlock().getParent() instanceof ListItem && matched.getBlock() == matched.getBlock().getParent().getFirstChild();
            if (BlockQuoteParser.isMarker(state, nextNonSpace, inParagraph, inParagraphListItem, this.allowLeadingSpace, this.interruptsParagraph, this.interruptsItemParagraph, this.withLeadSpacesInterruptsItemParagraph)) {
                int newColumn = state.getColumn() + state.getIndent() + 1;
                if (Parsing.isSpaceOrTab((CharSequence)state.getLine(), nextNonSpace + 1)) {
                    ++newColumn;
                }
                return BlockStart.of(new BlockQuoteParser((DataHolder)state.getProperties(), state.getLine().subSequence(nextNonSpace, nextNonSpace + 1))).atColumn(newColumn);
            }
            return BlockStart.none();
        }
    }

    static class BlockQuoteLeadInHandler {
        static final SpecialLeadInHandler HANDLER = SpecialLeadInStartsWithCharsHandler.create((char)'>');

        BlockQuoteLeadInHandler() {
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return Collections.emptySet();
        }

        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return new HashSet(Arrays.asList(HeadingParser.Factory.class, FencedCodeBlockParser.Factory.class, HtmlBlockParser.Factory.class, ThematicBreakParser.Factory.class, ListBlockParser.Factory.class, IndentedCodeBlockParser.Factory.class));
        }

        @Override
        @Nullable
        public SpecialLeadInHandler getLeadInHandler(@NotNull DataHolder options) {
            return BlockQuoteLeadInHandler.HANDLER;
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        @Override
        @NotNull
        public BlockParserFactory apply(@NotNull DataHolder options) {
            return new BlockFactory(options);
        }
    }
}

