/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.cmdline.sqltool;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class Calculator {
    private List<Atom> atoms = new ArrayList<Atom>();
    private static Pattern intPattern = Pattern.compile("[+-]?\\d+");
    private Map<String, String> vars;
    private EnumSet<MathOp> TradOrLParen = EnumSet.of(MathOp.ADD, new MathOp[]{MathOp.SUBTRACT, MathOp.LPAREN, MathOp.MULTIPLY, MathOp.DIVIDE, MathOp.REM, MathOp.POWER});

    private long deref(String string) {
        if (!this.vars.containsKey(string)) {
            throw new IllegalStateException("Undefined variable: " + string);
        }
        try {
            return Long.parseLong(this.vars.get(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalStateException("Variable's value not an integer: " + string);
        }
    }

    public String toString() {
        return this.atoms.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Calculator(String[] stringArray, Map<String, String> map) {
        if (map.size() < 1) {
            throw new IllegalArgumentException("No expression supplied");
        }
        this.vars = map;
        Atom atom = null;
        for (String string : stringArray) {
            try {
                Atom atom2;
                atom = new Atom(string);
                int n = this.atoms.size() - 1;
                if (n < 0 || this.atoms.get((int)n).op != MathOp.SUBTRACT) continue;
                Atom atom3 = atom2 = n > 0 ? this.atoms.get(n - 1) : null;
                if (atom2 != null && !this.TradOrLParen.contains((Object)atom2.op)) continue;
                if (atom.op == null) {
                    this.atoms.remove(n);
                    atom.val *= -1L;
                    continue;
                }
                if (atom.op != MathOp.LPAREN) continue;
                this.atoms.remove(n);
                this.atoms.add(new Atom(-1L));
                this.atoms.add(new Atom(MathOp.MULTIPLY));
            }
            finally {
                this.atoms.add(atom);
            }
        }
    }

    public Calculator(String string, Map<String, String> map) {
        this(string.replaceAll("([-()*/+^])", " $1 ").trim().split("\\s+"), map);
    }

    public long reduce(int n, boolean bl) {
        long l;
        MathOp mathOp;
        Atom atom;
        int n2;
        Atom atom2;
        Object var4_3 = null;
        int n3 = n - 1;
        block8: while (this.atoms.size() >= ++n3) {
            if (this.atoms.size() == n3) {
                if (!bl) break;
                throw new IllegalStateException("Unbalanced '" + MathOp.LPAREN + "'");
            }
            atom2 = this.atoms.get(n3);
            if (atom2.op == null) continue;
            switch (atom2.op) {
                case RPAREN: {
                    if (!bl) {
                        throw new IllegalStateException("Unbalanced '" + MathOp.RPAREN + "'");
                    }
                    this.atoms.remove(n3);
                    break block8;
                }
                case LPAREN: {
                    this.atoms.remove(n3);
                    this.atoms.add(n3, new Atom(this.reduce(n3, true)));
                    continue block8;
                }
                default: {
                    continue block8;
                }
            }
        }
        if ((n2 = n3 - n) < 1) {
            throw new IllegalStateException("Empty expression");
        }
        n3 = n;
        atom2 = this.atoms.get(n3);
        if (atom2.op != null) {
            throw new IllegalStateException("Expected initial value expected but got operation " + atom2.op);
        }
        while (n + n2 > n3 + 1) {
            if (n + n2 < n3 + 3) {
                throw new IllegalStateException("No operator/operand pairing remaining");
            }
            atom = this.atoms.get(n3 + 1);
            if (atom.op == null) {
                throw new IllegalStateException("Operator expected but got value " + atom.val);
            }
            mathOp = atom.op;
            atom = this.atoms.get(n3 + 2);
            if (atom.op != null) {
                throw new IllegalStateException("Value expected but got operator " + atom.op);
            }
            if (mathOp != MathOp.POWER) {
                n3 += 2;
                atom2 = atom;
                continue;
            }
            n2 -= 2;
            this.atoms.remove(n3 + 1);
            this.atoms.remove(n3 + 1);
            l = atom2.val;
            atom2.val = 1L;
            int n4 = 0;
            while ((long)n4 < atom.val) {
                atom2.val *= l;
                ++n4;
            }
        }
        n3 = n;
        atom2 = this.atoms.get(n3);
        if (atom2.op != null) {
            throw new IllegalStateException("Expected initial value expected but got operation " + atom2.op);
        }
        while (n + n2 > n3 + 1) {
            if (n + n2 < n3 + 3) {
                throw new IllegalStateException("No operator/operand pairing remaining");
            }
            atom = this.atoms.get(n3 + 1);
            if (atom.op == null) {
                throw new IllegalStateException("Operator expected but got value " + atom.val);
            }
            mathOp = atom.op;
            atom = this.atoms.get(n3 + 2);
            if (atom.op != null) {
                throw new IllegalStateException("Value expected but got operator " + atom.op);
            }
            if (mathOp != MathOp.MULTIPLY && mathOp != MathOp.DIVIDE && mathOp != MathOp.REM) {
                n3 += 2;
                atom2 = atom;
                continue;
            }
            n2 -= 2;
            this.atoms.remove(n3 + 1);
            this.atoms.remove(n3 + 1);
            if (mathOp == MathOp.MULTIPLY) {
                atom2.val *= atom.val;
                continue;
            }
            if (mathOp == MathOp.DIVIDE) {
                atom2.val /= atom.val;
                continue;
            }
            atom2.val %= atom.val;
        }
        atom2 = this.atoms.remove(n);
        --n2;
        if (atom2.op != null) {
            throw new IllegalStateException("Value expected but got operation " + atom2.op);
        }
        l = atom2.val;
        block12: while (n2 > 0) {
            --n2;
            atom2 = this.atoms.remove(n);
            mathOp = atom2.op;
            if (mathOp == null) {
                throw new IllegalStateException("Operator expected but got value " + atom2.val);
            }
            if (n2 <= 0) {
                throw new IllegalStateException("No operand for operator " + mathOp);
            }
            --n2;
            atom2 = this.atoms.remove(n);
            if (atom2.op != null) {
                throw new IllegalStateException("Value expected but got operation " + atom2.op);
            }
            switch (mathOp) {
                case ADD: {
                    l += atom2.val;
                    continue block12;
                }
                case SUBTRACT: {
                    l -= atom2.val;
                    continue block12;
                }
            }
            throw new IllegalStateException("Unknown operator: " + mathOp);
        }
        return l;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            throw new IllegalArgumentException("SYNTAX: java Calculator 'expression'");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("one", "1");
        hashMap.put("two", "2");
        hashMap.put("three", "3");
        hashMap.put("four", "4");
        hashMap.put("five", "5");
        hashMap.put("six", "6");
        hashMap.put("seven", "7");
        hashMap.put("eight", "8");
        hashMap.put("nine", "9");
        Calculator calculator = new Calculator(stringArray[0], hashMap);
        System.out.println(calculator);
        System.out.println(calculator.reduce(0, false));
    }

    public static long reassignValue(String string, Map<String, String> map, String string2, String string3) {
        Long l;
        long l2 = 0L;
        try {
            l2 = Long.parseLong(map.get(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Can not perform a self-operation on a non-integer: " + string);
        }
        Long l3 = l = string3 == null || string3.trim().length() < 1 ? null : Long.valueOf(new Calculator(string3, map).reduce(0, false));
        if (string2.equals("++")) {
            if (l != null) {
                throw new IllegalStateException("++ operator takes no right hand operand");
            }
            return 1L + l2;
        }
        if (string2.equals("--")) {
            if (l != null) {
                throw new IllegalStateException("++ operator takes no right hand operand");
            }
            return l2 - 1L;
        }
        if (l == null) {
            throw new IllegalStateException("Operator requires a right hand operand: " + string2);
        }
        long l4 = l.intValue();
        if (string2.equals("+=")) {
            l2 += l4;
        } else if (string2.equals("-=")) {
            l2 -= l4;
        } else if (string2.equals("*=")) {
            l2 *= l4;
        } else if (string2.equals("/=")) {
            l2 /= l4;
        } else if (string2.equals("%=")) {
            l2 %= l4;
        } else {
            throw new IllegalStateException("Unsupported operator: " + string2);
        }
        return l2;
    }

    private class Atom {
        public MathOp op;
        public long val;

        private Atom(String string) {
            if (string == null) {
                throw new IllegalArgumentException("Tokens may not be null");
            }
            if (string.length() < 1) {
                throw new IllegalArgumentException("Tokens may not be empty");
            }
            if (intPattern.matcher(string).matches()) {
                this.val = Long.parseLong(string);
                return;
            }
            if (string.length() == 1) {
                this.op = MathOp.valueOf(string.charAt(0));
                if (this.op != null) {
                    return;
                }
            }
            this.val = Calculator.this.deref(string);
        }

        private Atom(MathOp mathOp) {
            this.op = mathOp;
        }

        private Atom(long l) {
            this.val = l;
        }

        public String toString() {
            return this.op == null ? Long.toString(this.val) : this.op.toString();
        }
    }

    private static enum MathOp {
        LPAREN('('),
        RPAREN(')'),
        ADD('+'),
        SUBTRACT('-'),
        MULTIPLY('*'),
        DIVIDE('/'),
        REM('%'),
        POWER('^');

        private char c;

        private MathOp(char c) {
            this.c = c;
        }

        public String toString() {
            return Character.toString(this.c);
        }

        public static MathOp valueOf(char c) {
            for (MathOp mathOp : MathOp.values()) {
                if (mathOp.c != c) continue;
                return mathOp;
            }
            return null;
        }
    }
}

