/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.datetime;

import com.impossibl.postgres.datetime.DateTimeFormat;
import com.impossibl.postgres.datetime.FormatUtils;
import com.impossibl.postgres.datetime.instants.FutureInfiniteInstant;
import com.impossibl.postgres.datetime.instants.Instant;
import com.impossibl.postgres.datetime.instants.PastInfiniteInstant;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class ISODateFormat
implements DateTimeFormat {
    Parser parser = new Parser();
    Printer printer = new Printer();

    @Override
    public Parser getParser() {
        return this.parser;
    }

    @Override
    public Printer getPrinter() {
        return this.printer;
    }

    static class Printer
    implements DateTimeFormat.Printer {
        Printer() {
        }

        @Override
        public String format(Instant instant) {
            String yearString;
            TimeZone zone = instant.getZone();
            if (zone == null) {
                zone = TimeZone.getTimeZone("UTC");
            }
            Calendar cal = Calendar.getInstance(zone);
            cal.setTimeInMillis(TimeUnit.MICROSECONDS.toMillis(instant.getMicrosUTC()));
            int year = cal.get(1);
            int month = cal.get(2) + 1;
            int day = cal.get(5);
            String yearZeros = "0000";
            if (year < 1000) {
                yearString = "" + year;
                yearString = yearZeros.substring(0, 4 - yearString.length()) + yearString;
            } else {
                yearString = "" + year;
            }
            String monthString = month < 10 ? "0" + month : Integer.toString(month);
            String dayString = day < 10 ? "0" + day : Integer.toString(day);
            StringBuilder timestampBuf = new StringBuilder(20);
            timestampBuf.append(yearString);
            timestampBuf.append("-");
            timestampBuf.append(monthString);
            timestampBuf.append("-");
            timestampBuf.append(dayString);
            timestampBuf.append(" ");
            return timestampBuf.toString();
        }
    }

    static class Parser
    implements DateTimeFormat.Parser {
        Parser() {
        }

        @Override
        public int parse(String date, int offset, Map<String, Object> pieces) {
            try {
                if (date.equals("infinity")) {
                    pieces.put("INFINITY", FutureInfiniteInstant.INSTANCE);
                    offset = date.length();
                } else if (date.equals("-infinity")) {
                    pieces.put("INFINITY", PastInfiniteInstant.INSTANCE);
                    offset = date.length();
                } else {
                    int[] parsedValue = new int[1];
                    offset = FormatUtils.parseInt(date, offset, parsedValue);
                    FormatUtils.checkOffset(date, offset, '-');
                    pieces.put("YEAR", parsedValue[0]);
                    offset = FormatUtils.parseInt(date, offset + 1, parsedValue);
                    FormatUtils.checkOffset(date, offset, '-');
                    pieces.put("MONTH", parsedValue[0]);
                    ++offset;
                    offset = FormatUtils.parseInt(date, offset, parsedValue);
                    FormatUtils.checkOffset(date, offset, '\u0000');
                    pieces.put("DAY", parsedValue[0]);
                }
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException runtimeException) {
                // empty catch block
            }
            return offset;
        }
    }
}

