/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.GT;
import com.impossibl.postgres.jdbc.SQLTextTree;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;

class SQLTextEscapeFunctions {
    public static final String ABS = "abs";
    public static final String ACOS = "acos";
    public static final String ASIN = "asin";
    public static final String ATAN = "atan";
    public static final String ATAN2 = "atan2";
    public static final String CEILING = "ceiling";
    public static final String COS = "cos";
    public static final String COT = "cot";
    public static final String DEGREES = "degrees";
    public static final String EXP = "exp";
    public static final String FLOOR = "floor";
    public static final String LOG = "log";
    public static final String LOG10 = "log10";
    public static final String MOD = "mod";
    public static final String PI = "pi";
    public static final String POWER = "power";
    public static final String RADIANS = "radians";
    public static final String RAND = "rand";
    public static final String ROUND = "round";
    public static final String SIGN = "sign";
    public static final String SIN = "sin";
    public static final String SQRT = "sqrt";
    public static final String TAN = "tan";
    public static final String TRUNCATE = "truncate";
    public static final List<String> ALL_NUMERIC = Arrays.asList("abs", "acos", "asin", "atan", "atan2", "ceiling", "cos", "cot", "degrees", "exp", "floor", "log", "log10", "mod", "pi", "power", "radians", "round", "sign", "sin", "sqrt", "tan", "truncate");
    public static final String ASCII = "ascii";
    public static final String CHAR = "char";
    public static final String CHAR_LENGTH = "char_length";
    public static final String CHARACTER_LENGTH = "character_length";
    public static final String CONCAT = "concat";
    public static final String INSERT = "insert";
    public static final String LCASE = "lcase";
    public static final String LEFT = "left";
    public static final String LENGTH = "length";
    public static final String LOCATE = "locate";
    public static final String LTRIM = "ltrim";
    public static final String OCTET_LENGTH = "octet_length";
    public static final String POSITION = "position";
    public static final String REPEAT = "repeat";
    public static final String REPLACE = "replace";
    public static final String RIGHT = "right";
    public static final String RTRIM = "rtrim";
    public static final String SPACE = "space";
    public static final String SUBSTRING = "substring";
    public static final String UCASE = "ucase";
    public static final List<String> ALL_STRING = Arrays.asList("ascii", "char", "concat", "insert", "lcase", "left", "length", "locate", "ltrim", "repeat", "replace", "right", "rtrim", "space", "substring", "ucase");
    public static final String CURDATE = "curdate";
    public static final String CURRENT_DATE = "current_date";
    public static final String CURTIME = "curtime";
    public static final String CURRENT_TIME = "current_time";
    public static final String CURRENT_TIMESTAMP = "current_timestamp";
    public static final String DAYNAME = "dayname";
    public static final String DAYOFMONTH = "dayofmonth";
    public static final String DAYOFWEEK = "dayofweek";
    public static final String DAYOFYEAR = "dayofyear";
    public static final String EXTRACT = "extract";
    public static final String HOUR = "hour";
    public static final String MINUTE = "minute";
    public static final String MONTH = "month";
    public static final String MONTHNAME = "monthname";
    public static final String NOW = "now";
    public static final String QUARTER = "quarter";
    public static final String SECOND = "second";
    public static final String TIMESTAMPADD = "timestampadd";
    public static final String TIMESTAMPDIFF = "timestampdiff";
    public static final String WEEK = "week";
    public static final String YEAR = "year";
    public static final List<String> ALL_DATE_TIME = Arrays.asList("curdate", "curtime", "dayname", "dayofmonth", "dayofweek", "dayofyear", "hour", "minute", "month", "monthname", "now", "quarter", "second", "week", "year");
    public static final String SQL_TSI_ROOT = "SQL_TSI_";
    public static final String SQL_TSI_DAY = "DAY";
    public static final String SQL_TSI_FRAC_SECOND = "FRAC_SECOND";
    public static final String SQL_TSI_HOUR = "HOUR";
    public static final String SQL_TSI_MINUTE = "MINUTE";
    public static final String SQL_TSI_MONTH = "MONTH";
    public static final String SQL_TSI_QUARTER = "QUARTER";
    public static final String SQL_TSI_SECOND = "SECOND";
    public static final String SQL_TSI_WEEK = "WEEK";
    public static final String SQL_TSI_YEAR = "YEAR";
    public static final String DATABASE = "database";
    public static final String IFNULL = "ifnull";
    public static final String USER = "user";
    public static final List<String> ALL_SYSTEM = Arrays.asList("database", "ifnull", "user");
    private static Map<String, Method> functionMap = SQLTextEscapeFunctions.createFunctionMap();

    SQLTextEscapeFunctions() {
    }

    private static Map<String, Method> createFunctionMap() {
        Method defaultMeth;
        try {
            defaultMeth = SQLTextEscapeFunctions.class.getDeclaredMethod("defaultEscape", String.class, List.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, Method> functionMap = new HashMap<String, Method>();
        for (String name : ALL_STRING) {
            functionMap.put(name, defaultMeth);
        }
        for (String name : ALL_NUMERIC) {
            functionMap.put(name, defaultMeth);
        }
        for (String name : ALL_DATE_TIME) {
            functionMap.put(name, defaultMeth);
        }
        for (String name : ALL_SYSTEM) {
            functionMap.put(name, defaultMeth);
        }
        for (Method meth : SQLTextEscapeFunctions.class.getDeclaredMethods()) {
            if (!meth.getName().startsWith("sql")) continue;
            String funcName = meth.getName().substring(3).toLowerCase(Locale.US);
            functionMap.put(funcName, meth);
        }
        return functionMap;
    }

    public static Method getEscapeMethod(String functionName) {
        return functionMap.get(functionName.toLowerCase(Locale.US));
    }

    public static SQLTextTree.Node invokeEscape(Method method, String name, List<SQLTextTree.Node> args) throws SQLException {
        try {
            return (SQLTextTree.Node)method.invoke(null, name, args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public static SQLTextTree.Node defaultEscape(String name, List<SQLTextTree.Node> args) throws SQLException {
        return SQLTextEscapeFunctions.call(name, args);
    }

    public static SQLTextTree.Node sqlrand(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 1) {
            throw new SQLException(GT.tr("{0} function takes one and only one argument.", CEILING), "Syntax Error");
        }
        return SQLTextEscapeFunctions.call("random", args);
    }

    public static SQLTextTree.Node sqlceiling(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 1) {
            throw new SQLException(GT.tr("{0} function takes one and only one argument.", CEILING), "Syntax Error");
        }
        return SQLTextEscapeFunctions.call("ceil", args);
    }

    public static SQLTextTree.Node sqllog(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 1) {
            throw new SQLException(GT.tr("{0} function takes one and only one argument.", LOG), "Syntax Error");
        }
        return SQLTextEscapeFunctions.call("ln", args);
    }

    public static SQLTextTree.Node sqllog10(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 1) {
            throw new SQLException(GT.tr("{0} function takes one and only one argument.", LOG10), "Syntax Error");
        }
        return SQLTextEscapeFunctions.call(LOG, args);
    }

    public static SQLTextTree.Node sqlpower(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 2) {
            throw new SQLException(GT.tr("{0} function takes two and only two arguments.", POWER), "Syntax Error");
        }
        return SQLTextEscapeFunctions.call("pow", args);
    }

    public static SQLTextTree.Node sqltruncate(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 2) {
            throw new SQLException(GT.tr("{0} function takes two and only two arguments.", TRUNCATE), "Syntax Error");
        }
        return SQLTextEscapeFunctions.call("trunc", args);
    }

    public static SQLTextTree.Node sqlchar(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 1) {
            throw new SQLException(GT.tr("{0} function takes one and only one argument.", CHAR), "Syntax Error");
        }
        return SQLTextEscapeFunctions.call("chr", args);
    }

    public static SQLTextTree.Node sqlconcat(String name, List<SQLTextTree.Node> args) {
        return SQLTextEscapeFunctions.groupedBy(args, "||");
    }

    public static SQLTextTree.Node sqlinsert(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 4) {
            throw new SQLException(GT.tr("{0} function takes four and only four arguments.", INSERT), "Syntax Error");
        }
        return SQLTextEscapeFunctions.sequence("overlay", SQLTextEscapeFunctions.groupedSequence(args.get(0), "placing", args.get(3), "from", args.get(1), "for", args.get(2)));
    }

    public static SQLTextTree.Node sqllcase(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 1) {
            throw new SQLException(GT.tr("{0} function takes one and only one argument.", LCASE), "Syntax Error");
        }
        return SQLTextEscapeFunctions.call("lower", args);
    }

    public static SQLTextTree.Node sqlleft(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 2) {
            throw new SQLException(GT.tr("{0} function takes two and only two arguments.", LEFT), "Syntax Error");
        }
        return SQLTextEscapeFunctions.sequence(SUBSTRING, SQLTextEscapeFunctions.groupedSequence(args.get(0), "for", args.get(1)));
    }

    public static SQLTextTree.Node sqllength(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 1) {
            throw new SQLException(GT.tr("{0} function takes one and only one argument.", LENGTH), "Syntax Error");
        }
        return SQLTextEscapeFunctions.sequence(LENGTH, SQLTextEscapeFunctions.groupedSequence(SQLTextEscapeFunctions.sequence("trim", SQLTextEscapeFunctions.groupedSequence("trailing", "from", args.get(0)))));
    }

    public static SQLTextTree.Node sqllocate(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() == 2) {
            return SQLTextEscapeFunctions.sequence(POSITION, SQLTextEscapeFunctions.groupedSequence(args.get(0), "in", args.get(1)));
        }
        if (args.size() == 3) {
            SQLTextTree.CompositeNode tmp = SQLTextEscapeFunctions.sequence(POSITION, SQLTextEscapeFunctions.groupedSequence(args.get(0), "in", SUBSTRING, SQLTextEscapeFunctions.groupedSequence(args.get(1), "from", args.get(2))));
            return SQLTextEscapeFunctions.groupedSequence(args.get(2), SQLTextEscapeFunctions.grammar("*"), SQLTextEscapeFunctions.ident(SIGN), SQLTextEscapeFunctions.groupedSequence(tmp), SQLTextEscapeFunctions.grammar("+"), tmp);
        }
        throw new SQLException(GT.tr("{0} function takes two or three arguments.", LOCATE), "Syntax Error");
    }

    public static SQLTextTree.Node sqlltrim(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 1) {
            throw new SQLException(GT.tr("{0} function takes one and only one argument.", LTRIM), "Syntax Error");
        }
        return SQLTextEscapeFunctions.sequence("trim", SQLTextEscapeFunctions.groupedSequence("leading", "from", args.get(0)));
    }

    public static SQLTextTree.Node sqlposition(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 3 && args.size() != 4) {
            throw new SQLException(GT.tr("{0} function takes one and only one argument.", LENGTH), "Syntax Error");
        }
        return SQLTextEscapeFunctions.sequence(POSITION, SQLTextEscapeFunctions.groupedBy(args.subList(0, 3), " "));
    }

    public static SQLTextTree.Node sqlright(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 2) {
            throw new SQLException(GT.tr("{0} function takes two and only two arguments.", RIGHT), "Syntax Error");
        }
        return SQLTextEscapeFunctions.sequence(SUBSTRING, SQLTextEscapeFunctions.groupedSequence(args.get(0), "from", SQLTextEscapeFunctions.groupedSequence(LENGTH, SQLTextEscapeFunctions.groupedSequence(args.get(0)), SQLTextEscapeFunctions.grammar("+"), SQLTextEscapeFunctions.literal(1), SQLTextEscapeFunctions.grammar("-"), args.get(1))));
    }

    public static SQLTextTree.Node sqlrtrim(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 1) {
            throw new SQLException(GT.tr("{0} function takes one and only one argument.", RTRIM), "Syntax Error");
        }
        return SQLTextEscapeFunctions.sequence("trim", SQLTextEscapeFunctions.groupedSequence("trailing", "from", args.get(0)));
    }

    public static SQLTextTree.Node sqlspace(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 1) {
            throw new SQLException(GT.tr("{0} function takes one and only one argument.", SPACE), "Syntax Error");
        }
        return SQLTextEscapeFunctions.call(REPEAT, Arrays.asList(SQLTextEscapeFunctions.literal(" "), args.get(0)));
    }

    public static SQLTextTree.Node sqlsubstring(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() == 2 || args.size() == 3) {
            return SQLTextEscapeFunctions.call("substr", args);
        }
        throw new SQLException(GT.tr("{0} function takes two or three arguments.", SUBSTRING), "Syntax Error");
    }

    public static SQLTextTree.Node sqlucase(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 1) {
            throw new SQLException(GT.tr("{0} function takes one and only one argument.", UCASE), "Syntax Error");
        }
        return SQLTextEscapeFunctions.call("upper", args);
    }

    public static SQLTextTree.Node sqlcurdate(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 0) {
            throw new SQLException(GT.tr("{0} function doesn''t take any argument.", CURDATE), "Syntax Error");
        }
        return SQLTextEscapeFunctions.ident(CURRENT_DATE);
    }

    public static SQLTextTree.Node sqlcurtime(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 0) {
            throw new SQLException(GT.tr("{0} function doesn''t take any argument.", CURTIME), "Syntax Error");
        }
        return SQLTextEscapeFunctions.ident(CURRENT_TIME);
    }

    public static SQLTextTree.Node sqldayname(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 1) {
            throw new SQLException(GT.tr("{0} function takes one and only one argument.", DAYNAME), "Syntax Error");
        }
        return SQLTextEscapeFunctions.call("to_char", Arrays.asList(args.get(0), SQLTextEscapeFunctions.literal("Day")));
    }

    public static SQLTextTree.Node sqldayofmonth(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 1) {
            throw new SQLException(GT.tr("{0} function takes one and only one argument.", DAYOFMONTH), "Syntax Error");
        }
        return SQLTextEscapeFunctions.sequence(EXTRACT, SQLTextEscapeFunctions.groupedSequence("day", "from", args.get(0)));
    }

    public static SQLTextTree.Node sqldayofweek(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 1) {
            throw new SQLException(GT.tr("{0} function takes one and only one argument.", DAYOFWEEK), "Syntax Error");
        }
        return SQLTextEscapeFunctions.groupedSequence(SQLTextEscapeFunctions.sequence(EXTRACT, SQLTextEscapeFunctions.groupedSequence("dow", "from", args.get(0))), SQLTextEscapeFunctions.grammar("+"), SQLTextEscapeFunctions.literal(1));
    }

    public static SQLTextTree.Node sqldayofyear(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 1) {
            throw new SQLException(GT.tr("{0} function takes one and only one argument.", DAYOFYEAR), "Syntax Error");
        }
        return SQLTextEscapeFunctions.sequence(EXTRACT, SQLTextEscapeFunctions.groupedSequence("doy", "from", args.get(0)));
    }

    public static SQLTextTree.Node sqlhour(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 1) {
            throw new SQLException(GT.tr("{0} function takes one and only one argument.", HOUR), "Syntax Error");
        }
        return SQLTextEscapeFunctions.sequence(EXTRACT, SQLTextEscapeFunctions.groupedSequence(HOUR, "from", args.get(0)));
    }

    public static SQLTextTree.Node sqlminute(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 1) {
            throw new SQLException(GT.tr("{0} function takes one and only one argument.", MINUTE), "Syntax Error");
        }
        return SQLTextEscapeFunctions.sequence(EXTRACT, SQLTextEscapeFunctions.groupedSequence(MINUTE, "from", args.get(0)));
    }

    public static SQLTextTree.Node sqlmonth(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 1) {
            throw new SQLException(GT.tr("{0} function takes one and only one argument.", MONTH), "Syntax Error");
        }
        return SQLTextEscapeFunctions.sequence(EXTRACT, SQLTextEscapeFunctions.groupedSequence(MONTH, "from", args.get(0)));
    }

    public static SQLTextTree.Node sqlmonthname(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 1) {
            throw new SQLException(GT.tr("{0} function takes one and only one argument.", MONTHNAME), "Syntax Error");
        }
        return SQLTextEscapeFunctions.call("to_char", Arrays.asList(args.get(0), SQLTextEscapeFunctions.literal("Month")));
    }

    public static SQLTextTree.Node sqlquarter(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 1) {
            throw new SQLException(GT.tr("{0} function takes one and only one argument.", QUARTER), "Syntax Error");
        }
        return SQLTextEscapeFunctions.sequence(EXTRACT, SQLTextEscapeFunctions.groupedSequence(QUARTER, "from", args.get(0)));
    }

    public static SQLTextTree.Node sqlsecond(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 1) {
            throw new SQLException(GT.tr("{0} function takes one and only one argument.", SECOND), "Syntax Error");
        }
        return SQLTextEscapeFunctions.sequence(EXTRACT, SQLTextEscapeFunctions.groupedSequence(SECOND, "from", args.get(0)));
    }

    public static SQLTextTree.Node sqlweek(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 1) {
            throw new SQLException(GT.tr("{0} function takes one and only one argument.", WEEK), "Syntax Error");
        }
        return SQLTextEscapeFunctions.sequence(EXTRACT, SQLTextEscapeFunctions.groupedSequence(WEEK, "from", args.get(0)));
    }

    public static SQLTextTree.Node sqlyear(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 1) {
            throw new SQLException(GT.tr("{0} function takes one and only one argument.", YEAR), "Syntax Error");
        }
        return SQLTextEscapeFunctions.sequence(EXTRACT, SQLTextEscapeFunctions.groupedSequence(YEAR, "from", args.get(0)));
    }

    public static SQLTextTree.Node sqltimestampadd(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 3) {
            throw new SQLException(GT.tr("{0} function takes three and only three arguments.", TIMESTAMPADD), "Syntax Error");
        }
        SQLTextTree.Node interval = SQLTextEscapeFunctions.constantToInterval(args.get(0).toString(), args.get(1));
        return SQLTextEscapeFunctions.groupedSequence(interval, SQLTextEscapeFunctions.grammar("+"), args.get(2));
    }

    private static SQLTextTree.Node constantToInterval(String type, SQLTextTree.Node value) throws SQLException {
        if (!type.startsWith(SQL_TSI_ROOT)) {
            throw new SQLException(GT.tr("Interval {0} not yet implemented", type), "Syntax Error");
        }
        String shortType = type.substring(SQL_TSI_ROOT.length());
        if (SQL_TSI_DAY.equalsIgnoreCase(shortType)) {
            return SQLTextEscapeFunctions.sequence("CAST", SQLTextEscapeFunctions.groupedSequence(value, SQLTextEscapeFunctions.grammar("||"), SQLTextEscapeFunctions.literal(" day"), "as", "interval"));
        }
        if (SQL_TSI_SECOND.equalsIgnoreCase(shortType)) {
            return SQLTextEscapeFunctions.sequence("CAST", SQLTextEscapeFunctions.groupedSequence(value, SQLTextEscapeFunctions.grammar("||"), SQLTextEscapeFunctions.literal(" second"), "as", "interval"));
        }
        if (SQL_TSI_HOUR.equalsIgnoreCase(shortType)) {
            return SQLTextEscapeFunctions.sequence("CAST", SQLTextEscapeFunctions.groupedSequence(value, SQLTextEscapeFunctions.grammar("||"), SQLTextEscapeFunctions.literal(" hour"), "as", "interval"));
        }
        if (SQL_TSI_MINUTE.equalsIgnoreCase(shortType)) {
            return SQLTextEscapeFunctions.sequence("CAST", SQLTextEscapeFunctions.groupedSequence(value, SQLTextEscapeFunctions.grammar("||"), SQLTextEscapeFunctions.literal(" minute"), "as", "interval"));
        }
        if (SQL_TSI_MONTH.equalsIgnoreCase(shortType)) {
            return SQLTextEscapeFunctions.sequence("CAST", SQLTextEscapeFunctions.groupedSequence(value, SQLTextEscapeFunctions.grammar("||"), SQLTextEscapeFunctions.literal(" month"), "as", "interval"));
        }
        if (SQL_TSI_QUARTER.equalsIgnoreCase(shortType)) {
            return SQLTextEscapeFunctions.sequence("CAST", SQLTextEscapeFunctions.groupedSequence(SQLTextEscapeFunctions.groupedSequence(value, SQLTextEscapeFunctions.grammar("::int"), SQLTextEscapeFunctions.grammar("*"), SQLTextEscapeFunctions.literal(3)), SQLTextEscapeFunctions.grammar("||"), SQLTextEscapeFunctions.literal(" month"), "as", "interval"));
        }
        if (SQL_TSI_WEEK.equalsIgnoreCase(shortType)) {
            return SQLTextEscapeFunctions.sequence("CAST", SQLTextEscapeFunctions.groupedSequence(value, SQLTextEscapeFunctions.grammar("||"), SQLTextEscapeFunctions.literal(" week"), "as", "interval"));
        }
        if (SQL_TSI_YEAR.equalsIgnoreCase(shortType)) {
            return SQLTextEscapeFunctions.sequence("CAST", SQLTextEscapeFunctions.groupedSequence(value, SQLTextEscapeFunctions.grammar("||"), SQLTextEscapeFunctions.literal(" year"), "as", "interval"));
        }
        if (SQL_TSI_FRAC_SECOND.equalsIgnoreCase(shortType)) {
            throw new SQLException(GT.tr("Interval {0} not yet implemented", "SQL_TSI_FRAC_SECOND"), "Syntax Error");
        }
        throw new SQLException(GT.tr("Interval {0} not yet implemented", type), "Syntax Error");
    }

    public static SQLTextTree.Node sqltimestampdiff(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 3) {
            throw new SQLException(GT.tr("{0} function takes three and only three arguments.", TIMESTAMPDIFF), "Syntax Error");
        }
        SQLTextTree.Node datePart = SQLTextEscapeFunctions.constantToDatePart(args.get(0).toString());
        return SQLTextEscapeFunctions.sequence(EXTRACT, SQLTextEscapeFunctions.groupedSequence(datePart, "from", SQLTextEscapeFunctions.groupedSequence(args.get(2), SQLTextEscapeFunctions.grammar("-"), args.get(1))));
    }

    private static SQLTextTree.Node constantToDatePart(String type) throws SQLException {
        if (!type.startsWith(SQL_TSI_ROOT)) {
            throw new SQLException(GT.tr("Interval {0} not yet implemented", type), "Syntax Error");
        }
        String shortType = type.substring(SQL_TSI_ROOT.length());
        if (SQL_TSI_DAY.equalsIgnoreCase(shortType)) {
            return SQLTextEscapeFunctions.ident("day");
        }
        if (SQL_TSI_SECOND.equalsIgnoreCase(shortType)) {
            return SQLTextEscapeFunctions.ident(SECOND);
        }
        if (SQL_TSI_HOUR.equalsIgnoreCase(shortType)) {
            return SQLTextEscapeFunctions.ident(HOUR);
        }
        if (SQL_TSI_MINUTE.equalsIgnoreCase(shortType)) {
            return SQLTextEscapeFunctions.ident(MINUTE);
        }
        if (SQL_TSI_FRAC_SECOND.equalsIgnoreCase(shortType)) {
            throw new SQLException(GT.tr("Interval {0} not yet implemented", "SQL_TSI_FRAC_SECOND"), "Syntax Error");
        }
        throw new SQLException(GT.tr("Interval {0} not yet implemented", type), "Syntax Error");
    }

    public static SQLTextTree.Node sqldatabase(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 0) {
            throw new SQLException(GT.tr("{0} function doesn''t take any argument.", DATABASE), "Syntax Error");
        }
        return SQLTextEscapeFunctions.call("current_database", args);
    }

    public static SQLTextTree.Node sqlifnull(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 2) {
            throw new SQLException(GT.tr("{0} function takes two and only two arguments.", IFNULL), "Syntax Error");
        }
        return SQLTextEscapeFunctions.call("coalesce", args);
    }

    public static SQLTextTree.Node sqluser(String name, List<SQLTextTree.Node> args) throws SQLException {
        if (args.size() != 0) {
            throw new SQLException(GT.tr("{0} function doesn''t take any argument.", USER), "Syntax Error");
        }
        return SQLTextEscapeFunctions.ident(USER);
    }

    static SQLTextTree.Node space() {
        return new SQLTextTree.WhitespacePiece(" ", -1);
    }

    static SQLTextTree.Node grammar(String val) {
        return new SQLTextTree.GrammarPiece(val, -1);
    }

    static SQLTextTree.Node literal(Number val) {
        return new SQLTextTree.NumericLiteralPiece(val.toString(), -1);
    }

    static SQLTextTree.Node literal(String text) {
        return new SQLTextTree.StringLiteralPiece(text, -1);
    }

    private static SQLTextTree.Node ident(String name) {
        return new SQLTextTree.UnquotedIdentifierPiece(name, -1);
    }

    static SQLTextTree.Node call(String name, List<SQLTextTree.Node> args) {
        return SQLTextEscapeFunctions.sequence(name, SQLTextEscapeFunctions.groupedBy(args, ","));
    }

    static SQLTextTree.ParenGroupNode groupedBy(List<SQLTextTree.Node> args, String sep) {
        SQLTextTree.ParenGroupNode groupNode = new SQLTextTree.ParenGroupNode(-1);
        Iterator<SQLTextTree.Node> argsIter = args.iterator();
        while (argsIter.hasNext()) {
            groupNode.add(argsIter.next());
            if (!argsIter.hasNext()) continue;
            groupNode.add(new SQLTextTree.GrammarPiece(sep, -1));
        }
        return groupNode;
    }

    static SQLTextTree.ParenGroupNode groupedSequence(Object ... args) {
        SQLTextTree.ParenGroupNode groupNode = new SQLTextTree.ParenGroupNode(-1);
        SQLTextEscapeFunctions.sequence(groupNode, Arrays.asList(args));
        return groupNode;
    }

    static SQLTextTree.CompositeNode sequence(String identName, Object ... args) {
        SQLTextTree.CompositeNode seqNode = new SQLTextTree.CompositeNode(-1);
        seqNode.add(SQLTextEscapeFunctions.ident(identName));
        SQLTextEscapeFunctions.sequence(seqNode, Arrays.asList(args));
        return seqNode;
    }

    static SQLTextTree.CompositeNode sequence(Object ... args) {
        SQLTextTree.CompositeNode seqNode = new SQLTextTree.CompositeNode(-1);
        SQLTextEscapeFunctions.sequence(seqNode, Arrays.asList(args));
        return seqNode;
    }

    static SQLTextTree.Node concat(SQLTextTree.Node a, SQLTextTree.Node b) {
        if (a instanceof SQLTextTree.CompositeNode) {
            SQLTextTree.CompositeNode ac = (SQLTextTree.CompositeNode)a;
            if (b instanceof SQLTextTree.CompositeNode) {
                ac.nodes.addAll(((SQLTextTree.CompositeNode)b).nodes);
            } else {
                ac.nodes.add(b);
            }
            return a;
        }
        if (b instanceof SQLTextTree.CompositeNode) {
            ((SQLTextTree.CompositeNode)b).nodes.add(0, a);
            return b;
        }
        SQLTextTree.CompositeNode c = new SQLTextTree.CompositeNode(-1);
        c.add(a);
        c.add(b);
        return c;
    }

    static void sequence(SQLTextTree.CompositeNode seqNode, List<Object> args) {
        ListIterator<Object> argsIter = args.listIterator();
        while (argsIter.hasNext()) {
            Object obj = argsIter.next();
            SQLTextTree.Node lastNode = seqNode.getLastNode();
            if (!(lastNode instanceof SQLTextTree.WhitespacePiece) && !(obj instanceof SQLTextTree.WhitespacePiece) && !(obj instanceof SQLTextTree.ParenGroupNode) && (lastNode instanceof SQLTextTree.IdentifierPiece || obj instanceof SQLTextTree.IdentifierPiece || obj instanceof String)) {
                seqNode.add(new SQLTextTree.WhitespacePiece(" ", -1));
            }
            if (obj instanceof SQLTextTree.Node) {
                seqNode.add((SQLTextTree.Node)obj);
                continue;
            }
            seqNode.add(new SQLTextTree.UnquotedIdentifierPiece(obj.toString(), -1));
        }
    }
}

