/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.List;

public final class QuickSort {
    private static final Comparator<? extends Comparable> OBJCOMP = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable object1, Comparable object2) {
            return object1.compareTo(object2);
        }
    };

    private QuickSort() {
    }

    public static <T> void sort(List<T> list, Comparator<T> cmp) {
        int size = list.size();
        if (size < 2) {
            return;
        }
        QuickSort.quicksort(list, cmp);
    }

    public static <T extends Comparable> void sort(List<T> list) {
        QuickSort.sort(list, OBJCOMP);
    }

    private static <T> void quicksort(List<T> list, Comparator<T> cmp) {
        ArrayDeque<Integer> stack = new ArrayDeque<Integer>();
        stack.push(0);
        stack.push(list.size());
        while (!stack.isEmpty()) {
            int left;
            int right = (Integer)stack.pop();
            if (right - (left = ((Integer)stack.pop()).intValue()) < 2) continue;
            int p = left + (right - left) / 2;
            p = QuickSort.partition(list, cmp, p, left, right);
            stack.push(p + 1);
            stack.push(right);
            stack.push(left);
            stack.push(p);
        }
    }

    private static <T> int partition(List<T> list, Comparator<T> cmp, int p, int start, int end) {
        int l = start;
        int h2 = end - 2;
        T piv = list.get(p);
        QuickSort.swap(list, p, end - 1);
        while (l < h2) {
            if (cmp.compare(list.get(l), piv) <= 0) {
                ++l;
                continue;
            }
            if (cmp.compare(piv, list.get(h2)) <= 0) {
                --h2;
                continue;
            }
            QuickSort.swap(list, l, h2);
        }
        int idx = h2;
        if (cmp.compare(list.get(h2), piv) < 0) {
            ++idx;
        }
        QuickSort.swap(list, end - 1, idx);
        return idx;
    }

    private static <T> void swap(List<T> list, int i, int j) {
        T tmp = list.get(i);
        list.set(i, list.get(j));
        list.set(j, tmp);
    }
}

