/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.easybind.monadic;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableValue;
import org.fxmisc.easybind.monadic.MonadicBinding;

class FirstNonNullBinding<T>
extends ObjectBinding<T>
implements MonadicBinding<T> {
    private final ObservableValue<? extends T>[] chain;
    private final InvalidationListener listener = obs -> this.srcInvalidated(obs);
    private final InvalidationListener weakListener = new WeakInvalidationListener(this.listener);
    private int startAt = 0;

    @SafeVarargs
    public FirstNonNullBinding(ObservableValue<? extends T> ... chain) {
        this.chain = chain;
        for (int i = 0; i < chain.length; ++i) {
            chain[i].addListener(this.weakListener);
        }
    }

    public void dispose() {
        for (int i = 0; i < this.chain.length; ++i) {
            this.chain[i].removeListener(this.weakListener);
        }
    }

    protected T computeValue() {
        for (int i = this.startAt; i < this.chain.length; ++i) {
            Object val = this.chain[i].getValue();
            if (val == null) continue;
            this.startAt = i;
            return (T)val;
        }
        this.startAt = this.chain.length;
        return null;
    }

    private void srcInvalidated(Observable src) {
        for (int i = 0; i < this.chain.length; ++i) {
            if (this.chain[i] != src) continue;
            this.srcInvalidated(i);
            break;
        }
    }

    private void srcInvalidated(int index) {
        if (index <= this.startAt) {
            this.startAt = index;
            this.invalidate();
        }
    }
}

