/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jabref.Globals;
import org.jabref.gui.JabRefDialog;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.entryeditor.EntryEditorTabList;
import org.jabref.gui.help.HelpAction;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.logic.bibtexkeypattern.BibtexKeyGenerator;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.l10n.Localization;

public class GenFieldsCustomizer
extends JabRefDialog {
    private final JPanel buttons = new JPanel();
    private final JButton ok = new JButton();
    private final JButton cancel = new JButton();
    private final JButton helpBut;
    private final JLabel jLabel1 = new JLabel();
    private final JPanel jPanel3 = new JPanel();
    private final JPanel jPanel4 = new JPanel();
    private final GridBagLayout gridBagLayout1 = new GridBagLayout();
    private final JScrollPane jScrollPane1 = new JScrollPane();
    private final JLabel jLabel2 = new JLabel();
    private final JTextArea fieldsArea = new JTextArea();
    private final GridBagLayout gridBagLayout2 = new GridBagLayout();
    private final JButton revert = new JButton();

    public GenFieldsCustomizer(JabRefFrame frame) {
        super((Frame)frame, Localization.lang("Set general fields", new String[0]), false, GenFieldsCustomizer.class);
        this.helpBut = new HelpAction(HelpFile.GENERAL_FIELDS).getHelpButton();
        this.jbInit();
        this.setSize(new Dimension(650, 300));
    }

    private void jbInit() {
        this.ok.setText(Localization.lang("OK", new String[0]));
        this.ok.addActionListener(e -> this.okActionPerformed());
        this.cancel.setText(Localization.lang("Cancel", new String[0]));
        this.cancel.addActionListener(e -> this.dispose());
        this.jLabel1.setText(Localization.lang("Delimit fields with semicolon, ex.", new String[0]) + ": url;pdf;note");
        this.jPanel3.setLayout(this.gridBagLayout2);
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel4.setLayout(this.gridBagLayout1);
        this.jLabel2.setText(Localization.lang("General fields", new String[0]));
        this.setFieldsText();
        this.revert.setText(Localization.lang("Default", new String[0]));
        this.revert.addActionListener(e -> this.revertActionPerformed());
        this.getContentPane().add((Component)this.buttons, "South");
        ButtonBarBuilder bb = new ButtonBarBuilder(this.buttons);
        this.buttons.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        bb.addGlue();
        bb.addButton((JComponent)this.ok);
        bb.addButton((JComponent)this.revert);
        bb.addButton((JComponent)this.cancel);
        bb.addStrut(Sizes.DLUX5);
        bb.addButton((JComponent)this.helpBut);
        bb.addGlue();
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.jPanel3.add((Component)this.jLabel1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel3.add((Component)this.jPanel4, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 318, 193));
        this.jPanel4.add((Component)this.jScrollPane1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.fieldsArea, null);
        this.jPanel4.add((Component)this.jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        ActionMap am = this.buttons.getActionMap();
        InputMap im = this.buttons.getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenFieldsCustomizer.this.dispose();
            }
        });
    }

    private void okActionPerformed() {
        int i;
        String[] lines = this.fieldsArea.getText().split("\n");
        for (i = 0; i < lines.length; ++i) {
            String[] parts = lines[i].split(":");
            if (parts.length != 2) {
                String field2 = Localization.lang("field", new String[0]);
                JOptionPane.showMessageDialog(this, Localization.lang("Each line must be on the following form", new String[0]) + " '" + Localization.lang("Tabname", new String[0]) + ':' + field2 + "1;" + field2 + "2;...;" + field2 + "N'", Localization.lang("Error", new String[0]), 0);
                return;
            }
            String testString = BibtexKeyGenerator.cleanKey(parts[1], Globals.prefs.getBoolean("enforceLegalBibtexKey"));
            if (!testString.equals(parts[1]) || parts[1].indexOf(38) >= 0) {
                JOptionPane.showMessageDialog(this, Localization.lang("Field names are not allowed to contain white space or the following characters", new String[0]) + ": # { } ~ , ^ &", Localization.lang("Error", new String[0]), 0);
                return;
            }
            Globals.prefs.put("customTabName_" + i, parts[0]);
            Globals.prefs.put("customTabFields_" + i, parts[1].toLowerCase(Locale.ROOT));
        }
        Globals.prefs.purgeSeries("customTabName_", i);
        Globals.prefs.purgeSeries("customTabFields_", i);
        Globals.prefs.updateEntryEditorTabList();
        this.dispose();
    }

    private void setFieldsText() {
        StringBuilder sb = new StringBuilder();
        EntryEditorTabList tabList = Globals.prefs.getEntryEditorTabList();
        for (int i = 0; i < tabList.getTabCount(); ++i) {
            sb.append(tabList.getTabName(i));
            sb.append(':');
            sb.append(String.join((CharSequence)";", tabList.getTabFields(i)));
            sb.append('\n');
        }
        this.fieldsArea.setText(sb.toString());
    }

    private void revertActionPerformed() {
        String name;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while ((name = (String)Globals.prefs.defaults.get("customTabName__def" + i)) != null) {
            sb.append(name);
            String fields = (String)Globals.prefs.defaults.get("customTabFields__def" + i);
            sb.append(':');
            sb.append(fields);
            sb.append('\n');
            ++i;
        }
        this.fieldsArea.setText(sb.toString());
    }
}

