/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import org.jabref.gui.BasePanel;
import org.jabref.gui.JabRefFrame;
import org.jabref.logic.l10n.Localization;

public class WaitForSaveOperation
implements ActionListener {
    private final JabRefFrame frame;
    private final JDialog diag;
    private final Timer t = new Timer(500, this);
    private boolean canceled;

    public WaitForSaveOperation(JabRefFrame frame) {
        this.frame = frame;
        JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        JProgressBar prog = new JProgressBar(0);
        prog.setIndeterminate(true);
        prog.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag = new JDialog(frame, Localization.lang("Please wait...", new String[0]), true);
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addButton((JComponent)cancel);
        bb.addGlue();
        cancel.addActionListener(e -> {
            this.canceled = true;
            this.t.stop();
            this.diag.dispose();
        });
        JLabel message = new JLabel(Localization.lang("Waiting for save operation to finish", new String[0]) + "...");
        message.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag.getContentPane().add((Component)message, "North");
        this.diag.getContentPane().add((Component)bb.getPanel(), "South");
        this.diag.getContentPane().add((Component)prog, "Center");
        this.diag.pack();
    }

    public void show() {
        this.diag.setLocationRelativeTo(this.frame);
        this.t.start();
        this.diag.setVisible(true);
    }

    public boolean canceled() {
        return this.canceled;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean anySaving = false;
        for (BasePanel basePanel : this.frame.getBasePanelList()) {
            if (!basePanel.isSaving()) continue;
            anySaving = true;
            break;
        }
        if (!anySaving) {
            this.t.stop();
            this.diag.dispose();
        }
    }
}

