/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.customentrytypes;

import java.util.List;
import java.util.stream.Collectors;
import org.jabref.model.EntryTypes;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.CustomEntryType;
import org.jabref.preferences.JabRefPreferences;

public class CustomEntryTypesManager {
    private CustomEntryTypesManager() {
    }

    public static void saveCustomEntryTypes(JabRefPreferences prefs) {
        CustomEntryTypesManager.saveCustomEntryTypes(prefs, BibDatabaseMode.BIBTEX);
        CustomEntryTypesManager.saveCustomEntryTypes(prefs, BibDatabaseMode.BIBLATEX);
    }

    private static void saveCustomEntryTypes(JabRefPreferences prefs, BibDatabaseMode mode) {
        List<CustomEntryType> customBiblatexTypes = EntryTypes.getAllValues(mode).stream().filter(type -> type instanceof CustomEntryType).map(entryType -> (CustomEntryType)entryType).collect(Collectors.toList());
        prefs.storeCustomEntryTypes(customBiblatexTypes, mode);
    }
}

