/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.push;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.io.IOException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.FXDialogService;
import org.jabref.gui.push.PushToApplication;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.OS;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.metadata.MetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPushToApplication
implements PushToApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPushToApplication.class);
    protected boolean couldNotCall;
    protected boolean couldNotConnect;
    protected boolean notDefined;
    protected JPanel settings;
    protected final JTextField path = new JTextField(30);
    protected String commandPath;
    protected String commandPathPreferenceKey;
    protected FormBuilder builder;

    @Override
    public String getName() {
        return Localization.menuTitle("Push entries to external application (%0)", this.getApplicationName());
    }

    @Override
    public String getTooltip() {
        return Localization.lang("Push to %0", this.getApplicationName());
    }

    @Override
    public void pushEntries(BibDatabase database, List<BibEntry> entries, String keyString, MetaData metaData) {
        this.couldNotConnect = false;
        this.couldNotCall = false;
        this.notDefined = false;
        this.initParameters();
        this.commandPath = Globals.prefs.get(this.commandPathPreferenceKey);
        if (this.commandPath == null || this.commandPath.trim().isEmpty()) {
            this.notDefined = true;
            return;
        }
        try {
            if (OS.OS_X) {
                String[] commands = this.getCommandLine(keyString);
                if (commands.length < 3) {
                    LOGGER.error("Commandline does not contain enough parameters to \"push to application\"");
                    return;
                }
                ProcessBuilder processBuilder = new ProcessBuilder("open", "-a", commands[0], "-n", "--args", commands[1], commands[2]);
                processBuilder.start();
            } else {
                ProcessBuilder processBuilder = new ProcessBuilder(this.getCommandLine(keyString));
                processBuilder.start();
            }
        }
        catch (IOException excep) {
            this.couldNotCall = true;
            LOGGER.warn("Error: Could not call executable '" + this.commandPath + "'.", excep);
        }
    }

    @Override
    public void operationCompleted(BasePanel panel) {
        if (this.notDefined) {
            panel.output(Localization.lang("Error", new String[0]) + ": " + Localization.lang("Path to %0 not defined", this.getApplicationName()) + ".");
        } else if (this.couldNotCall) {
            panel.output(Localization.lang("Error", new String[0]) + ": " + Localization.lang("Could not call executable", new String[0]) + " '" + this.commandPath + "'.");
        } else if (this.couldNotConnect) {
            panel.output(Localization.lang("Error", new String[0]) + ": " + Localization.lang("Could not connect to %0", this.getApplicationName()) + ".");
        } else {
            panel.output(Localization.lang("Pushed citations to %0", this.getApplicationName()) + ".");
        }
    }

    @Override
    public boolean requiresBibtexKeys() {
        return true;
    }

    protected String[] getCommandLine(String keyString) {
        return new String[0];
    }

    protected String getCommandName() {
        return null;
    }

    @Override
    public JPanel getSettingsPanel() {
        this.initParameters();
        this.commandPath = Globals.prefs.get(this.commandPathPreferenceKey);
        if (this.settings == null) {
            this.initSettingsPanel();
        }
        this.path.setText(this.commandPath);
        return this.settings;
    }

    protected abstract void initParameters();

    protected void initSettingsPanel() {
        this.builder = FormBuilder.create();
        this.builder.layout(new FormLayout("left:pref, 4dlu, fill:pref:grow, 4dlu, fill:pref", "p"));
        StringBuilder label = new StringBuilder(Localization.lang("Path to %0", this.getApplicationName()));
        if (this.getCommandName() == null) {
            label.append(':');
        } else {
            label.append(" (").append(this.getCommandName()).append("):");
        }
        this.builder.add(label.toString(), new Object[0]).xy(1, 1);
        this.builder.add(this.path).xy(3, 1);
        JButton browse = new JButton(Localization.lang("Browse", new String[0]));
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().withInitialDirectory(Globals.prefs.get("workingDirectory")).build();
        FXDialogService ds = new FXDialogService();
        browse.addActionListener(e -> DefaultTaskExecutor.runInJavaFXThread(() -> ds.showFileOpenDialog(fileDialogConfiguration)).ifPresent(f -> this.path.setText(f.toAbsolutePath().toString())));
        this.builder.add(browse).xy(5, 1);
        this.settings = this.builder.build();
    }

    @Override
    public void storeSettings() {
        Globals.prefs.put(this.commandPathPreferenceKey, this.path.getText());
    }

    protected String getCiteCommand() {
        return Globals.prefs.get("citeCommand");
    }
}

