/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.undo;

import org.jabref.gui.undo.AbstractUndoableJabRefEdit;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndoableFieldChange
extends AbstractUndoableJabRefEdit {
    private static final Logger LOGGER = LoggerFactory.getLogger(UndoableFieldChange.class);
    private final BibEntry entry;
    private final String field;
    private final String oldValue;
    private final String newValue;

    public UndoableFieldChange(BibEntry entry, String field2, String oldValue, String newValue) {
        this.entry = entry;
        this.field = field2;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public UndoableFieldChange(FieldChange change) {
        this(change.getEntry(), change.getField(), change.getOldValue(), change.getNewValue());
    }

    @Override
    public String getPresentationName() {
        return Localization.lang("change field %0 of entry %1 from %2 to %3", StringUtil.boldHTML(this.field), StringUtil.boldHTML(this.entry.getCiteKeyOptional().orElse(Localization.lang("undefined", new String[0]))), StringUtil.boldHTML(this.oldValue, Localization.lang("undefined", new String[0])), StringUtil.boldHTML(this.newValue, Localization.lang("undefined", new String[0])));
    }

    @Override
    public void undo() {
        super.undo();
        try {
            if (this.oldValue == null) {
                this.entry.clearField(this.field);
            } else {
                this.entry.setField(this.field, this.oldValue);
            }
        }
        catch (IllegalArgumentException ex) {
            LOGGER.info("Cannot perform undo", ex);
        }
    }

    @Override
    public void redo() {
        super.redo();
        try {
            if (this.newValue == null) {
                this.entry.clearField(this.field);
            } else {
                this.entry.setField(this.field, this.newValue);
            }
        }
        catch (IllegalArgumentException ex) {
            LOGGER.info("Cannot perform redo", ex);
        }
    }
}

