/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bibtexkeypattern;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jabref.logic.bibtexkeypattern.BibtexKeyPatternPreferences;
import org.jabref.logic.bibtexkeypattern.BracketedPattern;
import org.jabref.model.FieldChange;
import org.jabref.model.bibtexkeypattern.AbstractBibtexKeyPattern;
import org.jabref.model.bibtexkeypattern.GlobalBibtexKeyPattern;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BibtexKeyGenerator
extends BracketedPattern {
    public static final String APPENDIX_CHARACTERS = "abcdefghijklmnopqrstuvwxyz";
    private static final Logger LOGGER = LoggerFactory.getLogger(BibtexKeyGenerator.class);
    private static final String KEY_ILLEGAL_CHARACTERS = "{}(),\\\"#~^':`";
    private static final String KEY_UNWANTED_CHARACTERS = "{}(),\\\"";
    private final AbstractBibtexKeyPattern citeKeyPattern;
    private final BibDatabase database;
    private final BibtexKeyPatternPreferences bibtexKeyPatternPreferences;

    public BibtexKeyGenerator(BibDatabaseContext bibDatabaseContext, BibtexKeyPatternPreferences bibtexKeyPatternPreferences) {
        this(bibDatabaseContext.getMetaData().getCiteKeyPattern(bibtexKeyPatternPreferences.getKeyPattern()), bibDatabaseContext.getDatabase(), bibtexKeyPatternPreferences);
    }

    public BibtexKeyGenerator(AbstractBibtexKeyPattern citeKeyPattern, BibDatabase database, BibtexKeyPatternPreferences bibtexKeyPatternPreferences) {
        this.citeKeyPattern = Objects.requireNonNull(citeKeyPattern);
        this.database = Objects.requireNonNull(database);
        this.bibtexKeyPatternPreferences = Objects.requireNonNull(bibtexKeyPatternPreferences);
    }

    static String generateKey(BibEntry entry, String pattern) {
        return BibtexKeyGenerator.generateKey(entry, pattern, new BibDatabase());
    }

    static String generateKey(BibEntry entry, String pattern, BibDatabase database) {
        GlobalBibtexKeyPattern keyPattern = new GlobalBibtexKeyPattern(Collections.emptyList());
        keyPattern.setDefaultValue("[" + pattern + "]");
        return new BibtexKeyGenerator(keyPattern, database, new BibtexKeyPatternPreferences("", "", false, true, true, keyPattern, Character.valueOf(','))).generateKey(entry);
    }

    private static String getAppendix(int number) {
        if (number >= APPENDIX_CHARACTERS.length()) {
            int lastChar = number % APPENDIX_CHARACTERS.length();
            return BibtexKeyGenerator.getAppendix(number / APPENDIX_CHARACTERS.length() - 1) + APPENDIX_CHARACTERS.substring(lastChar, lastChar + 1);
        }
        return APPENDIX_CHARACTERS.substring(number, number + 1);
    }

    public static String cleanKey(String key, boolean enforceLegalKey) {
        if (!enforceLegalKey) {
            StringBuilder newKey = new StringBuilder();
            for (int i = 0; i < key.length(); ++i) {
                char c = key.charAt(i);
                if (Character.isWhitespace(c) || KEY_UNWANTED_CHARACTERS.indexOf(c) != -1) continue;
                newKey.append(c);
            }
            return newKey.toString();
        }
        StringBuilder newKey = new StringBuilder();
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (Character.isWhitespace(c) || KEY_ILLEGAL_CHARACTERS.indexOf(c) != -1) continue;
            newKey.append(c);
        }
        return StringUtil.replaceSpecialCharacters(newKey.toString());
    }

    public String generateKey(BibEntry entry) {
        String newKey;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String entryType = entry.getType();
            ArrayList<String> typeList = new ArrayList<String>(this.citeKeyPattern.getValue(entryType));
            if (!typeList.isEmpty()) {
                typeList.remove(0);
            }
            boolean field2 = false;
            for (String typeListEntry : typeList) {
                if ("[".equals(typeListEntry)) {
                    field2 = true;
                    continue;
                }
                if ("]".equals(typeListEntry)) {
                    field2 = false;
                    continue;
                }
                if (field2) {
                    List<String> parts = BibtexKeyGenerator.parseFieldMarker(typeListEntry);
                    Character delimiter = this.bibtexKeyPatternPreferences.getKeywordDelimiter();
                    String pattern = "[" + parts.get(0) + "]";
                    String label = BibtexKeyGenerator.expandBrackets(pattern, delimiter, entry, this.database);
                    if (parts.size() > 1) {
                        label = BibtexKeyGenerator.applyModifiers(label, parts, 1);
                    }
                    stringBuilder.append(label);
                    continue;
                }
                stringBuilder.append(typeListEntry);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Cannot make label", e);
        }
        String key = BibtexKeyGenerator.cleanKey(stringBuilder.toString(), this.bibtexKeyPatternPreferences.isEnforceLegalKey());
        String regex = this.bibtexKeyPatternPreferences.getKeyPatternRegex();
        if (regex != null && !regex.trim().isEmpty()) {
            String replacement = this.bibtexKeyPatternPreferences.getKeyPatternReplacement();
            key = key.replaceAll(regex, replacement);
        }
        String oldKey = entry.getCiteKeyOptional().orElse(null);
        int occurrences = this.database.getDuplicationChecker().getNumberOfKeyOccurrences(key);
        if (Objects.equals(oldKey, key)) {
            --occurrences;
        }
        boolean alwaysAddLetter = this.bibtexKeyPatternPreferences.isAlwaysAddLetter();
        boolean firstLetterA = this.bibtexKeyPatternPreferences.isFirstLetterA();
        if (!alwaysAddLetter && occurrences == 0) {
            newKey = key;
        } else {
            String moddedKey;
            int number = !alwaysAddLetter && !firstLetterA ? 1 : 0;
            do {
                moddedKey = key + BibtexKeyGenerator.getAppendix(number);
                ++number;
                occurrences = this.database.getDuplicationChecker().getNumberOfKeyOccurrences(moddedKey);
                if (!Objects.equals(oldKey, moddedKey)) continue;
                --occurrences;
            } while (occurrences > 0);
            newKey = moddedKey;
        }
        return newKey;
    }

    public Optional<FieldChange> generateAndSetKey(BibEntry entry) {
        String newKey = this.generateKey(entry);
        return entry.setCiteKey(newKey);
    }
}

