/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jabref.logic.formatter.bibtexfields.AddBracesFormatter;
import org.jabref.logic.formatter.bibtexfields.ClearFormatter;
import org.jabref.logic.formatter.bibtexfields.EscapeUnderscoresFormatter;
import org.jabref.logic.formatter.bibtexfields.HtmlToLatexFormatter;
import org.jabref.logic.formatter.bibtexfields.HtmlToUnicodeFormatter;
import org.jabref.logic.formatter.bibtexfields.LatexCleanupFormatter;
import org.jabref.logic.formatter.bibtexfields.NormalizeDateFormatter;
import org.jabref.logic.formatter.bibtexfields.NormalizeEnDashesFormatter;
import org.jabref.logic.formatter.bibtexfields.NormalizeMonthFormatter;
import org.jabref.logic.formatter.bibtexfields.NormalizeNamesFormatter;
import org.jabref.logic.formatter.bibtexfields.NormalizePagesFormatter;
import org.jabref.logic.formatter.bibtexfields.OrdinalsToSuperscriptFormatter;
import org.jabref.logic.formatter.bibtexfields.RegexFormatter;
import org.jabref.logic.formatter.bibtexfields.RemoveBracesFormatter;
import org.jabref.logic.formatter.bibtexfields.UnicodeToLatexFormatter;
import org.jabref.logic.formatter.bibtexfields.UnitsToLatexFormatter;
import org.jabref.logic.formatter.casechanger.CapitalizeFormatter;
import org.jabref.logic.formatter.casechanger.LowerCaseFormatter;
import org.jabref.logic.formatter.casechanger.SentenceCaseFormatter;
import org.jabref.logic.formatter.casechanger.TitleCaseFormatter;
import org.jabref.logic.formatter.casechanger.UpperCaseFormatter;
import org.jabref.logic.formatter.minifier.MinifyNameListFormatter;
import org.jabref.logic.layout.format.LatexToUnicodeFormatter;
import org.jabref.model.cleanup.Formatter;

public class Formatters {
    private static final List<Formatter> CONVERTERS = Arrays.asList(new HtmlToLatexFormatter(), new HtmlToUnicodeFormatter(), new LatexToUnicodeFormatter(), new UnicodeToLatexFormatter());
    private static final List<Formatter> CASE_CHANGERS = Arrays.asList(new CapitalizeFormatter(), new LowerCaseFormatter(), new SentenceCaseFormatter(), new TitleCaseFormatter(), new UpperCaseFormatter());
    private static final List<Formatter> OTHERS = Arrays.asList(new AddBracesFormatter(), new ClearFormatter(), new LatexCleanupFormatter(), new MinifyNameListFormatter(), new NormalizeDateFormatter(), new NormalizeEnDashesFormatter(), new NormalizeMonthFormatter(), new NormalizeNamesFormatter(), new NormalizePagesFormatter(), new OrdinalsToSuperscriptFormatter(), new RegexFormatter(), new RemoveBracesFormatter(), new UnitsToLatexFormatter(), new EscapeUnderscoresFormatter());
    private static final String REGEX = "regex";
    private static final int LENGTH_OF_REGEX_PREFIX = "regex".length();

    private Formatters() {
    }

    public static final List<Formatter> getConverters() {
        ArrayList<Formatter> converters = new ArrayList<Formatter>();
        converters.addAll(CONVERTERS);
        return converters;
    }

    public static final List<Formatter> getCaseChangers() {
        ArrayList<Formatter> caseChangers = new ArrayList<Formatter>();
        caseChangers.addAll(CASE_CHANGERS);
        return caseChangers;
    }

    public static final List<Formatter> getOthers() {
        ArrayList<Formatter> others = new ArrayList<Formatter>();
        others.addAll(OTHERS);
        return others;
    }

    public static final List<Formatter> getAll() {
        ArrayList<Formatter> all2 = new ArrayList<Formatter>();
        all2.addAll(CONVERTERS);
        all2.addAll(CASE_CHANGERS);
        all2.addAll(OTHERS);
        return all2;
    }

    public static Optional<Formatter> getFormatterForModifier(String modifier) {
        Optional<Formatter> formatter;
        Objects.requireNonNull(modifier);
        List<Formatter> all2 = Formatters.getAll();
        if (modifier.matches("regex.*")) {
            String regex = modifier.substring(LENGTH_OF_REGEX_PREFIX);
            RegexFormatter.setRegex(regex);
            formatter = all2.stream().filter(f -> f.getKey().equals(REGEX)).findAny();
        } else {
            formatter = all2.stream().filter(f -> f.getKey().equals(modifier)).findAny();
        }
        if (formatter.isPresent()) {
            return formatter;
        }
        switch (modifier) {
            case "lower": {
                return Optional.of(new LowerCaseFormatter());
            }
            case "upper": {
                return Optional.of(new UpperCaseFormatter());
            }
        }
        return Optional.empty();
    }
}

