/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.http.client.utils.URIBuilder;
import org.jabref.logic.importer.EntryBasedFetcher;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.importer.fileformat.MrDLibImporter;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.net.URLDownload;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrDLibFetcher
implements EntryBasedFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(MrDLibFetcher.class);
    private static final String NAME = "MDL_FETCHER";
    private final String LANGUAGE;
    private final String VERSION;

    public MrDLibFetcher(String language2, String version) {
        this.LANGUAGE = language2;
        this.VERSION = version;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<BibEntry> performSearch(BibEntry entry) throws FetcherException {
        Optional<String> title = entry.getLatexFreeField("title");
        if (title.isPresent()) {
            String response = this.makeServerRequest(title.get());
            MrDLibImporter importer = new MrDLibImporter();
            ParserResult parserResult = new ParserResult();
            try {
                if (importer.isRecognizedFormat(response)) {
                    parserResult = importer.importDatabase(response);
                } else {
                    BibEntry errorBibEntry = new BibEntry();
                    errorBibEntry.setField("html_representation", Localization.lang("Error while fetching from %0", "Mr.DLib"));
                    BibDatabase errorBibDataBase = new BibDatabase();
                    errorBibDataBase.insertEntry(errorBibEntry);
                    parserResult = new ParserResult(errorBibDataBase);
                }
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), e);
                throw new FetcherException("XML Parser IOException.");
            }
            return parserResult.getDatabase().getEntries();
        }
        return new ArrayList<BibEntry>(0);
    }

    private String makeServerRequest(String queryByTitle) throws FetcherException {
        try {
            URLDownload urlDownload = new URLDownload(this.constructQuery(queryByTitle));
            urlDownload.bypassSSLVerification();
            String response = urlDownload.asString();
            response = response.replaceAll("&gt;", ">");
            response = response.replaceAll("&lt;", "<");
            return response;
        }
        catch (IOException e) {
            throw new FetcherException("Problem downloading", e);
        }
    }

    private String constructQuery(String queryWithTitle) {
        queryWithTitle = queryWithTitle.replaceAll("/", "convbckslsh");
        URIBuilder builder = new URIBuilder();
        builder.setScheme("https");
        builder.setHost("api.mr-dlib.org");
        builder.setPath("/v1/documents/" + queryWithTitle + "/related_documents");
        builder.addParameter("partner_id", "jabref");
        builder.addParameter("app_id", "jabref_desktop");
        builder.addParameter("app_version", this.VERSION);
        builder.addParameter("app_lang", this.LANGUAGE);
        URI uri = null;
        try {
            uri = builder.build();
            return uri.toString();
        }
        catch (URISyntaxException e) {
            LOGGER.error(e.getMessage(), e);
            return "";
        }
    }
}

