/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.l10n;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import org.jabref.logic.l10n.LocalizationKey;

public class LocalizationKeyParams {
    private final LocalizationKey key;
    private final List<String> params;

    public LocalizationKeyParams(String key, String ... params) {
        this.key = new LocalizationKey(key);
        this.params = Arrays.asList(params);
        if (this.params.size() > 10) {
            throw new IllegalStateException("Translations can only have at most 10 parameters");
        }
    }

    public String replacePlaceholders() {
        String translation = this.key.getTranslationValue();
        for (int i = 0; i < this.params.size(); ++i) {
            String param2 = this.params.get(i);
            translation = translation.replaceAll("%" + i, Matcher.quoteReplacement(param2));
        }
        return translation;
    }
}

