/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.layout.format;

import org.jabref.logic.layout.LayoutFormatter;
import org.jabref.logic.layout.StringInt;
import org.jabref.logic.util.strings.RtfCharMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTFChars
implements LayoutFormatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LayoutFormatter.class);
    private static final RtfCharMap RTF_CHARS = new RtfCharMap();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String format(String field2) {
        StringBuilder sb = new StringBuilder("");
        StringBuilder currentCommand = null;
        boolean escaped = false;
        boolean incommand = false;
        for (int i = 0; i < field2.length(); ++i) {
            String command;
            char c = field2.charAt(i);
            if (escaped && c == '\\') {
                sb.append('\\');
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                incommand = true;
                currentCommand = new StringBuilder();
                continue;
            }
            if (!incommand && (c == '{' || c == '}')) continue;
            if (Character.isLetter(c) || "\"`^~'=.|".contains(String.valueOf(c))) {
                escaped = false;
                if (incommand) {
                    String combody;
                    currentCommand.append(c);
                    if (currentCommand.length() != 1 || !"\"`^~'=.|".contains(currentCommand.toString()) || i >= field2.length() - 1) continue;
                    command = currentCommand.toString();
                    if ((c = field2.charAt(++i)) == '{') {
                        StringInt part = this.getPart(field2, i, true);
                        i += part.i;
                        combody = part.s;
                    } else {
                        combody = field2.substring(i, i + 1);
                    }
                    String result = RTF_CHARS.get(command + combody);
                    if (result != null) {
                        sb.append(result);
                    }
                    incommand = false;
                    escaped = false;
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (!incommand || !Character.isWhitespace(c) && c != '{' && c != '}') {
                sb.append(c);
            } else {
                assert (incommand);
                if (c == '{' && currentCommand.length() == 0) continue;
                if (c == '}' && currentCommand.length() > 0) {
                    command = currentCommand.toString();
                    String result = RTF_CHARS.get(command);
                    if (result != null) {
                        sb.append(result);
                    }
                    incommand = false;
                    escaped = false;
                    continue;
                }
                if (i < field2.length() - 1) {
                    if ((c == '{' || c == ' ') && currentCommand.length() > 0) {
                        StringInt part;
                        command = currentCommand.toString();
                        if ("em".equals(command) || "emph".equals(command) || "textit".equals(command) || "it".equals(command)) {
                            part = this.getPart(field2, i, c == '{');
                            i += part.i;
                            sb.append("{\\i ").append(part.s).append('}');
                        } else if ("textbf".equals(command) || "bf".equals(command)) {
                            part = this.getPart(field2, i, c == '{');
                            i += part.i;
                            sb.append("{\\b ").append(part.s).append('}');
                        } else {
                            LOGGER.info("Unknown command " + command);
                        }
                        if (c != ' ') {
                            // empty if block
                        }
                    } else {
                        sb.append(c);
                    }
                }
            }
            incommand = false;
            escaped = false;
        }
        char[] chars = sb.toString().toCharArray();
        sb = new StringBuilder();
        char[] cArray = chars;
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c < '\u0080') {
                sb.append(c);
            } else {
                sb.append("\\u").append((long)c).append(this.transformSpecialCharacter(c));
            }
            ++n2;
        }
        return sb.toString().replace("---", "{\\emdash}").replace("--", "{\\endash}").replace("``", "{\\ldblquote}").replace("''", "{\\rdblquote}");
    }

    /*
     * Enabled aggressive block sorting
     */
    private StringInt getPart(String text, int i, boolean commandNestedInBraces) {
        int count = 0;
        int icount = i;
        StringBuilder part = new StringBuilder();
        block5: while (count >= 0 && icount < text.length()) {
            char c = text.charAt(++icount);
            switch (c) {
                case '}': {
                    --count;
                    break;
                }
                case '{': {
                    ++count;
                    break;
                }
                case ' ': {
                    if (!commandNestedInBraces) break block5;
                }
            }
            part.append(c);
        }
        String res = part.toString();
        return new StringInt(this.format(res), part.length());
    }

    private String transformSpecialCharacter(long c) {
        if (192L <= c && c <= 197L || c == 256L || c == 258L || c == 260L) {
            return "A";
        }
        if (224L <= c && c <= 229L || c == 257L || c == 259L || c == 261L) {
            return "a";
        }
        if (199L == c || 262L == c || 264L == c || 266L == c || 268L == c) {
            return "C";
        }
        if (231L == c || 263L == c || 265L == c || 267L == c || 269L == c) {
            return "c";
        }
        if (208L == c || 272L == c) {
            return "D";
        }
        if (240L == c || 273L == c) {
            return "d";
        }
        if (200L <= c && c <= 203L || 274L == c || 276L == c || 278L == c || 280L == c || 282L == c) {
            return "E";
        }
        if (232L <= c && c <= 235L || 275L == c || 277L == c || 279L == c || 281L == c || 283L == c) {
            return "e";
        }
        if (284L == c || 286L == c || 288L == c || 290L == c || 330L == c) {
            return "G";
        }
        if (285L == c || 287L == c || 289L == c || 291L == c || 331L == c) {
            return "g";
        }
        if (292L == c || 294L == c) {
            return "H";
        }
        if (293L == c || 295L == c) {
            return "h";
        }
        if (204L <= c && c <= 207L || 296L == c || 298L == c || 300L == c || 302L == c || 304L == c) {
            return "I";
        }
        if (236L <= c && c <= 239L || 297L == c || 299L == c || 301L == c || 303L == c) {
            return "i";
        }
        if (308L == c) {
            return "J";
        }
        if (309L == c) {
            return "j";
        }
        if (310L == c) {
            return "K";
        }
        if (311L == c) {
            return "k";
        }
        if (313L == c || 315L == c || 319L == c) {
            return "L";
        }
        if (314L == c || 316L == c || 320L == c || 322L == c) {
            return "l";
        }
        if (209L == c || 323L == c || 325L == c || 327L == c) {
            return "N";
        }
        if (241L == c || 324L == c || 326L == c || 328L == c) {
            return "n";
        }
        if (210L <= c && c <= 214L || c == 216L || 332L == c || 334L == c) {
            return "O";
        }
        if (242L <= c && c <= 248L && 247L != c || 333L == c || 335L == c) {
            return "o";
        }
        if (340L == c || 342L == c || 344L == c) {
            return "R";
        }
        if (341L == c || 343L == c || 345L == c) {
            return "r";
        }
        if (346L == c || 348L == c || 350L == c || 352L == c) {
            return "S";
        }
        if (347L == c || 349L == c || 351L == c || 353L == c) {
            return "s";
        }
        if (354L == c || 356L == c || 358L == c) {
            return "T";
        }
        if (355L == c || 359L == c) {
            return "t";
        }
        if (217L <= c && c <= 220L || 360L == c || 362L == c || 364L == c || 366L == c || 370L == c) {
            return "U";
        }
        if (249L <= c && c <= 251L || 361L == c || 363L == c || 365L == c || 367L == c || 371L == c) {
            return "u";
        }
        if (372L == c) {
            return "W";
        }
        if (373L == c) {
            return "w";
        }
        if (374L == c || 376L == c || 221L == c) {
            return "Y";
        }
        if (375L == c || 255L == c) {
            return "y";
        }
        if (377L == c || 379L == c || 381L == c) {
            return "Z";
        }
        if (378L == c || 380L == c || 382L == c) {
            return "z";
        }
        if (198L == c) {
            return "AE";
        }
        if (230L == c) {
            return "ae";
        }
        if (338L == c) {
            return "OE";
        }
        if (339L == c) {
            return "oe";
        }
        if (222L == c) {
            return "TH";
        }
        if (223L == c) {
            return "ss";
        }
        if (161L == c) {
            return "!";
        }
        return "?";
    }
}

