/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import org.reactfx.ConnectableEventSink;
import org.reactfx.ConnectableEventStream;
import org.reactfx.EventStream;
import org.reactfx.EventStreamBase;
import org.reactfx.Subscription;
import org.reactfx.util.MapHelper;

public final class ConnectableEventSource<T>
extends EventStreamBase<T>
implements ConnectableEventStream<T>,
ConnectableEventSink<T> {
    private MapHelper<EventStream<? extends T>, Subscription> subscriptions = null;

    @Override
    public final void push(T value) {
        this.emit(value);
    }

    @Override
    public Subscription connectTo(EventStream<? extends T> input) {
        if (MapHelper.containsKey(this.subscriptions, input)) {
            throw new IllegalStateException("Already connected to event stream " + input);
        }
        Subscription sub = this.isObservingInputs() ? this.subscribeToInput(input) : null;
        this.subscriptions = MapHelper.put(this.subscriptions, input, sub);
        return () -> {
            Subscription s2 = MapHelper.get(this.subscriptions, input);
            this.subscriptions = MapHelper.remove(this.subscriptions, input);
            if (s2 != null) {
                s2.unsubscribe();
            }
        };
    }

    @Override
    protected final Subscription observeInputs() {
        MapHelper.replaceAll(this.subscriptions, (input, sub) -> this.subscribeToInput((EventStream<? extends T>)input));
        return () -> MapHelper.replaceAll(this.subscriptions, (input, sub) -> {
            sub.unsubscribe();
            return null;
        });
    }

    private final Subscription subscribeToInput(EventStream<? extends T> input) {
        return input.subscribe(this::push);
    }
}

