/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.analysis;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.declarative.dsl.schema.DataType;
import org.gradle.internal.declarativedsl.analysis.AnalysisContext;
import org.gradle.internal.declarativedsl.analysis.AnalysisScope;
import org.gradle.internal.declarativedsl.analysis.ExpectedTypeData;
import org.gradle.internal.declarativedsl.analysis.ExpressionResolver;
import org.gradle.internal.declarativedsl.analysis.FunctionCallResolver;
import org.gradle.internal.declarativedsl.analysis.NamedReferenceResolver;
import org.gradle.internal.declarativedsl.analysis.ObjectOrigin;
import org.gradle.internal.declarativedsl.analysis.TypedOrigin;
import org.gradle.internal.declarativedsl.analysis.UtilsKt;
import org.gradle.internal.declarativedsl.language.DataTypeInternal;
import org.gradle.internal.declarativedsl.language.Expr;
import org.gradle.internal.declarativedsl.language.FunctionCall;
import org.gradle.internal.declarativedsl.language.Literal;
import org.gradle.internal.declarativedsl.language.NamedReference;
import org.gradle.internal.declarativedsl.language.Null;
import org.gradle.internal.declarativedsl.language.This;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\t\"\b\b\u0000\u0010\u0011*\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/gradle/internal/declarativedsl/analysis/ExpressionResolverImpl;", "Lorg/gradle/internal/declarativedsl/analysis/ExpressionResolver;", "namedReferenceResolver", "Lorg/gradle/internal/declarativedsl/analysis/NamedReferenceResolver;", "functionCallResolver", "Lorg/gradle/internal/declarativedsl/analysis/FunctionCallResolver;", "<init>", "(Lorg/gradle/internal/declarativedsl/analysis/NamedReferenceResolver;Lorg/gradle/internal/declarativedsl/analysis/FunctionCallResolver;)V", "doResolveExpression", "Lorg/gradle/internal/declarativedsl/analysis/TypedOrigin;", "context", "Lorg/gradle/internal/declarativedsl/analysis/AnalysisContext;", "expr", "Lorg/gradle/internal/declarativedsl/language/Expr;", "expectedType", "Lorg/gradle/internal/declarativedsl/analysis/ExpectedTypeData;", "literalObjectOrigin", "T", "", "literalExpr", "Lorg/gradle/internal/declarativedsl/language/Literal;", "declarative-dsl-core"})
@SourceDebugExtension(value={"SMAP\nExpressionResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpressionResolver.kt\norg/gradle/internal/declarativedsl/analysis/ExpressionResolverImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n1#2:55\n*E\n"})
public final class ExpressionResolverImpl
implements ExpressionResolver {
    @NotNull
    private final NamedReferenceResolver namedReferenceResolver;
    @NotNull
    private final FunctionCallResolver functionCallResolver;

    public ExpressionResolverImpl(@NotNull NamedReferenceResolver namedReferenceResolver, @NotNull FunctionCallResolver functionCallResolver) {
        Intrinsics.checkNotNullParameter((Object)namedReferenceResolver, (String)"namedReferenceResolver");
        Intrinsics.checkNotNullParameter((Object)functionCallResolver, (String)"functionCallResolver");
        this.namedReferenceResolver = namedReferenceResolver;
        this.functionCallResolver = functionCallResolver;
    }

    @Override
    @Nullable
    public TypedOrigin doResolveExpression(@NotNull AnalysisContext context, @NotNull Expr expr, @NotNull ExpectedTypeData expectedType) {
        TypedOrigin typedOrigin;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        AnalysisContext $this$doResolveExpression_u24lambda_u241 = context;
        boolean bl = false;
        Expr expr2 = expr;
        if (expr2 instanceof NamedReference) {
            typedOrigin = this.namedReferenceResolver.doResolveNamedReferenceToObjectOrigin(context, (NamedReference)expr, expectedType);
        } else if (expr2 instanceof FunctionCall) {
            typedOrigin = this.functionCallResolver.doResolveFunctionCall(context, (FunctionCall)expr, expectedType);
        } else if (expr2 instanceof Literal) {
            typedOrigin = this.literalObjectOrigin((Literal)expr);
        } else if (expr2 instanceof Null) {
            typedOrigin = new TypedOrigin(new ObjectOrigin.NullObjectOrigin((Null)expr), (DataType)DataTypeInternal.DefaultNullType.INSTANCE);
        } else if (expr2 instanceof This) {
            ObjectOrigin.ReceiverOrigin it = ((AnalysisScope)CollectionsKt.last($this$doResolveExpression_u24lambda_u241.getCurrentScopes())).getReceiver();
            boolean bl2 = false;
            typedOrigin = new TypedOrigin(it, UtilsKt.getDataType($this$doResolveExpression_u24lambda_u241, it));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return typedOrigin;
    }

    private final <T> TypedOrigin literalObjectOrigin(Literal<T> literalExpr) {
        return new TypedOrigin(new ObjectOrigin.ConstantOrigin(literalExpr), (DataType)literalExpr.getType());
    }
}

