/* snpTmp.c was originally generated by the autoSql program, which also 
 * generated snpTmp.h and snpTmp.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "snpTmp.h"


void snpTmpStaticLoad(char **row, struct snpTmp *ret)
/* Load a row from snpTmp table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
strcpy(ret->strand, row[4]);
ret->refNCBI = row[5];
ret->locType = row[6];
ret->func = row[7];
ret->contigName = row[8];
}

struct snpTmp *snpTmpLoad(char **row)
/* Load a snpTmp from row fetched with select * from snpTmp
 * from database.  Dispose of this with snpTmpFree(). */
{
struct snpTmp *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
strcpy(ret->strand, row[4]);
ret->refNCBI = cloneString(row[5]);
ret->locType = cloneString(row[6]);
ret->func = cloneString(row[7]);
ret->contigName = cloneString(row[8]);
return ret;
}

struct snpTmp *snpTmpLoadAll(char *fileName) 
/* Load all snpTmp from a whitespace-separated file.
 * Dispose of this with snpTmpFreeList(). */
{
struct snpTmp *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[9];

while (lineFileRow(lf, row))
    {
    el = snpTmpLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct snpTmp *snpTmpLoadAllByChar(char *fileName, char chopper) 
/* Load all snpTmp from a chopper separated file.
 * Dispose of this with snpTmpFreeList(). */
{
struct snpTmp *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[9];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = snpTmpLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct snpTmp *snpTmpCommaIn(char **pS, struct snpTmp *ret)
/* Create a snpTmp out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new snpTmp */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->refNCBI = sqlStringComma(&s);
ret->locType = sqlStringComma(&s);
ret->func = sqlStringComma(&s);
ret->contigName = sqlStringComma(&s);
*pS = s;
return ret;
}

void snpTmpFree(struct snpTmp **pEl)
/* Free a single dynamically allocated snpTmp such as created
 * with snpTmpLoad(). */
{
struct snpTmp *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->refNCBI);
freeMem(el->locType);
freeMem(el->func);
freeMem(el->contigName);
freez(pEl);
}

void snpTmpFreeList(struct snpTmp **pList)
/* Free a list of dynamically allocated snpTmp's */
{
struct snpTmp *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    snpTmpFree(&el);
    }
*pList = NULL;
}

void snpTmpOutput(struct snpTmp *el, FILE *f, char sep, char lastSep) 
/* Print out snpTmp.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->refNCBI);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->locType);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->func);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->contigName);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */



void snpTmpTableCreate(struct sqlConnection *conn, char *tableName)
/* create a chrN_snpTmp table */
{
char *createString =
"CREATE TABLE %s (\n"
"    chrom         varchar(255) not null,\n"
"    chromStart    int unsigned not null,\n"
"    chromEnd      int unsigned not null,\n"
"    name          varchar(255) not null,\n"
"    strand        char(1) not null,\n"
"    refNCBI       longblob not null,\n"
"    locType       enum('unknown', 'range', 'exact', 'between',\n"
"                  'rangeInsertion', 'rangeSubstitution', 'rangeDeletion') \n"
"                  DEFAULT 'unknown' NOT NULL,\n"
"    func       set( 'unknown', 'locus', 'coding', 'coding-synon', 'coding-nonsynon', \n"
"    		     'untranslated', 'intron', 'splice-site', 'cds-reference') \n"
"		     DEFAULT 'unknown' NOT NULL,\n"
"    			# The functional category of the SNP\n"
"    contigName    varchar(255) not null,\n"
"    INDEX         name(name)\n"
")\n";

struct dyString *dy = newDyString(512);

dyStringPrintf(dy, createString, tableName);
sqlRemakeTable(conn, tableName, dy->string);
dyStringFree(&dy);
}

int snpTmpCmp(const void *va, const void *vb)
{
const struct snpTmp *a = *((struct snpTmp **)va);
const struct snpTmp *b = *((struct snpTmp **)vb);
int dif;
dif = strcmp(a->chrom, b->chrom);
if (dif == 0)
    dif = a->chromStart - b->chromStart;
    return dif;
}

