/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.util;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.xmind.core.ITopic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopicIterator
implements Iterator<ITopic> {
    public static final int NONE = 0;
    public static final int REVERSED = 1;
    private int options;
    private ITopic next;
    private Stack<Object> stack;

    public TopicIterator(ITopic root) {
        this(root, 0);
    }

    public TopicIterator(ITopic root, int options) {
        this.options = options;
        this.stack = new Stack();
        this.stack.push(root);
        this.next = this.findNext();
    }

    private static void pushFIFO(Stack<Object> stack, List<ITopic> topics) {
        ListIterator<ITopic> it = topics.listIterator(topics.size());
        while (it.hasPrevious()) {
            stack.push(it.previous());
        }
    }

    private static void pushLIFOStack(Stack<Object> stack, List<ITopic> topics) {
        for (ITopic topic : topics) {
            stack.push(topic);
        }
    }

    private ITopic findNext() {
        if (this.stack.isEmpty()) {
            return null;
        }
        Object o = this.stack.pop();
        if (this.hasOption(1)) {
            if (o instanceof TopicWrapper) {
                return ((TopicWrapper)o).topic;
            }
            ITopic t = (ITopic)o;
            this.stack.push(new TopicWrapper(t));
            TopicIterator.pushLIFOStack(this.stack, t.getAllChildren());
            return this.findNext();
        }
        ITopic t = (ITopic)o;
        TopicIterator.pushFIFO(this.stack, t.getAllChildren());
        return t;
    }

    private boolean hasOption(int option) {
        return (this.options & option) != 0;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public ITopic next() {
        ITopic t = this.next;
        if (t == null) {
            throw new NoSuchElementException();
        }
        this.next = this.findNext();
        return t;
    }

    @Override
    public void remove() {
    }

    private static class TopicWrapper {
        public final ITopic topic;

        public TopicWrapper(ITopic topic) {
            this.topic = topic;
        }
    }
}

