/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.iconfinder;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import net.xmind.verify.ui.VerifyUI20141031;
import net.xmind.verify.ui.internal.e4models.VerifyModelPage;
import org.eclipse.draw2d.Viewport;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.e4models.IModelPartContext;
import org.xmind.ui.internal.e4models.ModelPage;
import org.xmind.ui.internal.e4models.ModelPageContainer;
import org.xmind.ui.internal.iconfinder.IconSessionManager;
import org.xmind.ui.internal.iconfinder.IconfinderActivator;
import org.xmind.ui.internal.iconfinder.IconfinderContainer;
import org.xmind.ui.internal.iconfinder.IconfinderCore;
import org.xmind.ui.internal.iconfinder.IconfinderEvent;
import org.xmind.ui.internal.iconfinder.IconfinderListener;
import org.xmind.ui.internal.iconfinder.IconfinderViewer;
import org.xmind.ui.internal.iconfinder.ListDialog;
import org.xmind.ui.internal.iconfinder.LoadingDialog;
import org.xmind.ui.internal.iconfinder.Messages;
import org.xmind.ui.internal.iconfinder.model.Category;
import org.xmind.ui.internal.iconfinder.model.Icon;
import org.xmind.ui.internal.iconfinder.model.Iconset;
import org.xmind.ui.internal.iconfinder.model.SearchIconSession;
import org.xmind.ui.internal.iconfinder.model.Style;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.viewers.SWTUtils;

public class IconfinderModelPage
extends ModelPageContainer
implements IconfinderContainer {
    public static final String PAGE_ID = "org.xmind.ui.modelPart.image.pages.iconfinder";
    public static final String CONTEXT_MENU_ID = "org.xmind.ui.Iconfinder";
    static final String Icon_Back_Image = "/image/ic_back.png";
    static final String Icon_Back_Invalid_Image = "/image/ic_back_unavailable.png";
    static final String Icon_Forward_Image = "/image/ic_forward.png";
    static final String Icon_Forward_Invalid_Image = "/image/ic_forward_unavailable.png";
    static final String Icon_Search_Image = "/image/ic_search.png";
    static final String Icon_Dropdown_Image = "/image/dropdown.png";
    static final String Log_12_Image = "/image/log-12.png";
    static final String Log_64_Image = "/image/log-64.png";
    private static final int ICON_COUNT_STEP = 25;
    @Inject
    private IModelPartContext modelPartContext;
    private boolean everSearched = false;
    private boolean loadingInfoForIcon = false;
    private boolean loadingForMore = false;
    private boolean searchForIcon = true;
    boolean connectError = false;
    private int showCount = 1;
    private String categoryAndStyleSessionId = UUID.randomUUID().toString();
    private String searchIconSessionId = UUID.randomUUID().toString();
    private String searchContent;
    private String categoryIdentifier;
    private String styleIdentifier;
    private Text searchIconText;
    private Composite filterSection;
    private Composite pageForIconFilterSection;
    private Composite pageForIconsetFilterSection;
    private Label categoryNameLabel;
    private Label styleNameLabel;
    private Label iconsetLabelOnFilterSection;
    private Label iconCountLabelOnFilterSection;
    private Composite resultSection;
    private Composite defaultPageForResultSection;
    private Composite searchResultPageForResultSection;
    private Composite searchResultPageForNone;
    private Composite searchResultPageForMany;
    private Composite searchResultPageForConnectError;
    private Composite loadingInfoForIconComposite;
    private IconfinderViewer iconfinderViewer;
    private ToolItem backwardItem;
    private ToolItem forwardItem;
    private LocalResourceManager localResourceManager;
    private IconSessionManager iconSessionManager;
    private Composite categoryCombo;
    private Composite styleCombo;
    private Composite sizeCombo;
    private Composite setFilterInvisibleComposite;
    private int rasterSize = IconfinderCore.ICON_SIZE_PRIORITY_ARRAY[0];
    private IconfinderListener iconfinderListener = new IconfinderListener(){

        @Override
        public void handlerIconfinderEvent(final IconfinderEvent event) {
            IconfinderViewer viewer = IconfinderModelPage.this.getViewer();
            if (viewer != null) {
                final Control control = viewer.getControl();
                if (control == null || control.isDisposed()) {
                    return;
                }
                control.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (control.isDisposed()) {
                            return;
                        }
                        if (event.getType() == 1) {
                            IconfinderModelPage.this.updateItem((Icon)event.getSource());
                        } else if (event.getType() == 2) {
                            IconfinderModelPage.this.loadingInfoForIcon = false;
                            IconfinderModelPage.this.loadingForMore = false;
                            IconfinderModelPage.this.updateAll(event.getSource());
                        } else if (event.getType() == 16) {
                            IconfinderModelPage.this.updateAll(event.getSource());
                        }
                        if ((this).IconfinderModelPage.this.connectError) {
                            (this).IconfinderModelPage.this.connectError = false;
                            IconfinderModelPage.this.iconSessionManager.setOnSearch(false);
                        }
                    }
                });
            }
        }
    };

    public IconfinderModelPage() {
        this.addPreviousPage((ModelPage)new VerifyModelPage(){

            protected String getFeatureKey() {
                return "Iconfinder";
            }

            protected int getRequiredFeatures() {
                return 3;
            }
        });
    }

    public String getModelPageId() {
        return PAGE_ID;
    }

    public String getModelPageTitle() {
        return "Iconfinder";
    }

    protected Control createMainPage(Composite parent) {
        this.init();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginLeft = 7;
        layout.marginRight = 7;
        layout.marginTop = 10;
        layout.marginBottom = 7;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.localResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
        this.iconSessionManager = new IconSessionManager();
        this.createSearchSection(composite);
        this.createFilterSection(composite);
        this.createResultSection(composite);
        this.createBottomSection(composite);
        IconfinderCore.getInstance().addIconfinderListener(this.getSearchIconSessionId(), this.iconfinderListener);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IconfinderCore.getInstance().removeIconfinderListener(IconfinderModelPage.this.getSearchIconSessionId(), IconfinderModelPage.this.iconfinderListener);
            }
        });
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IconfinderModelPage.this.dispose();
            }
        });
        return composite;
    }

    public void createControl(Composite parent) {
        VerifyUI20141031.getUsageDataCollector().increase("ShowIconfinderCount");
        super.createControl(parent);
    }

    private void init() {
        IconfinderCore.getInstance().requestAllCategories(this.categoryAndStyleSessionId);
        IconfinderCore.getInstance().requestAllStyles(this.categoryAndStyleSessionId);
        IconfinderCore.getInstance().setModelPage(this);
    }

    private void dispose() {
        IconfinderCore.getInstance().cancelJobs();
        FileUtils.delete((File)IconfinderCore.getIconfinderSessionDirectory());
    }

    private IconfinderViewer getViewer() {
        return this.iconfinderViewer;
    }

    private void updateItem(Icon element) {
        if (this.iconfinderViewer != null && element != null) {
            List input = (List)this.iconfinderViewer.getInput();
            for (Object rightIcon : input) {
                if (!(rightIcon instanceof Icon) || ((Icon)rightIcon).getIconId() != element.getIconId()) continue;
                this.iconfinderViewer.update(new Object[]{rightIcon});
                break;
            }
        }
    }

    private void createBottomSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1, 0x1000008, false, false));
        Label imageLabel = new Label(composite, 0);
        imageLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        imageLabel.setImage((Image)this.localResourceManager.get((DeviceResourceDescriptor)IconfinderActivator.createImageDescriptor(Log_12_Image)));
        Label label = new Label(composite, 0);
        label.setText(Messages.Iconfinder_SupportMessage_label);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
    }

    private void createResultSection(Composite parent) {
        this.resultSection = new Composite(parent, 0);
        StackLayout resultSectionStackLayout = new StackLayout();
        this.resultSection.setLayout((Layout)resultSectionStackLayout);
        this.resultSection.setLayoutData((Object)new GridData(4, 4, true, true));
        this.defaultPageForResultSection = new Composite(this.resultSection, 0);
        this.defaultPageForResultSection.setLayout((Layout)new GridLayout());
        this.defaultPageForResultSection.setLayoutData((Object)new GridData(4, 4, true, true));
        Label logo = new Label(this.defaultPageForResultSection, 0);
        logo.setLayoutData((Object)new GridData(0x1000000, 0x1000008, true, true));
        logo.setImage((Image)this.localResourceManager.get((DeviceResourceDescriptor)IconfinderActivator.createImageDescriptor(Log_64_Image)));
        Label descriptionLabel = new Label(this.defaultPageForResultSection, 0);
        descriptionLabel.setText(Messages.Iconfinder_ProvideIconsCount_label);
        descriptionLabel.setLayoutData((Object)new GridData(0x1000000, 1, true, true));
        descriptionLabel.setForeground((Color)this.localResourceManager.get((DeviceResourceDescriptor)ColorDescriptor.createFrom((RGB)ColorUtils.toRGB((String)"#AAAAAA"))));
        this.searchResultPageForResultSection = new Composite(this.resultSection, 0);
        this.searchResultPageForResultSection.setLayoutData((Object)new GridData(4, 4, true, true));
        StackLayout searchResultStackLayout = new StackLayout();
        this.searchResultPageForResultSection.setLayout((Layout)searchResultStackLayout);
        this.loadingInfoForIconComposite = new Composite(this.searchResultPageForResultSection, 0);
        this.loadingInfoForIconComposite.setLayout((Layout)new GridLayout());
        this.loadingInfoForIconComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label loadingLabel = new Label(this.loadingInfoForIconComposite, 0);
        loadingLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        loadingLabel.setText(Messages.Iconfinder_LoadingState_label);
        this.searchResultPageForMany = new Composite(this.searchResultPageForResultSection, 0);
        this.searchResultPageForMany.setLayout((Layout)new GridLayout());
        this.searchResultPageForMany.setLayoutData((Object)new GridData(4, 4, true, true));
        this.modelPartContext.registerContextMenu((Object)this.searchResultPageForMany, CONTEXT_MENU_ID);
        this.iconfinderViewer = new IconfinderViewer(this, this.searchResultPageForMany);
        this.iconfinderViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.iconfinderViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ISelection selection = event.getSelection();
                IconfinderModelPage.this.handleIconOpenEvent(selection);
            }
        });
        ArrayList<Object> input = new ArrayList<Object>();
        List<Icon> searchedIcons = IconfinderCore.getIcons(null, this.showCount * 25, this.getSearchIconSessionId());
        if (!searchedIcons.isEmpty()) {
            input.add(searchedIcons);
            input.add(IconfinderViewer.MORE_ICON);
        }
        this.iconfinderViewer.setInput(input);
        this.searchResultPageForNone = new Composite(this.searchResultPageForResultSection, 0);
        this.searchResultPageForNone.setLayout((Layout)new GridLayout());
        this.searchResultPageForNone.setLayoutData((Object)new GridData(4, 4, true, true));
        Label unFoundLabel = new Label(this.searchResultPageForNone, 0);
        unFoundLabel.setImage((Image)this.localResourceManager.get((DeviceResourceDescriptor)IconfinderActivator.createImageDescriptor("/image/unfound.png")));
        unFoundLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000008, true, true));
        Label unFoundDescriptionLabel = new Label(this.searchResultPageForNone, 0);
        unFoundDescriptionLabel.setText(Messages.Iconfinder_UnFound_label);
        unFoundDescriptionLabel.setLayoutData((Object)new GridData(0x1000000, 1, true, true));
        unFoundDescriptionLabel.setForeground((Color)this.localResourceManager.get((DeviceResourceDescriptor)ColorDescriptor.createFrom((RGB)ColorUtils.toRGB((String)"#AAAAAA"))));
        this.searchResultPageForConnectError = new Composite(this.searchResultPageForResultSection, 0);
        this.searchResultPageForConnectError.setLayout((Layout)new GridLayout());
        this.searchResultPageForConnectError.setLayoutData((Object)new GridData(4, 4, true, true));
        Label errorImgLabel = new Label(this.searchResultPageForConnectError, 0);
        errorImgLabel.setImage((Image)this.localResourceManager.get((DeviceResourceDescriptor)IconfinderActivator.createImageDescriptor("/image/error.png")));
        errorImgLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000008, true, true));
        Label errorDescriptionLabel = new Label(this.searchResultPageForConnectError, 0);
        errorDescriptionLabel.setText("Sorry, something wrong when connecting \nto iconfinder server currently.");
        errorDescriptionLabel.setLayoutData((Object)new GridData(0x1000000, 1, true, true));
        errorDescriptionLabel.setForeground((Color)this.localResourceManager.get((DeviceResourceDescriptor)ColorDescriptor.createFrom((RGB)ColorUtils.toRGB((String)"#AAAAAA"))));
        searchResultStackLayout.topControl = this.loadingInfoForIcon ? this.loadingInfoForIconComposite : (searchedIcons.isEmpty() ? this.searchResultPageForNone : this.searchResultPageForMany);
        resultSectionStackLayout.topControl = this.everSearched ? this.searchResultPageForResultSection : this.defaultPageForResultSection;
    }

    private void handleIconOpenEvent(ISelection selection) {
        IStructuredSelection ss;
        Object element;
        if (selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof Icon) {
            Icon icon = (Icon)element;
            IconfinderCore.getInstance().downloadIconPreview(this.getSearchIconSessionId(), icon, true);
        }
    }

    public void insertImage(ISelection selection) {
        IGraphicalEditorPage page;
        IEditorPart editor;
        ArrayList<Icon> icons = new ArrayList<Icon>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Object[] objectArray = ss.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof Icon) {
                    icons.add((Icon)o);
                }
                ++n2;
            }
        }
        IconfinderCore.blockDowloadIconImage(icons.toArray(new Icon[icons.size()]), null);
        ArrayList<String> paths = new ArrayList<String>(icons.size());
        for (Icon icon : icons) {
            File image;
            VerifyUI20141031.getUsageDataCollector().increase("Iconfinder/Icon/UseCount");
            int iconId = icon.getIconId();
            File iconPreviewFile = IconfinderCore.getIconPreviewFile(this.getSearchIconSessionId(), iconId);
            if (!iconPreviewFile.exists()) {
                IconfinderCore.getInstance().downloadIconPreview(this.getSearchIconSessionId(), icon, true);
            }
            if (!(image = IconfinderCore.getIconFile(iconId)).exists()) continue;
            paths.add(image.getAbsolutePath());
        }
        if (!paths.isEmpty() && (editor = this.getAdapter(IWorkbenchWindow.class).getActivePage().getActiveEditor()) instanceof IGraphicalEditor && (page = ((IGraphicalEditor)editor).getActivePageInstance()) != null) {
            page.getEditDomain().handleRequest(new Request("add_image").setViewer((IViewer)page.getViewer()).setParameter("paths", (Object)paths.toArray(new String[paths.size()])));
        }
    }

    private void createFilterSection(Composite parent) {
        this.filterSection = new Composite(parent, 0);
        this.filterSection.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        StackLayout filterSectionStackLayout = new StackLayout();
        this.filterSection.setLayout((Layout)filterSectionStackLayout);
        this.pageForIconFilterSection = this.createPageForIconFilterSection(this.filterSection);
        this.pageForIconsetFilterSection = this.createPageForIconsetFilterSection(this.filterSection);
        filterSectionStackLayout.topControl = this.searchForIcon || this.setFilterInvisibleComposite.getVisible() ? this.pageForIconFilterSection : this.pageForIconsetFilterSection;
    }

    private Composite createPageForIconsetFilterSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        this.iconsetLabelOnFilterSection = new Label(composite, 0);
        this.iconsetLabelOnFilterSection.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        this.iconCountLabelOnFilterSection = new Label(composite, 0);
        this.iconCountLabelOnFilterSection.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        return composite;
    }

    private Composite createPageForIconFilterSection(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout(1, false));
        panel.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite = new Composite(panel, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 20;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        composite.setBackground(panel.getBackground());
        composite.setVisible(true);
        this.categoryCombo = new Composite(composite, 0);
        GridLayout categoryComboLayout = new GridLayout(2, false);
        categoryComboLayout.marginHeight = 0;
        categoryComboLayout.marginWidth = 0;
        categoryComboLayout.horizontalSpacing = 0;
        categoryComboLayout.marginLeft = 5;
        this.categoryCombo.setLayout((Layout)categoryComboLayout);
        GridData gridData = new GridData(1, 0x1000000, true, false);
        gridData.widthHint = 82;
        this.categoryCombo.setLayoutData((Object)gridData);
        this.categoryNameLabel = new Label(this.categoryCombo, 0);
        this.categoryNameLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.categoryNameLabel.setText("All");
        this.categoryIdentifier = "All";
        this.categoryNameLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                IconfinderModelPage.this.showCategoriesDialog((Control)IconfinderModelPage.this.categoryNameLabel);
            }
        });
        final Label categoryImageLabel = new Label(this.categoryCombo, 0);
        categoryImageLabel.setImage((Image)this.localResourceManager.get((DeviceResourceDescriptor)IconfinderActivator.createImageDescriptor(Icon_Dropdown_Image)));
        categoryImageLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        categoryImageLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                IconfinderModelPage.this.showCategoriesDialog((Control)categoryImageLabel);
            }
        });
        final Color origin = this.localResourceManager.createColor(new RGB(255, 255, 255));
        final Color selected = this.localResourceManager.createColor(new RGB(233, 232, 233));
        MouseTrackAdapter categoryListener = new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                IconfinderModelPage.this.categoryCombo.setBackground(origin);
            }

            public void mouseEnter(MouseEvent e) {
                IconfinderModelPage.this.categoryCombo.setBackground(selected);
            }
        };
        this.categoryNameLabel.addMouseTrackListener((MouseTrackListener)categoryListener);
        categoryImageLabel.addMouseTrackListener((MouseTrackListener)categoryListener);
        this.styleCombo = new Composite(composite, 0);
        GridLayout styleComboLayout = new GridLayout(2, false);
        styleComboLayout.marginWidth = 0;
        styleComboLayout.marginHeight = 0;
        styleComboLayout.horizontalSpacing = 0;
        styleComboLayout.marginLeft = 5;
        this.styleCombo.setLayout((Layout)styleComboLayout);
        GridData styleGridData = new GridData(1, 0x1000000, false, false);
        styleGridData.widthHint = 68;
        this.styleCombo.setLayoutData((Object)styleGridData);
        this.styleNameLabel = new Label(this.styleCombo, 0);
        this.styleNameLabel.setText("All");
        this.styleIdentifier = "All";
        this.styleNameLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.styleNameLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                IconfinderModelPage.this.showStylesDialog((Control)IconfinderModelPage.this.styleNameLabel);
            }
        });
        final Label styleImageLabel = new Label(this.styleCombo, 0);
        styleImageLabel.setImage((Image)this.localResourceManager.get((DeviceResourceDescriptor)IconfinderActivator.createImageDescriptor(Icon_Dropdown_Image)));
        styleImageLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        styleImageLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                IconfinderModelPage.this.showStylesDialog((Control)styleImageLabel);
            }
        });
        MouseTrackAdapter styleListener = new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                IconfinderModelPage.this.styleCombo.setBackground(origin);
            }

            public void mouseEnter(MouseEvent e) {
                IconfinderModelPage.this.styleCombo.setBackground(selected);
            }
        };
        this.styleNameLabel.addMouseTrackListener((MouseTrackListener)styleListener);
        styleImageLabel.addMouseTrackListener((MouseTrackListener)styleListener);
        this.sizeCombo = new Composite(composite, 0);
        GridLayout sizeComboLayout = new GridLayout(2, false);
        sizeComboLayout.marginWidth = 0;
        sizeComboLayout.marginHeight = 0;
        sizeComboLayout.horizontalSpacing = 0;
        sizeComboLayout.marginLeft = 5;
        this.sizeCombo.setLayout((Layout)sizeComboLayout);
        GridData sizeGridData = new GridData(1, 0x1000000, true, false);
        sizeGridData.widthHint = 50;
        this.sizeCombo.setLayoutData((Object)sizeGridData);
        final Label sizeNameLabel = new Label(this.sizeCombo, 0);
        sizeNameLabel.setText(String.valueOf(this.rasterSize) + Messages.IconfinderModelPage_Px_Label);
        sizeNameLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        sizeNameLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                IconfinderModelPage.this.showSizeDialog((Control)sizeNameLabel);
            }
        });
        Label sizeImageLabel = new Label(this.sizeCombo, 0);
        sizeImageLabel.setImage((Image)this.localResourceManager.get((DeviceResourceDescriptor)IconfinderActivator.createImageDescriptor(Icon_Dropdown_Image)));
        sizeImageLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        sizeImageLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                IconfinderModelPage.this.showSizeDialog((Control)sizeNameLabel);
            }
        });
        MouseTrackAdapter sizeListener = new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                IconfinderModelPage.this.sizeCombo.setBackground(origin);
            }

            public void mouseEnter(MouseEvent e) {
                IconfinderModelPage.this.sizeCombo.setBackground(selected);
            }
        };
        sizeNameLabel.addMouseTrackListener((MouseTrackListener)sizeListener);
        sizeImageLabel.addMouseTrackListener((MouseTrackListener)sizeListener);
        this.setFilterInvisibleComposite = new Composite(composite, 0);
        GridLayout stopIconLayout = new GridLayout();
        stopIconLayout.marginHeight = 0;
        stopIconLayout.marginWidth = 0;
        this.setFilterInvisibleComposite.setLayout((Layout)stopIconLayout);
        Label setInvisibleIcon = new Label(this.setFilterInvisibleComposite, 0);
        setInvisibleIcon.setImage((Image)this.localResourceManager.get((DeviceResourceDescriptor)IconfinderActivator.createImageDescriptor("/image/remove.png")));
        setInvisibleIcon.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                IconfinderModelPage.this.setFilterVisible(false);
            }
        });
        this.setFilterVisible(false);
        return panel;
    }

    private void createSearchSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createToolBarSection(composite);
        this.searchIconText = new Text(composite, 2436);
        this.searchIconText.setMessage(Messages.Iconfinder_SearchIconsText_message);
        GridData textGridData = new GridData(4, 0x1000000, true, false);
        this.searchIconText.setLayoutData((Object)textGridData);
        this.searchIconText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (SWTUtils.matchKey((int)e.stateMask, (int)e.keyCode, (int)0, (int)13)) {
                    IconfinderModelPage.this.searchContent = IconfinderModelPage.this.searchIconText.getText();
                    SearchIconSession currentSession = IconfinderModelPage.this.iconSessionManager.getCurrentSession();
                    if (currentSession != null && IconfinderModelPage.this.searchContent != null && IconfinderModelPage.this.searchContent.equals(currentSession.getKey()) && IconfinderModelPage.this.categoryIdentifier != null && IconfinderModelPage.this.categoryIdentifier.equals(currentSession.getCategory()) && IconfinderModelPage.this.styleIdentifier != null && IconfinderModelPage.this.styleIdentifier.equals(currentSession.getStyle())) {
                        return;
                    }
                    IconfinderModelPage.this.newSearch(IconfinderModelPage.this.searchContent);
                }
            }
        });
        Button searchButton = new Button(composite, 8);
        GridData buttonGridData = new GridData(1, 4, false, true);
        searchButton.setLayoutData((Object)buttonGridData);
        searchButton.setImage((Image)this.localResourceManager.get((DeviceResourceDescriptor)IconfinderActivator.createImageDescriptor(Icon_Search_Image)));
        searchButton.addSelectionListener(new SelectionListener(){

            public synchronized void widgetSelected(SelectionEvent e) {
                IconfinderModelPage.this.searchContent = IconfinderModelPage.this.searchIconText.getText();
                SearchIconSession currentSession = IconfinderModelPage.this.iconSessionManager.getCurrentSession();
                if (currentSession != null && IconfinderModelPage.this.searchContent != null && IconfinderModelPage.this.searchContent.equals(currentSession.getKey()) && IconfinderModelPage.this.categoryIdentifier != null && IconfinderModelPage.this.categoryIdentifier.equals(currentSession.getCategory()) && IconfinderModelPage.this.styleIdentifier != null && IconfinderModelPage.this.styleIdentifier.equals(currentSession.getStyle())) {
                    return;
                }
                IconfinderModelPage.this.newSearch(IconfinderModelPage.this.searchContent);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void showCategoriesDialog(final Control base) {
        List<Category> categories = IconfinderCore.getCategories();
        if (categories.size() <= 1) {
            IconfinderCore.getInstance().requestAllCategories(this.categoryAndStyleSessionId);
            LoadingDialog loadingDialog = new LoadingDialog(base.getShell(), this.categoryAndStyleSessionId){

                @Override
                protected void handleIconfinderEvent(IconfinderEvent event) {
                    if (event.getType() == 4 && base != null && !base.isDisposed()) {
                        base.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                this.close();
                                IconfinderModelPage.this.doShowCategoriesDialog(base, IconfinderCore.getCategories());
                            }
                        });
                    }
                }
            };
            loadingDialog.open(this.getItemBoundsToDisplay(base));
            return;
        }
        this.doShowCategoriesDialog(base, categories);
    }

    private void doShowCategoriesDialog(Control base, List<Category> categories) {
        ListDialog<Category> dialog = new ListDialog<Category>(base.getShell(), categories){

            @Override
            protected void configItem(Hyperlink item, final Category category) {
                item.setText(category.getNme());
                item.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        IconfinderModelPage.this.setCategory(category);
                        this.close();
                    }
                });
            }
        };
        dialog.open(this.getItemBoundsToDisplay(base));
    }

    private void setCategory(Category category) {
        this.categoryNameLabel.setText(IconfinderModelPage.specialFormatForLabel(category.getNme()));
        this.categoryIdentifier = category.getIdentifier();
        this.searchContent = this.searchIconText.getText();
        this.newSearch(this.searchContent);
    }

    public void showStylesDialog(final Control base) {
        List<Style> styles = IconfinderCore.getStyles();
        if (styles.size() <= 1) {
            IconfinderCore.getInstance().requestAllStyles(this.categoryAndStyleSessionId);
            LoadingDialog loadingDialog = new LoadingDialog(base.getShell(), this.categoryAndStyleSessionId){

                @Override
                protected void handleIconfinderEvent(IconfinderEvent event) {
                    if (event.getType() == 8 && base != null && !base.isDisposed()) {
                        base.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                this.close();
                                IconfinderModelPage.this.doShowStylesDialog(base, IconfinderCore.getStyles());
                            }
                        });
                    }
                }
            };
            loadingDialog.open(this.getItemBoundsToDisplay(base));
            return;
        }
        this.doShowStylesDialog(base, styles);
    }

    private void doShowStylesDialog(Control base, List<Style> styles) {
        ListDialog<Style> dialog = new ListDialog<Style>(base.getShell(), styles){

            @Override
            protected void configItem(Hyperlink item, final Style style) {
                item.setText(style.getName());
                item.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        IconfinderModelPage.this.setStyle(style);
                        this.close();
                    }
                });
            }
        };
        dialog.open(this.getItemBoundsToDisplay(base));
    }

    private void showSizeDialog(final Control base) {
        ArrayList<String> list = new ArrayList<String>();
        int[] nArray = IconfinderCore.ICON_SIZE_PRIORITY_ARRAY;
        int n = IconfinderCore.ICON_SIZE_PRIORITY_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            int size = nArray[n2];
            list.add(String.valueOf(size) + Messages.IconfinderModelPage_Px_Label);
            ++n2;
        }
        ListDialog<String> dialog = new ListDialog<String>(base.getShell(), list){

            @Override
            protected void configItem(final Hyperlink item, final String t) {
                item.setText(t);
                item.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        int oldSize = IconfinderModelPage.this.rasterSize;
                        try {
                            IconfinderModelPage.this.rasterSize = Integer.parseInt(t.substring(0, t.length() - 2));
                        }
                        catch (Exception exception) {
                            IconfinderModelPage.this.rasterSize = oldSize;
                            exception.printStackTrace();
                        }
                        if (base instanceof Label) {
                            ((Label)base).setText(item.getText());
                        }
                        this.close();
                    }
                });
            }
        };
        VerifyUI20141031.getUsageDataCollector().increase("IconfinderShowSizeDialogCount");
        dialog.open(this.getItemBoundsToDisplay(base));
    }

    private void setStyle(Style style) {
        this.styleNameLabel.setText(IconfinderModelPage.specialFormatForLabel(style.getName()));
        this.styleIdentifier = style.getIdentifier();
        this.searchContent = this.searchIconText.getText();
        this.newSearch(this.searchContent);
    }

    private Rectangle getItemBoundsToDisplay(Control item) {
        Rectangle bounds = item.getBounds();
        Point loc = item.getParent().toDisplay(bounds.x, bounds.y);
        bounds.x = loc.x;
        bounds.y = loc.y;
        return bounds;
    }

    public void newSearch(String queryContent) {
        if (this.iconSessionManager.isOnSearch()) {
            return;
        }
        this.iconSessionManager.setOnSearch(true);
        this.resetShowCount();
        this.searchIconText.setText(queryContent);
        int length = this.searchIconText.getText().length();
        this.searchIconText.setSelection(length, length);
        if (queryContent == null || queryContent.equals("")) {
            this.everSearched = false;
            this.searchForIcon = true;
            this.loadingInfoForIcon = false;
        } else {
            this.everSearched = true;
            this.loadingInfoForIcon = true;
            boolean searchIconSet = queryContent.startsWith("iconset:");
            this.searchForIcon = !searchIconSet;
            this.generateNewSearchIconSession();
            IconfinderCore.getInstance().addIconfinderListener(this.getSearchIconSessionId(), this.iconfinderListener);
            if (searchIconSet) {
                this.iconSessionManager.addSession(new SearchIconSession(this.searchIconSessionId, queryContent, true, this.categoryIdentifier, this.styleIdentifier));
                VerifyUI20141031.getUsageDataCollector().increase(String.format("Iconfinder/SearchCount/%s", "Iconset"));
                this.iconfinderViewer.setIconsetEntrance(false);
                this.searchContent = queryContent;
                this.iconsetLabelOnFilterSection.setVisible(false);
                this.iconCountLabelOnFilterSection.setVisible(false);
                queryContent = queryContent.substring(8);
                IconfinderCore.getInstance().requestIconsByIconset(queryContent, 0, 0, this.getSearchIconSessionId(), false);
            } else {
                this.iconSessionManager.addSession(new SearchIconSession(this.searchIconSessionId, queryContent, this.categoryIdentifier, this.styleIdentifier));
                VerifyUI20141031.getUsageDataCollector().increase(String.format("Iconfinder/SearchCount/%s", "Icon"));
                this.iconfinderViewer.setIconsetEntrance(true);
                String category = "All".equals(this.categoryIdentifier) ? null : this.categoryIdentifier;
                String style = "All".equals(this.styleIdentifier) ? null : this.styleIdentifier;
                int existedCount = (this.showCount - 1) * 25;
                IconfinderCore.getInstance().requestIcons(queryContent, category, style, existedCount, this.getSearchIconSessionId(), false);
            }
        }
        this.updateAll(null);
        this.iconSessionManager.setOnSearch(false);
    }

    @Override
    public void promoteToSearchIconset(String iconsetIdentifier) {
        this.iconfinderViewer.setIconsetEntrance(false);
        this.searchContent = "iconset:" + iconsetIdentifier;
        this.searchIconText.setText(this.searchContent);
        this.searchForIcon = false;
        this.everSearched = true;
        this.resetShowCount();
        File iconsetDetailsDir = IconfinderCore.getIconsetDetailsDirBasedOn(this.getSearchIconSessionId());
        File iconsetDetailFile = new File(iconsetDetailsDir, String.valueOf(iconsetIdentifier) + ".json");
        if (iconsetDetailFile.exists()) {
            this.loadingInfoForIcon = false;
            this.iconSessionManager.addSession(new SearchIconSession(this.getSearchIconSessionId(), this.searchContent, true, this.categoryIdentifier, this.styleIdentifier));
            Iconset iconset = new Iconset(IconfinderCore.readObject(iconsetDetailFile));
            this.updateAll(iconset);
        } else {
            this.newSearch(this.searchContent);
        }
    }

    @Override
    public boolean isLoading() {
        return this.loadingForMore;
    }

    @Override
    public void moreSearch() {
        ++this.showCount;
        this.everSearched = true;
        this.loadingInfoForIcon = false;
        this.loadingForMore = true;
        this.iconfinderViewer.update(new Object[]{IconfinderViewer.MORE_ICON});
        int existedCount = (this.showCount - 1) * 25;
        if (this.searchForIcon) {
            VerifyUI20141031.getUsageDataCollector().increase(String.format("Iconfinder/SearchCount/%s", "Icon"));
            this.iconfinderViewer.setIconsetEntrance(true);
            String category = "All".equals(this.categoryIdentifier) ? null : this.categoryIdentifier;
            String style = "All".equals(this.styleIdentifier) ? null : this.styleIdentifier;
            IconfinderCore.getInstance().requestIcons(this.searchContent, category, style, existedCount, this.getSearchIconSessionId(), false);
        } else {
            VerifyUI20141031.getUsageDataCollector().increase(String.format("Iconfinder/SearchCount/%s", "Iconset"));
            this.iconfinderViewer.setIconsetEntrance(false);
            String searchContent = this.searchContent;
            searchContent = searchContent.substring(8);
            List<Icon> icons = IconfinderCore.getIcons(searchContent, existedCount, this.getSearchIconSessionId());
            int after = icons.get(icons.size() - 1).getIconId();
            IconfinderCore.getInstance().requestIconsByIconset(searchContent, after, existedCount, this.getSearchIconSessionId(), false);
        }
        SearchIconSession currentSession = this.iconSessionManager.getCurrentSession();
        if (this.iconSessionManager != null) {
            currentSession.setShowCount(this.showCount);
        }
    }

    private void resetShowCount() {
        this.showCount = 1;
    }

    @Override
    public String getSearchIconSessionId() {
        return this.searchIconSessionId;
    }

    private void updateAll(Object source) {
        this.updateSearchIcons(source, this.getSearchIconSessionId());
        this.updateBackForwardItem();
    }

    public void setFocus() {
        if (this.searchIconText != null && !this.searchIconText.isDisposed()) {
            this.searchIconText.setFocus();
        }
    }

    private static String specialFormatForLabel(String origin) {
        char[] charArray = origin.toCharArray();
        char[] newCharArray = new char[charArray.length * 2];
        int i = 0;
        char[] cArray = charArray;
        int n = charArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            newCharArray[i++] = ch;
            if (ch == '&') {
                newCharArray[i++] = 38;
            }
            ++n2;
        }
        return new String(newCharArray);
    }

    private Composite createToolBarSection(Composite parent) {
        ToolBar backForwardBar = new ToolBar(parent, 0);
        backForwardBar.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.backwardItem = new ToolItem(backForwardBar, 0);
        this.backwardItem.setImage((Image)this.localResourceManager.get((DeviceResourceDescriptor)IconfinderActivator.createImageDescriptor(Icon_Back_Image)));
        this.backwardItem.setDisabledImage((Image)this.localResourceManager.get((DeviceResourceDescriptor)IconfinderActivator.createImageDescriptor(Icon_Back_Invalid_Image)));
        this.forwardItem = new ToolItem(backForwardBar, 0);
        this.forwardItem.setImage((Image)this.localResourceManager.get((DeviceResourceDescriptor)IconfinderActivator.createImageDescriptor(Icon_Forward_Image)));
        this.forwardItem.setDisabledImage((Image)this.localResourceManager.get((DeviceResourceDescriptor)IconfinderActivator.createImageDescriptor(Icon_Forward_Invalid_Image)));
        this.backwardItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SearchIconSession session = IconfinderModelPage.this.iconSessionManager.backward();
                IconfinderModelPage.this.restoreFromSession(session);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.forwardItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SearchIconSession session = IconfinderModelPage.this.iconSessionManager.forward();
                IconfinderModelPage.this.restoreFromSession(session);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.backwardItem.setEnabled(false);
        this.forwardItem.setEnabled(false);
        return backForwardBar;
    }

    private void restoreFromSession(SearchIconSession session) {
        this.searchIconSessionId = session.getId();
        this.searchContent = session.getKey();
        this.searchIconText.setText(this.searchContent);
        this.showCount = session.getShowCount();
        this.categoryIdentifier = session.getCategory();
        this.styleIdentifier = session.getStyle();
        this.categoryNameLabel.setText(IconfinderModelPage.specialFormatForLabel(IconfinderModelPage.getCategoryNameFromCategoryId(this.categoryIdentifier)));
        this.styleNameLabel.setText(IconfinderModelPage.specialFormatForLabel(IconfinderModelPage.getStyleNameFromStyleId(this.styleIdentifier)));
        this.iconfinderViewer.setIconsetEntrance(!session.isIconset());
        if (session.isIconset()) {
            File iconsetDetailsDir = IconfinderCore.getIconsetDetailsDirBasedOn(this.getSearchIconSessionId());
            File iconsetDetailFile = new File(iconsetDetailsDir, String.valueOf(this.searchContent.substring("iconset:".length())) + ".json");
            if (iconsetDetailFile.exists()) {
                this.loadingInfoForIcon = false;
                this.searchForIcon = false;
                Iconset iconset = new Iconset(IconfinderCore.readObject(iconsetDetailFile));
                this.updateAll(iconset);
            }
        } else {
            this.searchForIcon = true;
            this.updateAll(null);
        }
    }

    private static String getCategoryNameFromCategoryId(String categoryIdentifier) {
        List<Category> categories = IconfinderCore.getCategories();
        for (Category category : categories) {
            if (!categoryIdentifier.equals(category.getIdentifier())) continue;
            return category.getNme();
        }
        return "All";
    }

    private static String getStyleNameFromStyleId(String styleIdentifier) {
        List<Style> styles = IconfinderCore.getStyles();
        for (Style style : styles) {
            if (!styleIdentifier.equals(style.getIdentifier())) continue;
            return style.getName();
        }
        return "All";
    }

    private void updateSearchIcons(Object source, String searchIconSessionId) {
        int totalIconsSize;
        boolean enabled;
        if (!this.searchForIcon) {
            if (source instanceof Iconset) {
                String iconsetName = ((Iconset)source).getName();
                this.iconsetLabelOnFilterSection.setText(NLS.bind((String)Messages.Iconfinder_Iconset_With_Name, (Object)iconsetName));
                int iconsCount = ((Iconset)source).getIconsCount();
                this.iconCountLabelOnFilterSection.setText(NLS.bind((String)Messages.Iconfinder_Icons_With_Count, (Object)iconsCount));
                this.iconsetLabelOnFilterSection.setVisible(true);
                this.iconCountLabelOnFilterSection.setVisible(true);
            }
            this.pageForIconsetFilterSection.layout(true);
        }
        this.adjustCombosStyle(this.searchForIcon);
        StackLayout filterSectionStackLayout = (StackLayout)this.filterSection.getLayout();
        filterSectionStackLayout.topControl = this.searchForIcon || this.setFilterInvisibleComposite.getVisible() ? this.pageForIconFilterSection : this.pageForIconsetFilterSection;
        this.filterSection.layout(true);
        StackLayout resultSectionStackLayout = (StackLayout)this.resultSection.getLayout();
        resultSectionStackLayout.topControl = this.everSearched ? this.searchResultPageForResultSection : this.defaultPageForResultSection;
        String iconsetIdentifier = null;
        if (!this.searchForIcon) {
            iconsetIdentifier = this.searchContent.substring(8);
        }
        List<Icon> icons = IconfinderCore.getIcons(iconsetIdentifier, 25 * this.showCount, searchIconSessionId);
        StackLayout resultPageLayout = (StackLayout)this.searchResultPageForResultSection.getLayout();
        resultPageLayout.topControl = this.loadingInfoForIcon ? this.loadingInfoForIconComposite : (icons.isEmpty() ? (this.connectError ? this.searchResultPageForConnectError : this.searchResultPageForNone) : this.searchResultPageForMany);
        this.searchResultPageForResultSection.layout(true);
        if (this.connectError) {
            this.iconSessionManager.removeCurrentSession();
        }
        boolean bl = enabled = (totalIconsSize = IconfinderCore.getTotalIconsSize(iconsetIdentifier, searchIconSessionId)) > icons.size();
        if (this.iconfinderViewer != null) {
            ArrayList<Object> input = new ArrayList<Object>();
            if (!icons.isEmpty()) {
                input.addAll(icons);
                if (enabled) {
                    input.add(IconfinderViewer.MORE_ICON);
                }
            }
            this.iconfinderViewer.setInput(input);
            Viewport viewport = this.iconfinderViewer.getViewport();
            this.iconfinderViewer.scrollToY(viewport.getClientArea().y - viewport.getClientArea().height);
        }
        this.searchResultPageForMany.layout(true);
        this.resultSection.layout(true);
    }

    private void updateBackForwardItem() {
        if (!this.iconSessionManager.hasPrevious()) {
            this.backwardItem.setEnabled(false);
        } else if (!this.backwardItem.isEnabled()) {
            this.backwardItem.setEnabled(true);
        }
        if (!this.iconSessionManager.hasNext()) {
            this.forwardItem.setEnabled(false);
        } else if (!this.forwardItem.isEnabled()) {
            this.forwardItem.setEnabled(true);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(IconfinderViewer.class)) {
            return adapter.cast((Object)this.iconfinderViewer);
        }
        if (adapter.isAssignableFrom(ISelectionProvider.class)) {
            return adapter.cast((Object)this.iconfinderViewer);
        }
        return (T)super.getAdapter(adapter);
    }

    private void generateNewSearchIconSession() {
        this.searchIconSessionId = UUID.randomUUID().toString();
    }

    void cancelSearch() {
        this.iconSessionManager.setOnSearch(false);
    }

    public void setFilterVisible(boolean visible) {
        this.categoryCombo.setVisible(visible);
        this.styleCombo.setVisible(visible);
        this.sizeCombo.setVisible(visible);
        this.setFilterInvisibleComposite.setVisible(visible);
        if (visible && ((StackLayout)this.filterSection.getLayout()).topControl != this.pageForIconFilterSection) {
            ((StackLayout)this.filterSection.getLayout()).topControl = this.pageForIconFilterSection;
            this.filterSection.layout(true);
        } else if (!this.categoryCombo.isEnabled() && !this.styleCombo.isEnabled() && ((StackLayout)this.filterSection.getLayout()).topControl != this.pageForIconsetFilterSection) {
            ((StackLayout)this.filterSection.getLayout()).topControl = this.pageForIconsetFilterSection;
            this.filterSection.layout(true);
        }
    }

    int getRasterSize() {
        return this.rasterSize;
    }

    private void adjustCombosStyle(boolean searchForIcon) {
        if (searchForIcon) {
            this.categoryCombo.setEnabled(true);
            this.styleCombo.setEnabled(true);
            Color white = this.localResourceManager.createColor(new RGB(255, 255, 255));
            Color black = this.localResourceManager.createColor(new RGB(0, 0, 0));
            this.categoryCombo.setBackground(white);
            this.categoryNameLabel.setForeground(black);
            this.styleCombo.setBackground(white);
            this.styleNameLabel.setForeground(black);
        } else {
            this.categoryCombo.setEnabled(false);
            this.styleCombo.setEnabled(false);
            Color grey = this.localResourceManager.createColor(new RGB(233, 232, 233));
            Color deepGrey = this.localResourceManager.createColor(new RGB(128, 128, 128));
            this.categoryCombo.setBackground(grey);
            this.categoryNameLabel.setForeground(deepGrey);
            this.styleCombo.setBackground(grey);
            this.styleNameLabel.setForeground(deepGrey);
        }
    }
}

