/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.jface.action.IAction;
import org.xmind.core.ISettingEntry;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.gef.IDecorator;
import org.xmind.gef.IViewer;
import org.xmind.gef.part.IPart;
import org.xmind.gef.ui.actions.ActionRegistry;
import org.xmind.gef.ui.actions.IActionRegistry;
import org.xmind.ui.internal.InfoItemContributorManager;
import org.xmind.ui.internal.decorators.InformationDecorator;
import org.xmind.ui.internal.figures.InformationFigure;
import org.xmind.ui.internal.layouts.InformationLayout;
import org.xmind.ui.internal.mindmap.BranchPart;
import org.xmind.ui.internal.mindmap.ChildSorter;
import org.xmind.ui.internal.mindmap.InfoItemContent;
import org.xmind.ui.internal.mindmap.InfoItemContentPart;
import org.xmind.ui.internal.mindmap.InfoItemIcon;
import org.xmind.ui.internal.mindmap.MindMapPartBase;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IInfoItemContributor;
import org.xmind.ui.mindmap.IInfoItemPart;
import org.xmind.ui.mindmap.IInfoPart;
import org.xmind.ui.mindmap.ITopicPart;

public class InfoPart
extends MindMapPartBase
implements IInfoPart {
    private List<IInfoItemPart> infoItemIcons = null;
    private List<InfoItemContentPart> infoItemContents = null;
    private IActionRegistry actionRegistry = null;
    private List<IAction> actionList = null;
    private ChildSorter sorter = new ChildSorter((IPart)this);

    public InfoPart() {
        this.setDecorator((IDecorator)InformationDecorator.getInstance());
    }

    protected IFigure createFigure() {
        return new InformationFigure();
    }

    @Override
    public List<IInfoItemPart> getInfoItemIcons() {
        if (this.infoItemIcons == null) {
            this.infoItemIcons = new ArrayList<IInfoItemPart>();
        }
        return this.infoItemIcons;
    }

    public void addInfoItemIcon(IInfoItemPart infoItem) {
        this.getInfoItemIcons().add(infoItem);
        this.sorter.sort(this.getInfoItemIcons());
    }

    public void removeInfoItemIcon(IInfoItemPart infoItem) {
        this.getInfoItemIcons().remove(infoItem);
        this.sorter.sort(this.getInfoItemIcons());
    }

    @Override
    public List<InfoItemContentPart> getInfoItemContents() {
        if (this.infoItemContents == null) {
            this.infoItemContents = new ArrayList<InfoItemContentPart>();
        }
        return this.infoItemContents;
    }

    public void addInfoItemContent(InfoItemContentPart infoItem) {
        this.getInfoItemContents().add(infoItem);
        this.sorter.sort(this.getInfoItemContents());
    }

    public void removeInfoItemContent(InfoItemContentPart infoItem) {
        this.getInfoItemContents().remove(infoItem);
        this.sorter.sort(this.getInfoItemContents());
    }

    @Override
    public IBranchPart getOwnedBranch() {
        if (this.getParent() instanceof IBranchPart) {
            return (IBranchPart)this.getParent();
        }
        return null;
    }

    @Override
    public ITopic getTopic() {
        return (ITopic)super.getRealModel();
    }

    @Override
    public ITopicPart getTopicPart() {
        if (this.getParent() instanceof BranchPart) {
            return ((BranchPart)this.getParent()).getTopicPart();
        }
        return null;
    }

    public boolean hasActions() {
        return this.actionList != null && !this.actionList.isEmpty();
    }

    public void setParent(IPart parent) {
        BranchPart branch;
        if (this.getParent() instanceof BranchPart && (branch = (BranchPart)this.getParent()).getInfoPart() == this) {
            branch.setinfoPart(null);
        }
        super.setParent(parent);
        if (this.getParent() instanceof BranchPart) {
            branch = (BranchPart)this.getParent();
            branch.setinfoPart(this);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ITopic.class)) {
            return this.getTopic();
        }
        if (adapter == IActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (adapter == InfoItemIcon.class) {
            return null;
        }
        return super.getAdapter(adapter);
    }

    private IActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
            IViewer viewer = this.getSite().getViewer();
            if (viewer != null) {
                this.actionRegistry.setParent((IActionRegistry)viewer.getProperties().get("actions"));
            }
        }
        return this.actionRegistry;
    }

    protected LayoutManager createLayoutManager() {
        return new InformationLayout(this);
    }

    protected Object[] getModelChildren(Object model) {
        ArrayList<Object> list = new ArrayList<Object>();
        ITopic topic = this.getTopic();
        this.addinfoItem(topic, list);
        return list.toArray();
    }

    private void addinfoItem(ITopic topic, List<Object> list) {
        List<IInfoItemContributor> contributors;
        if (this.actionList != null && !this.actionList.isEmpty()) {
            this.actionList.clear();
        }
        if ((contributors = InfoItemContributorManager.getInstance().getBothContributors()).isEmpty()) {
            return;
        }
        ISheet sheet = topic.getOwnedSheet();
        if (sheet != null) {
            for (IInfoItemContributor c : contributors) {
                IAction action;
                if (!c.isCardModeAvailable(topic, this.getTopicPart())) continue;
                String infoItemMode = null;
                String type = c.getId();
                if (type != null && !"".equals(type)) {
                    List entries = sheet.getSettings().getEntries("info-items/info-item");
                    for (ISettingEntry entry : entries) {
                        String t = entry.getAttribute("type");
                        if (!type.equals(t)) continue;
                        infoItemMode = entry.getAttribute("mode");
                    }
                }
                if (infoItemMode == null || "".equals(infoItemMode)) {
                    infoItemMode = c.getDefaultMode();
                }
                if (!"card".equals(infoItemMode) || (action = c.createAction(this.getTopicPart(), topic)) == null) continue;
                if (this.actionList == null) {
                    this.actionList = new ArrayList<IAction>();
                }
                this.actionList.add(action);
                list.add(new InfoItemIcon(topic, c, action));
                list.add(new InfoItemContent(topic, c, c.getContent(topic)));
            }
        }
    }

    @Override
    protected void registerCoreEvents(Object source, ICoreEventRegister register) {
        super.registerCoreEvents(source, register);
        register.register("labels");
    }

    @Override
    public void handleCoreEvent(CoreEvent event) {
        String type = event.getType();
        if ("labels".equals(type)) {
            this.runInUI(new Runnable(){

                @Override
                public void run() {
                    InfoPart.this.update();
                }
            });
        } else {
            super.handleCoreEvent(event);
        }
    }

    public void refresh() {
        super.refresh();
        for (InfoItemContentPart infoItemContentPart : this.getInfoItemContents()) {
            infoItemContentPart.refresh();
        }
        for (IInfoItemPart iInfoItemPart : this.getInfoItemIcons()) {
            iInfoItemPart.refresh();
        }
    }

    public void update() {
        super.update();
        for (InfoItemContentPart infoItemContentPart : this.getInfoItemContents()) {
            infoItemContentPart.update();
        }
        for (IInfoItemPart iInfoItemPart : this.getInfoItemIcons()) {
            iInfoItemPart.update();
        }
        IFigure iFigure = this.getFigure();
        if (iFigure != null) {
            iFigure.revalidate();
            iFigure.repaint();
        }
    }

    @Override
    protected void onActivated() {
        super.onActivated();
        for (IInfoItemContributor infoItemCont : InfoItemContributorManager.getInstance().getBothContributors()) {
            infoItemCont.topicActivated(this);
        }
    }

    @Override
    protected void onDeactivated() {
        for (IInfoItemContributor infoItemCont : InfoItemContributorManager.getInstance().getBothContributors()) {
            infoItemCont.topicDeactivated(this);
        }
        super.onDeactivated();
    }

    protected void reorderChild(IPart child, int index) {
        super.reorderChild(child, index);
        if (this.getInfoItemContents().contains(child)) {
            this.sorter.sort(this.getInfoItemContents());
        }
        if (this.getInfoItemIcons().contains(child)) {
            this.sorter.sort(this.getInfoItemIcons());
        }
        this.update();
    }
}

