/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.svgsupport;

import org.eclipse.swt.graphics.RGB;
import org.xmind.ui.internal.svgsupport.LinearGradient;

class SVGColor {
    private LinearGradient linearGradient;
    private RGB rgb;

    public SVGColor(int rgb) {
        this.setRGB(rgb);
    }

    public SVGColor(LinearGradient linearGradient) {
        this.setLinearGradient(linearGradient);
    }

    private void setRGB(int rgb) {
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        this.rgb = new RGB(red, green, blue);
    }

    RGB getRGB() {
        return this.rgb;
    }

    LinearGradient getLinearGradient() {
        return this.linearGradient;
    }

    private void setLinearGradient(LinearGradient linearGradient) {
        this.linearGradient = linearGradient;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SVGColor) {
            SVGColor color = (SVGColor)obj;
            if (this.rgb != null) {
                return this.rgb.equals((Object)color.rgb);
            }
            return this.linearGradient.equals(color.linearGradient);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        if (this.rgb != null) {
            result = result * 31 + this.rgb.hashCode();
        } else if (this.linearGradient != null) {
            result = result * 31 + this.linearGradient.hashCode();
        }
        return result;
    }

    public String toString() {
        if (this.rgb != null) {
            return this.rgb.toString();
        }
        if (this.linearGradient != null) {
            return this.linearGradient.toString();
        }
        return "none";
    }
}

