/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt.export;

import java.util.Calendar;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.xmind.ui.datepicker.DatePicker2;
import org.xmind.ui.datepicker.DateSelection;
import org.xmind.ui.internal.taskinfo.DateInfo;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;
import org.xmind.ui.internal.taskinfo.TaskMessages;

public class DateInfoPickerViewer2
extends Viewer {
    private Composite composite;
    private DatePicker2 datePicker;
    private DateInfo selection;
    private boolean firingSelectionChange = false;
    private boolean refreshingDate = false;

    public DateInfoPickerViewer2(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.composite.setLayout((Layout)gridLayout);
        this.composite.setBackground(parent.getDisplay().getSystemColor(1));
        this.createContents(this.composite);
        this.refresh();
    }

    private void createContents(Composite parent) {
        this.createDatePicker(parent);
    }

    private void createDatePicker(Composite parent) {
        this.datePicker = new DatePicker2(parent, 4);
        this.datePicker.getControl().setLayoutData((Object)new GridData(1808));
        this.datePicker.setBackground(parent.getBackground());
        this.datePicker.setLabelProvider((ILabelProvider)new DateLabelProvider());
        this.datePicker.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (DateInfoPickerViewer2.this.refreshingDate) {
                    return;
                }
                DateInfoPickerViewer2.this.changeDate(((DateSelection)event.getSelection()).getDate());
            }
        });
    }

    public Control getControl() {
        return this.composite;
    }

    public Object getInput() {
        return null;
    }

    public ISelection getSelection() {
        return this.selection == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)this.selection);
    }

    public Calendar getSelectedDate() {
        if (this.selection != null) {
            Calendar selectedDate = Calendar.getInstance();
            selectedDate.setTimeInMillis(this.selection.date.getTimeInMillis());
            return selectedDate;
        }
        return null;
    }

    public DatePicker2 getDatePicker() {
        return this.datePicker;
    }

    public void refresh() {
        boolean hasDate = this.selection != null;
        this.composite.setRedraw(false);
        this.refreshDatePicker(hasDate);
        this.composite.layout();
        this.composite.setRedraw(true);
    }

    private void refreshDatePicker(boolean hasDate) {
        this.refreshingDate = true;
        this.datePicker.setSelection((ISelection)new DateSelection(hasDate ? this.selection.date : null));
        this.refreshingDate = false;
    }

    public void setInput(Object input) {
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (selection == null || selection.isEmpty()) {
            this.changeSelection(null);
        } else if (selection instanceof IStructuredSelection) {
            this.changeSelection((DateInfo)((IStructuredSelection)selection).getFirstElement());
        }
    }

    private void changeSelection(DateInfo selection) {
        this.selection = selection;
        this.refresh();
        if (this.firingSelectionChange) {
            return;
        }
        this.firingSelectionChange = true;
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        this.firingSelectionChange = false;
    }

    private void changeDate(Calendar date) {
        DateInfo dateInfo = date == null ? null : new DateInfo(date, false);
        this.changeSelection(dateInfo);
    }

    public void setEnabled(boolean enabled) {
        this.datePicker.setEnabled(enabled);
    }

    public void openDatePicker() {
        this.datePicker.open();
    }

    public void setMinTime(Calendar minTime) {
        if (this.datePicker != null) {
            this.datePicker.setMinTime(minTime);
        }
    }

    public void setMaxTime(Calendar maxTime) {
        if (this.datePicker != null) {
            this.datePicker.setMaxTime(maxTime);
        }
    }

    public Calendar getMinTime() {
        return this.datePicker == null ? null : this.datePicker.getMinTime();
    }

    public Calendar getMaxTime() {
        return this.datePicker == null ? null : this.datePicker.getMaxTime();
    }

    private static class DateLabelProvider
    extends LabelProvider {
        private DateLabelProvider() {
        }

        public String getText(Object element) {
            if (element == null || !(element instanceof Calendar)) {
                return TaskMessages.SelectTime_text;
            }
            return TaskInfoUtils.formatDate((Calendar)((Calendar)element));
        }
    }
}

