/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.fishbone.decorations;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.IRotatableReferencedFigure;
import org.xmind.gef.draw2d.geometry.PrecisionLine;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionPointList;
import org.xmind.gef.draw2d.geometry.PrecisionPolygon;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.draw2d.geometry.PrecisionRotator;
import org.xmind.gef.draw2d.graphics.GradientPattern;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.decorations.AbstractTopicDecoration;
import org.xmind.ui.resources.ColorUtils;

public class FishboneTopicDecoration
extends AbstractTopicDecoration {
    private static final Point CENTER = new Point(0, 0);
    private PrecisionRotator rotator = null;
    private PrecisionPolygon points = null;

    protected PrecisionRotator r() {
        if (this.rotator == null) {
            this.rotator = new PrecisionRotator();
        }
        return this.rotator;
    }

    public void invalidate() {
        this.points = null;
        super.invalidate();
    }

    public void validate(IFigure figure) {
        if (this.points == null) {
            this.points = this.calcPoints(figure);
        }
        super.validate(figure);
    }

    private PrecisionPolygon calcPoints(IFigure figure) {
        PrecisionPolygon polygon = new PrecisionPolygon(4);
        IRotatableReferencedFigure rf = (IRotatableReferencedFigure)figure;
        this.r().setAngle(rf.getRotationDegrees());
        this.r().setOrigin((double)FishboneTopicDecoration.CENTER.x, (double)FishboneTopicDecoration.CENTER.y);
        PrecisionRectangle bounds = rf.getNormalPreferredBounds(CENTER).getExpanded((double)(-this.getLineWidth()), (double)(-this.getLineWidth()));
        polygon.setPoint(this.r().tp(bounds.getTopLeft()), 0);
        polygon.setPoint(this.r().tp(bounds.getTopRight()), 1);
        polygon.setPoint(this.r().tp(bounds.getBottomRight()), 2);
        polygon.setPoint(this.r().tp(bounds.getBottomLeft()), 3);
        return polygon;
    }

    protected void sketch(IFigure figure, Path shape, Rectangle box, int purpose) {
        double cx = (double)box.x + (double)box.width * 0.5;
        double cy = (double)box.y + (double)box.height * 0.5;
        if (this.points == null) {
            this.points = this.calcPoints(figure);
        }
        PrecisionPoint p = this.points.getPoint(0);
        shape.moveTo((float)(cx + p.x), (float)(cy + p.y));
        int i = 1;
        while (i < 4) {
            this.lineTo(shape, cx, cy, this.points.getPoint(i));
            ++i;
        }
        shape.close();
    }

    private void lineTo(Path shape, double cx, double cy, PrecisionPoint p) {
        shape.lineTo((float)(cx + p.x), (float)(cy + p.y));
    }

    protected Pattern createGradientPattern(IFigure figure, int alpha, Color bgColor) {
        return super.createGradientPattern(figure, alpha, bgColor);
    }

    protected Pattern createObliquePattern(IFigure figure, int alpha, Color color) {
        Rectangle b = figure.getBounds();
        double cx = (double)b.x + (double)b.width * 0.5;
        double cy = (double)b.y + (double)b.height * 0.5;
        PrecisionPoint p1 = this.points.getPoint(0);
        PrecisionPoint p2 = this.points.getPoint(3);
        GradientPattern p = new GradientPattern((Device)Display.getCurrent(), (float)(cx + p1.x), (float)(cy + p1.y), (float)(cx + p2.x), (float)(cy + p2.y), ColorUtils.gradientLighter((Color)color), alpha, color, alpha);
        return p;
    }

    protected void paintOutline(IFigure figure, Graphics graphics) {
    }

    protected PrecisionPoint getEast(IFigure figure, double expansion) {
        PrecisionPoint center = new PrecisionPoint(figure.getBounds().getCenter());
        return center.translate(this.points.getPoint(2));
    }

    protected PrecisionPoint getWest(IFigure figure, double expansion) {
        PrecisionPoint center = new PrecisionPoint(figure.getBounds().getCenter());
        return center.translate(this.points.getPoint(3));
    }

    protected PrecisionPoint getNorth(IFigure figure, double expansion) {
        PrecisionPoint center = new PrecisionPoint(figure.getBounds().getCenter());
        return center.translate(this.points.getPoint(0).getCenter(this.points.getPoint(1)));
    }

    protected PrecisionPoint getSouth(IFigure figure, double expansion) {
        PrecisionPoint center = new PrecisionPoint(figure.getBounds().getCenter());
        return center.translate(this.points.getPoint(3).getCenter(this.points.getPoint(2)));
    }

    public PrecisionPoint getAnchorLocation(IFigure figure, double refX, double refY, double expansion) {
        this.checkValidation(figure);
        Rectangle r = figure.getBounds();
        double cx = (double)r.x + (double)r.width * 0.5;
        double cy = (double)r.y + (double)r.height * 0.5;
        PrecisionLine ray = new PrecisionLine(cx, cy, refX, refY, PrecisionLine.LineType.Ray);
        PrecisionPolygon polygon = this.points.getCopy();
        polygon.translate(cx, cy);
        PrecisionPointList result = polygon.intersect(ray, 1.0E-6);
        if (result.isEmpty()) {
            return polygon.getPoint(0);
        }
        return result.getPoint(0);
    }
}

