/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.GEF;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.ui.internal.presentation.slide.PresentationSlide;
import org.xmind.ui.internal.presentation.slide.SlideBoundsCalculator;
import org.xmind.ui.internal.presentation.slide.SlideFilter;
import org.xmind.ui.mindmap.MindMapViewerExportSourceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresentationExportSourceProvider
extends MindMapViewerExportSourceProvider {
    private SlideFilter slideFilter;
    private SlideBoundsCalculator boundsCalculator;
    private PresentationSlide slide;

    public PresentationExportSourceProvider(IGraphicalViewer viewer, PresentationSlide slide) {
        super(viewer);
        this.slideFilter = new SlideFilter(viewer);
        this.boundsCalculator = new SlideBoundsCalculator(this.getViewer());
        this.slide = slide;
    }

    protected IFigure getContentsFigure() {
        return null;
    }

    private void fillBackgroundLayer() {
        int height;
        int width;
        Layer figure = this.getViewer().getLayer(GEF.LAYER_BACKGROUND);
        Rectangle bounds = figure.getBounds();
        if (bounds.width >= bounds.height) {
            height = width = bounds.width * 3;
        } else {
            width = height = bounds.height * 3;
        }
        bounds.x -= (width - bounds.width) / 2;
        bounds.y -= (height - bounds.height) / 2;
        bounds.width = width;
        bounds.height = height;
    }

    protected void collectContentsForCalculatingSourceArea(List<IFigure> figures) {
        super.collectContentsForCalculatingSourceArea(figures);
        this.slideFilter.show(this.slide);
        LightweightSystem lws = (LightweightSystem)this.getViewer().getAdapter(LightweightSystem.class);
        if (lws != null) {
            lws.getUpdateManager().performValidation();
        }
        this.fillBackgroundLayer();
    }

    protected Rectangle calculateSourceArea(IFigure[] contents) {
        Rectangle bounds = this.boundsCalculator.getSlideBounds(this.slide);
        return bounds != null ? bounds : super.calculateSourceArea(contents);
    }
}

