/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.IndexedCache;
import org.gradle.cache.IndexedCacheParameters;
import org.gradle.cache.LockOptions;
import org.gradle.cache.internal.CacheCleanupExecutor;
import org.gradle.cache.internal.CacheInitializationAction;
import org.gradle.cache.internal.DefaultCacheCoordinator;
import org.gradle.cache.internal.DefaultCleanupProgressMonitor;
import org.gradle.cache.internal.ReferencablePersistentCache;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.util.internal.GFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPersistentDirectoryStore
implements ReferencablePersistentCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPersistentDirectoryStore.class);
    public static final int CLEANUP_INTERVAL_IN_HOURS = 24;
    private final File dir;
    private final LockOptions lockOptions;
    @Nullable
    private final CacheCleanupStrategy cacheCleanupStrategy;
    private final FileLockManager lockManager;
    private final ExecutorFactory executorFactory;
    private final String displayName;
    protected final File propertiesFile;
    private final File gcFile;
    private final ProgressLoggerFactory progressLoggerFactory;
    private DefaultCacheCoordinator cacheAccess;

    public DefaultPersistentDirectoryStore(File dir, @Nullable String displayName, LockOptions lockOptions, @Nullable CacheCleanupStrategy cacheCleanupStrategy, FileLockManager fileLockManager, ExecutorFactory executorFactory, ProgressLoggerFactory progressLoggerFactory) {
        this.dir = dir;
        this.lockOptions = lockOptions;
        this.cacheCleanupStrategy = cacheCleanupStrategy;
        this.lockManager = fileLockManager;
        this.executorFactory = executorFactory;
        this.propertiesFile = new File(dir, "cache.properties");
        this.gcFile = new File(dir, "gc.properties");
        this.progressLoggerFactory = progressLoggerFactory;
        this.displayName = displayName != null ? displayName + " (" + dir + ")" : "cache directory " + dir.getName() + " (" + dir + ")";
    }

    @Override
    public DefaultPersistentDirectoryStore open() {
        GFileUtils.mkdirs((File)this.dir);
        this.cacheAccess = this.createCacheAccess();
        try {
            this.cacheAccess.open();
        }
        catch (Throwable e) {
            throw new CacheOpenException(String.format("Could not open %s.", this), e);
        }
        return this;
    }

    private DefaultCacheCoordinator createCacheAccess() {
        return new DefaultCacheCoordinator(this.displayName, this.getLockTarget(), this.lockOptions, this.dir, this.lockManager, this.getInitAction(), this.getCleanupExecutor(), this.executorFactory);
    }

    private File getLockTarget() {
        return this.dir;
    }

    protected CacheInitializationAction getInitAction() {
        return CacheInitializationAction.NO_INIT_REQUIRED;
    }

    protected CacheCleanupExecutor getCleanupExecutor() {
        return new CleanupExecutor();
    }

    @Override
    public void close() {
        if (this.cacheAccess != null) {
            try {
                this.cacheAccess.close();
            }
            finally {
                this.cacheAccess = null;
            }
        }
    }

    @Override
    public File getBaseDir() {
        return this.dir;
    }

    @Override
    public Collection<File> getReservedCacheFiles() {
        return Arrays.asList(this.propertiesFile, this.gcFile, DefaultPersistentDirectoryStore.determineLockTargetFile(this.getLockTarget()));
    }

    static File determineLockTargetFile(File target) {
        return new File(target, target.getName() + ".lock");
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public <K, V> IndexedCache<K, V> createIndexedCache(IndexedCacheParameters<K, V> parameters) {
        return this.cacheAccess.newCache((IndexedCacheParameters)parameters);
    }

    @Override
    public <K, V> IndexedCache<K, V> createIndexedCache(String name, Class<K> keyType, Serializer<V> valueSerializer) {
        return this.cacheAccess.newCache((IndexedCacheParameters)IndexedCacheParameters.of(name, keyType, valueSerializer));
    }

    @Override
    public <K, V> boolean indexedCacheExists(IndexedCacheParameters<K, V> parameters) {
        return this.cacheAccess.cacheExists(parameters);
    }

    @Override
    public <T> T withFileLock(Factory<? extends T> action) {
        return this.cacheAccess.withFileLock(action);
    }

    @Override
    public void withFileLock(Runnable action) {
        this.cacheAccess.withFileLock(action);
    }

    @Override
    public <T> T useCache(Factory<? extends T> action) {
        return this.cacheAccess.useCache(action);
    }

    @Override
    public void useCache(Runnable action) {
        this.cacheAccess.useCache(action);
    }

    @Override
    public void cleanup() {
        this.cacheAccess.cleanup();
    }

    private class CleanupExecutor
    implements CacheCleanupExecutor {
        private CleanupExecutor() {
        }

        private boolean requiresCleanup() {
            if (DefaultPersistentDirectoryStore.this.dir.exists() && DefaultPersistentDirectoryStore.this.cacheCleanupStrategy != null) {
                if (!DefaultPersistentDirectoryStore.this.gcFile.exists()) {
                    GFileUtils.touch((File)DefaultPersistentDirectoryStore.this.gcFile);
                } else {
                    long duration = System.currentTimeMillis() - DefaultPersistentDirectoryStore.this.gcFile.lastModified();
                    long timeInHours = TimeUnit.MILLISECONDS.toHours(duration);
                    LOGGER.debug("{} has last been fully cleaned up {} hours ago", (Object)DefaultPersistentDirectoryStore.this, (Object)timeInHours);
                    return DefaultPersistentDirectoryStore.this.cacheCleanupStrategy.getCleanupFrequency().requiresCleanup(DefaultPersistentDirectoryStore.this.gcFile.lastModified());
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cleanup() {
            if (DefaultPersistentDirectoryStore.this.cacheCleanupStrategy != null && this.requiresCleanup()) {
                String description = "Cleaning " + DefaultPersistentDirectoryStore.this.getDisplayName();
                ProgressLogger progressLogger = DefaultPersistentDirectoryStore.this.progressLoggerFactory.newOperation(CacheCleanupExecutor.class).start(description, description);
                Timer timer = Time.startTimer();
                try {
                    DefaultPersistentDirectoryStore.this.cacheCleanupStrategy.getCleanupAction().clean(DefaultPersistentDirectoryStore.this, new DefaultCleanupProgressMonitor(progressLogger));
                    GFileUtils.touch((File)DefaultPersistentDirectoryStore.this.gcFile);
                }
                finally {
                    LOGGER.info("{} cleaned up in {}.", (Object)DefaultPersistentDirectoryStore.this, (Object)timer.getElapsed());
                    progressLogger.completed();
                }
            }
        }
    }
}

