/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.config;

import amazon.fws.clicommando.config.DefaultConfig;
import amazon.fws.clicommando.config.EnvironmentVariableConfig;
import amazon.fws.clicommando.config.MapConfig;
import amazon.fws.clicommando.config.OptionConfig;
import amazon.fws.clicommando.config.ValueReferenceConfig;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParamConfig {
    public static final int DEF_MAX_VALUE_SIZE = 2048000;
    private String name;
    private String sameAs;
    private Type type;
    private String value;
    private String helpDescription;
    Collection<String> values;
    private Character delimeter = null;
    private Boolean isRequired;
    private Boolean isDirective;
    private List<Map<String, String>> valuesMap;
    private String contextTitle;
    private boolean secureInput;
    private int maxValueSize;
    private String prompt;
    private boolean isUndocumented;
    private ValueReferenceConfig valueReferenceConfig;
    private EnvironmentVariableConfig envVarValue;
    private DefaultConfig defaultValue;
    private List<OptionConfig> options;
    private MapConfig mapConfig;
    private InputMode inputMode = InputMode.NONE;
    public static final Comparator<ParamConfig> NAME_COMPARE = new Comparator<ParamConfig>(){

        @Override
        public int compare(ParamConfig e1, ParamConfig e2) {
            return e1.getName().compareTo(e2.getName());
        }
    };
    public static final Comparator<ParamConfig> OPTION_COMPARE = new Comparator<ParamConfig>(){

        @Override
        public int compare(ParamConfig e1, ParamConfig e2) {
            return e1.getFirstOptionString().toLowerCase().compareTo(e2.getFirstOptionString().toLowerCase());
        }
    };
    public static final Comparator<ParamConfig> REQUIRED_AND_NAME_COMPARE = new Comparator<ParamConfig>(){

        @Override
        public int compare(ParamConfig e1, ParamConfig e2) {
            int retComp = 0;
            retComp = e1.isRequired().equals(e2.isRequired()) ? e1.getName().compareTo(e2.getName()) : (e1.isRequired() != false ? -1 : 1);
            return retComp;
        }
    };

    public ParamConfig(String name, String sameAs, String type, boolean required, boolean isDirective, String contextTitle, boolean secureInput, int maxValueSize, String prompt, boolean undocumented) {
        this.name = name;
        this.sameAs = sameAs;
        this.type = Type.parse(type);
        this.isRequired = required;
        this.options = new ArrayList<OptionConfig>();
        this.value = "";
        this.values = new ArrayList<String>();
        this.isDirective = isDirective;
        this.valuesMap = new ArrayList<Map<String, String>>();
        this.mapConfig = new MapConfig();
        this.secureInput = secureInput;
        this.maxValueSize = maxValueSize;
        this.prompt = prompt;
        this.valueReferenceConfig = new ValueReferenceConfig();
        this.contextTitle = StringUtils.isEmpty(contextTitle) ? "SPECIFIC OPTIONS" : contextTitle;
        this.isUndocumented = undocumented;
    }

    public ParamConfig(String name, String type, boolean required) {
        this(name, null, type, required, false, "", false, 2048000, "", false);
    }

    public boolean isUndocumented() {
        return this.isUndocumented;
    }

    public String getContextTitle() {
        return this.contextTitle;
    }

    public String getHelpDescription() {
        return this.helpDescription;
    }

    public void setHelpDescription(String helpDescription) {
        this.helpDescription = helpDescription;
    }

    public void setIsDirective(boolean isDirective) {
        this.isDirective = isDirective;
    }

    public MapConfig getMapConfig() {
        return this.mapConfig;
    }

    public String getValue() {
        if (this.value == null) {
            this.value = "";
        }
        return this.value;
    }

    public ValueReferenceConfig getValueReferenceConfig() {
        return this.valueReferenceConfig;
    }

    public Boolean isDirective() {
        return this.isDirective;
    }

    public boolean isSecureInput() {
        return this.secureInput;
    }

    public int getMaxValueSize() {
        return this.maxValueSize;
    }

    public String getFirstOptionString() {
        String opt = "";
        if (this.getFirstOption() != null) {
            if (StringUtils.notEmpty(this.getFirstOption().getShortOpt())) {
                opt = this.getFirstOption().getShortOpt();
            } else if (StringUtils.notEmpty(this.getFirstOption().getLongOpt())) {
                opt = this.getFirstOption().getLongOpt();
            }
        }
        return opt;
    }

    public void setValue(String value) {
        this.setValue(value, InputMode.USER);
    }

    public void setValue(String value, InputMode inputMode) {
        if (value == null) {
            throw new BadInputException(ErrorMessages.ErrorCode.VALUE_CANT_BE_NULL, new String[0]);
        }
        this.setInputMode(inputMode);
        this.value = value;
    }

    public List<OptionConfig> getOptions() {
        return this.options;
    }

    public OptionConfig getFirstOption() {
        if (this.getOptions() != null) {
            return this.getOptions().get(0);
        }
        return null;
    }

    public void setOptions(List<OptionConfig> options) {
        this.options = options;
    }

    public DefaultConfig getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(DefaultConfig defaultValue) {
        this.setInputMode(InputMode.DEFAULT);
        this.defaultValue = defaultValue;
    }

    public EnvironmentVariableConfig getEnvVarValue() {
        return this.envVarValue;
    }

    public void setEnvVarValue(EnvironmentVariableConfig envVarValue) {
        this.setInputMode(InputMode.ENV_VAR);
        this.envVarValue = envVarValue;
    }

    public String getName() {
        return this.name;
    }

    public String getSameAs() {
        return this.sameAs;
    }

    public Type getType() {
        return this.type;
    }

    public Boolean isRequired() {
        return this.isRequired;
    }

    public Character getDelimeter() {
        return this.delimeter;
    }

    public void setDelimeter(Character delimeter) {
        this.delimeter = delimeter;
    }

    public Collection<String> getValues() {
        return this.values;
    }

    public void setValues(String[] values) {
        this.values.clear();
        if (values != null) {
            for (String value : values) {
                this.values.add(value);
            }
        }
    }

    public void setValues(Collection<String> values) {
        this.values = values;
    }

    public List<Map<String, String>> getValuesMap() {
        return this.valuesMap;
    }

    public void setValuesMap(List<Map<String, String>> valuesMap) {
        this.valuesMap = valuesMap;
    }

    public void setInputMode(InputMode inputMode) {
        this.inputMode = inputMode;
    }

    public InputMode getInputMode() {
        return this.inputMode;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contextTitle == null ? 0 : this.contextTitle.hashCode());
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        result = 31 * result + (this.delimeter == null ? 0 : this.delimeter.hashCode());
        result = 31 * result + (this.envVarValue == null ? 0 : this.envVarValue.hashCode());
        result = 31 * result + (this.helpDescription == null ? 0 : this.helpDescription.hashCode());
        result = 31 * result + (this.inputMode == null ? 0 : this.inputMode.hashCode());
        result = 31 * result + (this.isDirective == null ? 0 : this.isDirective.hashCode());
        result = 31 * result + (this.isRequired == null ? 0 : this.isRequired.hashCode());
        result = 31 * result + (this.isUndocumented ? 1231 : 1237);
        result = 31 * result + this.maxValueSize;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.sameAs == null ? 0 : this.sameAs.hashCode());
        result = 31 * result + (this.options == null ? 0 : ((Object)this.options).hashCode());
        result = 31 * result + (this.prompt == null ? 0 : this.prompt.hashCode());
        result = 31 * result + (this.secureInput ? 1231 : 1237);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.values == null ? 0 : ((Object)this.values).hashCode());
        result = 31 * result + (this.valuesMap == null ? 0 : ((Object)this.valuesMap).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParamConfig)) {
            return false;
        }
        ParamConfig other = (ParamConfig)obj;
        if (this.contextTitle == null ? other.contextTitle != null : !this.contextTitle.equals(other.contextTitle)) {
            return false;
        }
        if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue)) {
            return false;
        }
        if (this.delimeter == null ? other.delimeter != null : !this.delimeter.equals(other.delimeter)) {
            return false;
        }
        if (this.envVarValue == null ? other.envVarValue != null : !this.envVarValue.equals(other.envVarValue)) {
            return false;
        }
        if (this.helpDescription == null ? other.helpDescription != null : !this.helpDescription.equals(other.helpDescription)) {
            return false;
        }
        if (this.inputMode == null ? other.inputMode != null : !this.inputMode.equals((Object)other.inputMode)) {
            return false;
        }
        if (this.isDirective == null ? other.isDirective != null : !this.isDirective.equals(other.isDirective)) {
            return false;
        }
        if (this.isRequired == null ? other.isRequired != null : !this.isRequired.equals(other.isRequired)) {
            return false;
        }
        if (this.isUndocumented != other.isUndocumented) {
            return false;
        }
        if (this.maxValueSize != other.maxValueSize) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.sameAs == null ? other.sameAs != null : !this.sameAs.equals(other.sameAs)) {
            return false;
        }
        if (this.options == null ? other.options != null : !((Object)this.options).equals(other.options)) {
            return false;
        }
        if (this.prompt == null ? other.prompt != null : !this.prompt.equals(other.prompt)) {
            return false;
        }
        if (this.secureInput != other.secureInput) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals((Object)other.type)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        if (this.values == null ? other.values != null : !((Object)this.values).equals(other.values)) {
            return false;
        }
        return !(this.valuesMap == null ? other.valuesMap != null : !((Object)this.valuesMap).equals(other.valuesMap));
    }

    public String toString() {
        return "\nParameter '" + this.name + "' is of type '" + (Object)((Object)this.type) + "', is " + (this.isRequired != false ? "required" : "not required") + (!StringUtils.notEmpty(this.sameAs) ? "\n\tSame As: " + this.sameAs : "") + (StringUtils.notEmpty(this.helpDescription) ? "\n\tDescription: " + this.helpDescription : "") + (this.defaultValue != null ? "\n\t" + this.defaultValue.toString() : "") + (this.envVarValue != null ? "\n\t" + this.envVarValue.toString() : "") + (StringUtils.notEmpty(this.value) ? "\n\tValue: " + this.value : "") + (!this.values.isEmpty() ? "\n\tValues: " + this.values.toString() : "") + (!this.valuesMap.isEmpty() ? "\n\tValueMap: " + this.valuesMap.toString() : "") + (StringUtils.isEmpty(this.value) && this.values.isEmpty() && this.valuesMap.isEmpty() ? "\n\tNo value has been set" : "");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ARGUMENT,
        SWITCH,
        MULTIPLE,
        SIMPLE,
        ARGUMENTS_LIST,
        MAP;


        public static Type parse(String stringType) throws IllegalArgumentException {
            for (Type t : Type.values()) {
                if (!t.name().equalsIgnoreCase(stringType)) continue;
                return t;
            }
            throw new ConfigurationErrorException("Illegal parameter type: " + stringType);
        }

        public boolean singleValue() {
            switch (this) {
                case ARGUMENT: 
                case SWITCH: 
                case SIMPLE: 
                case MAP: {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InputMode {
        NONE,
        DEFAULT,
        ENV_VAR,
        USER;

    }
}

