/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.util;

import amazon.fws.clicommando.Initializer;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.messages.ErrorMessages;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtil {
    private static List<String> javaPrimitives = Arrays.asList("double", "char", "byte", "short", "int", "long", "float", "boolean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadParameters(Object request, Map<String, String> parameters) {
        try {
            ArrayList ordinals;
            Object parameter;
            Locale.setDefault(Locale.US);
            Pattern singlePattern = Pattern.compile("\\w+");
            Pattern structPattern = Pattern.compile("(\\w+)\\.(\\w+)");
            Pattern listPattern = Pattern.compile("(\\w+)\\.member\\.(\\d+)");
            Pattern mapPattern = Pattern.compile("(\\w+)\\.member\\.(\\d+)\\.(\\w+)");
            HashMap structStructure = new HashMap();
            HashMap listStructure = new HashMap();
            HashMap mapStructure = new HashMap();
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                String ordinalString;
                String paramString;
                String key = entry.getKey();
                Matcher singleMatcher = singlePattern.matcher(key);
                Matcher structMatcher = structPattern.matcher(key);
                Matcher listMatcher = listPattern.matcher(key);
                Matcher mapMatcher = mapPattern.matcher(key);
                if (singleMatcher.matches()) {
                    ReflectionUtil.constructAndSetMemberOfObject(request, key, entry.getValue());
                    continue;
                }
                if (structMatcher.matches()) {
                    paramString = structMatcher.group(1);
                    String memberString = structMatcher.group(2);
                    if (!structStructure.containsKey(paramString)) {
                        structStructure.put(paramString, new HashMap());
                    }
                    ((Map)structStructure.get(paramString)).put(memberString, entry.getValue());
                    continue;
                }
                if (listMatcher.matches()) {
                    paramString = listMatcher.group(1);
                    ordinalString = listMatcher.group(2);
                    if (!listStructure.containsKey(paramString)) {
                        listStructure.put(paramString, new HashMap());
                    }
                    ((Map)listStructure.get(paramString)).put(ordinalString, entry.getValue());
                    continue;
                }
                if (mapMatcher.matches()) {
                    Map paramMap;
                    paramString = mapMatcher.group(1);
                    ordinalString = mapMatcher.group(2);
                    String keyString = mapMatcher.group(3);
                    if (!mapStructure.containsKey(paramString)) {
                        mapStructure.put(paramString, new HashMap());
                    }
                    if (!(paramMap = (Map)mapStructure.get(paramString)).containsKey(ordinalString)) {
                        paramMap.put(ordinalString, new HashMap());
                    }
                    Map keyValueMap = (Map)paramMap.get(ordinalString);
                    keyValueMap.put(keyString, entry.getValue());
                    continue;
                }
                throw new ConfigurationErrorException("Invalid translation parameter string found: " + key);
            }
            for (String paramString : structStructure.keySet()) {
                ArrayList members = new ArrayList(((Map)structStructure.get(paramString)).keySet());
                parameter = ReflectionUtil.constructAndSetMemberOfObject(request, paramString);
                for (String member : members) {
                    String memberValue = (String)((Map)structStructure.get(paramString)).get(member);
                    ReflectionUtil.constructAndSetMemberOfObject(parameter, member, memberValue);
                }
            }
            for (String paramString : listStructure.keySet()) {
                ordinals = new ArrayList(((Map)listStructure.get(paramString)).keySet());
                Collections.sort(ordinals);
                parameter = ReflectionUtil.constructAndSetMemberOfObject(request, paramString);
                for (String ordinal : ordinals) {
                    String memberItem = (String)((Map)listStructure.get(paramString)).get(ordinal);
                    ReflectionUtil.addMemberItemToMemberListOfParameter(parameter, memberItem);
                }
            }
            for (String paramString : mapStructure.keySet()) {
                ordinals = new ArrayList(((Map)mapStructure.get(paramString)).keySet());
                Collections.sort(ordinals);
                parameter = ReflectionUtil.constructAndSetMemberOfObject(request, paramString);
                String memberItemType = ReflectionUtil.getMemberItemTypeFromParameterizedTypeOfMemberList(parameter, "member");
                for (String ordinal : ordinals) {
                    Object memberItem = ReflectionUtil.constructObject(memberItemType);
                    for (String key : ((Map)((Map)mapStructure.get(paramString)).get(ordinal)).keySet()) {
                        String memberProperty = (String)((Map)((Map)mapStructure.get(paramString)).get(ordinal)).get(key);
                        ReflectionUtil.constructAndSetMemberOfObject(memberItem, key, memberProperty);
                    }
                    ReflectionUtil.addMemberItemToMemberListOfParameter(parameter, memberItem);
                }
            }
            Object var22_21 = null;
        }
        catch (Throwable throwable) {
            Object var22_22 = null;
            Locale.setDefault(Initializer.DEFAULT_LOCALE);
            throw throwable;
        }
        Locale.setDefault(Initializer.DEFAULT_LOCALE);
    }

    public static void toMethodName(StringBuilder sb) {
        sb.setCharAt(0, sb.substring(0, 1).toLowerCase().charAt(0));
    }

    private static Object constructAndSetMemberOfObject(Object object, String memberName) {
        return ReflectionUtil.constructAndSetMemberOfObject(object, memberName, null);
    }

    private static Object constructAndSetMemberOfObject(Object object, String memberName, String memberConstructorString) {
        Field memberField = ReflectionUtil.getFieldForParameter(object, memberName);
        String type = memberField.getType().getName();
        Object newMemberObject = ReflectionUtil.constructObject(type, memberConstructorString);
        try {
            memberField.setAccessible(true);
            memberField.set(object, newMemberObject);
        }
        catch (Exception e) {
            throw new ConfigurationErrorException("Failed to get constructor(String): " + e.getLocalizedMessage(), e);
        }
        return newMemberObject;
    }

    private static void addMemberItemToMemberListOfParameter(Object parameter, Object memberItem) {
        Object member = null;
        try {
            Method getMember = ReflectionUtil.getMethod(parameter, "getMember");
            member = getMember.invoke(parameter, new Object[0]);
            Method addMethod = ReflectionUtil.getAddMethod(member);
            addMethod.invoke(member, memberItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationErrorException(String.format("Unable to call <parameter>.member.add(<memberValue>). parameterType:%s memberItemType:%s memberType:%s getMessage:%s\n\n", parameter.getClass().getCanonicalName(), memberItem.getClass().getCanonicalName(), member.getClass().getCanonicalName(), e.getMessage()), e);
        }
    }

    private static Object constructObject(String type) {
        return ReflectionUtil.constructObject(type, null);
    }

    private static Object constructObject(String type, String constructorArg) {
        Object newMemberObject = null;
        Constructor<?> constructor = null;
        if (javaPrimitives.contains(type)) {
            if (constructorArg == null) {
                throw new ConfigurationErrorException("No constructor argument for primitive type " + type);
            }
            newMemberObject = ReflectionUtil.parsePrimitive(type, constructorArg);
        } else {
            try {
                Class<?> objClass = Class.forName(type);
                if (type.equals("javax.xml.datatype.XMLGregorianCalendar") && constructorArg != null) {
                    newMemberObject = DatatypeFactory.newInstance().newXMLGregorianCalendar(constructorArg);
                } else if (constructorArg != null) {
                    constructor = objClass.getConstructor(String.class);
                    newMemberObject = constructor.newInstance(constructorArg);
                } else {
                    constructor = objClass.getConstructor(new Class[0]);
                    newMemberObject = constructor.newInstance(new Object[0]);
                }
            }
            catch (Exception e) {
                throw new ConfigurationErrorException("Failed to get constructor() for type {" + type + "} : " + e.getLocalizedMessage() + ":" + constructor, e);
            }
        }
        return newMemberObject;
    }

    private static Object parsePrimitive(String type, String primitiveArgument) {
        if (!javaPrimitives.contains(type)) {
            throw new ConfigurationErrorException("Invalid primitive type: " + type);
        }
        try {
            if (type.equals("double")) {
                return Double.parseDouble(primitiveArgument);
            }
            if (type.equals("char")) {
                if (primitiveArgument.length() != 1) {
                    throw new BadInputException(ErrorMessages.ErrorCode.ILLEGAL_ARGUMENT_VALUE, "char", primitiveArgument);
                }
                return Character.valueOf(primitiveArgument.charAt(0));
            }
            if (type.equals("byte")) {
                return Byte.parseByte(primitiveArgument);
            }
            if (type.equals("short")) {
                return Short.parseShort(primitiveArgument);
            }
            if (type.equals("int")) {
                return Integer.parseInt(primitiveArgument);
            }
            if (type.equals("long")) {
                return Long.parseLong(primitiveArgument);
            }
            if (type.equals("float")) {
                return Float.valueOf(Float.parseFloat(primitiveArgument));
            }
            if (type.equals("boolean")) {
                if (!primitiveArgument.equalsIgnoreCase("false") && !primitiveArgument.equalsIgnoreCase("true")) {
                    throw new BadInputException(ErrorMessages.ErrorCode.ILLEGAL_ARGUMENT_VALUE, "boolean", primitiveArgument);
                }
                return Boolean.parseBoolean(primitiveArgument);
            }
        }
        catch (NumberFormatException e) {
            throw new BadInputException(ErrorMessages.ErrorCode.ILLEGAL_ARGUMENT_VALUE, type, primitiveArgument);
        }
        return null;
    }

    private static String getMemberItemTypeFromParameterizedTypeOfMemberList(Object object, String memberName) {
        Field memberField = ReflectionUtil.getFieldForParameter(object, memberName);
        ParameterizedType ptype = (ParameterizedType)memberField.getGenericType();
        if (ptype.getActualTypeArguments().length != 1) {
            throw new ConfigurationErrorException(String.format("Member '%s' expected to have type List<?>, but instead of 1 has %d parameterized types", memberName, ptype.getActualTypeArguments().length));
        }
        String type = ((Class)ptype.getActualTypeArguments()[0]).getName();
        return type;
    }

    private static Method getMethod(Object object, String methodName) {
        Method[] methods;
        for (Method m : methods = object.getClass().getDeclaredMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return m;
        }
        throw new ConfigurationErrorException("Cannot find method '" + methodName + "' in " + object.getClass().getCanonicalName());
    }

    private static Method getAddMethod(Object object) {
        Method[] methods;
        for (Method m : methods = object.getClass().getDeclaredMethods()) {
            if (!m.getName().equals("add") || m.getParameterTypes().length != 1) continue;
            return m;
        }
        throw new ConfigurationErrorException("Cannot find method 'add' in " + object.getClass().getCanonicalName());
    }

    private static Field getFieldForParameter(Object request, String parameter) {
        Field field;
        String fieldName = ReflectionUtil.toFieldName(parameter);
        try {
            field = request.getClass().getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new ConfigurationErrorException("Field not found: " + fieldName + "in: " + request.getClass().getCanonicalName(), e);
        }
        return field;
    }

    private static String toFieldName(String parameter) {
        StringBuilder sb = new StringBuilder();
        sb.append(parameter);
        ReflectionUtil.toMethodName(sb);
        return sb.toString();
    }
}

