/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class BaseSplitPaneDivider
extends BasicSplitPaneDivider {
    public BaseSplitPaneDivider(BasicSplitPaneUI basicSplitPaneUI) {
        super(basicSplitPaneUI);
    }

    public Border getBorder() {
        return null;
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        int n3 = 0;
        int n4 = 0;
        if (n % 2 == 0) {
            n3 = 1;
        }
        if (n2 % 2 == 0) {
            n4 = 1;
        }
        ColorUIResource colorUIResource = AbstractLookAndFeel.getBackgroundColor();
        Color color = ColorHelper.brighter(colorUIResource, 25.0);
        Color color2 = ColorHelper.darker(colorUIResource, 5.0);
        Color[] colorArray = ColorHelper.createColorArr(color, color2, 10);
        if (UIManager.getLookAndFeel() instanceof AbstractLookAndFeel) {
            AbstractLookAndFeel abstractLookAndFeel = (AbstractLookAndFeel)UIManager.getLookAndFeel();
            if (this.orientation == 1) {
                JTattooUtilities.fillVerGradient(graphics, colorArray, 0, 0, n, n2);
                Icon icon = abstractLookAndFeel.getIconFactory().getSplitterHorBumpIcon();
                if (icon != null && n > icon.getIconWidth()) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Composite composite = graphics2D.getComposite();
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.7f);
                    graphics2D.setComposite(alphaComposite);
                    int n5 = (n - icon.getIconWidth()) / 2 + n3;
                    int n6 = (n2 - icon.getIconHeight()) / 2;
                    icon.paintIcon(this, graphics, n5, n6);
                    graphics2D.setComposite(composite);
                }
            } else {
                JTattooUtilities.fillHorGradient(graphics, colorArray, 0, 0, n, n2);
                Icon icon = abstractLookAndFeel.getIconFactory().getSplitterVerBumpIcon();
                if (icon != null && n2 > icon.getIconHeight()) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Composite composite = graphics2D.getComposite();
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.7f);
                    graphics2D.setComposite(alphaComposite);
                    int n7 = (n - icon.getIconWidth()) / 2;
                    int n8 = (n2 - icon.getIconHeight()) / 2 + n4;
                    icon.paintIcon(this, graphics, n7, n8);
                    graphics2D.setComposite(composite);
                }
            }
        }
        this.paintComponents(graphics);
    }

    protected JButton createLeftOneTouchButton() {
        JButton jButton = new JButton(){

            public void paint(Graphics graphics) {
                Color color = this.getBackground();
                int n = this.getSize().width;
                int n2 = this.getSize().height;
                if (this.getModel().isPressed() && this.getModel().isArmed()) {
                    graphics.setColor(ColorHelper.darker(color, 40.0));
                    graphics.fillRect(0, 0, n, n2);
                } else if (this.getModel().isRollover() && this.getModel().isArmed()) {
                    graphics.setColor(ColorHelper.brighter(color, 40.0));
                    graphics.fillRect(0, 0, n, n2);
                }
                Icon icon = null;
                icon = BaseSplitPaneDivider.this.orientation == 1 ? BaseIcons.getSplitterLeftArrowIcon() : BaseIcons.getSplitterUpArrowIcon();
                icon.paintIcon(this, graphics, 0, 0);
                if (this.getModel().isRollover() && this.getModel().isArmed()) {
                    if (this.getModel().isPressed()) {
                        JTattooUtilities.draw3DBorder(graphics, ColorHelper.darker(color, 60.0), ColorHelper.brighter(color, 80.0), 0, 0, n, n2);
                    } else {
                        JTattooUtilities.draw3DBorder(graphics, ColorHelper.brighter(color, 80.0), ColorHelper.darker(color, 60.0), 0, 0, n, n2);
                    }
                }
            }

            public boolean isFocusTraversable() {
                return false;
            }
        };
        jButton.setCursor(Cursor.getPredefinedCursor(0));
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setRolloverEnabled(true);
        return jButton;
    }

    protected JButton createRightOneTouchButton() {
        JButton jButton = new JButton(){

            public void paint(Graphics graphics) {
                Color color = this.getBackground();
                int n = this.getSize().width;
                int n2 = this.getSize().height;
                if (this.getModel().isPressed() && this.getModel().isArmed()) {
                    graphics.setColor(ColorHelper.darker(color, 40.0));
                    graphics.fillRect(0, 0, n, n2);
                } else if (this.getModel().isRollover() && this.getModel().isArmed()) {
                    graphics.setColor(ColorHelper.brighter(color, 40.0));
                    graphics.fillRect(0, 0, n, n2);
                }
                Icon icon = null;
                icon = BaseSplitPaneDivider.this.orientation == 1 ? BaseIcons.getSplitterRightArrowIcon() : BaseIcons.getSplitterDownArrowIcon();
                icon.paintIcon(this, graphics, 0, 0);
                if (this.getModel().isRollover() && this.getModel().isArmed()) {
                    if (this.getModel().isPressed()) {
                        JTattooUtilities.draw3DBorder(graphics, ColorHelper.darker(color, 60.0), ColorHelper.brighter(color, 80.0), 0, 0, n, n2);
                    } else {
                        JTattooUtilities.draw3DBorder(graphics, ColorHelper.brighter(color, 80.0), ColorHelper.darker(color, 60.0), 0, 0, n, n2);
                    }
                }
            }

            public boolean isFocusTraversable() {
                return false;
            }
        };
        jButton.setCursor(Cursor.getPredefinedCursor(0));
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setRolloverEnabled(true);
        return jButton;
    }
}

