/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.graphite;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class GraphiteBorders
extends BaseBorders {
    private static Border buttonBorder;
    private static Border toggleButtonBorder;
    private static Border rolloverToolButtonBorder;
    private static Border menuItemBorder;
    private static Border popupMenuBorder;
    private static Border internalFrameBorder;

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        if (toggleButtonBorder == null) {
            toggleButtonBorder = new ToggleButtonBorder();
        }
        return toggleButtonBorder;
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getMenuItemBorder() {
        if (menuItemBorder == null) {
            menuItemBorder = new MenuItemBorder();
        }
        return menuItemBorder;
    }

    public static Border getPopupMenuBorder() {
        if (popupMenuBorder == null) {
            popupMenuBorder = AbstractLookAndFeel.getTheme().isMenuOpaque() ? new PopupMenuBorder() : new BaseBorders.PopupMenuShadowBorder();
        }
        return popupMenuBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    static {
        menuItemBorder = null;
        popupMenuBorder = null;
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        public Insets getBorderInsets(Component component) {
            return this.insets;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            int n5 = this.getTitleHeight(component);
            ColorUIResource colorUIResource = AbstractLookAndFeel.getWindowTitleColorLight();
            ColorUIResource colorUIResource2 = AbstractLookAndFeel.getWindowTitleColorDark();
            ColorUIResource colorUIResource3 = AbstractLookAndFeel.getWindowBorderColor();
            if (!this.isActive(component)) {
                colorUIResource = AbstractLookAndFeel.getWindowInactiveTitleColorLight();
                colorUIResource2 = AbstractLookAndFeel.getWindowInactiveTitleColorDark();
                colorUIResource3 = AbstractLookAndFeel.getWindowInactiveBorderColor();
            }
            graphics.setColor(colorUIResource);
            graphics.fillRect(n, n2 + 1, n3, this.insets.top - 1);
            graphics.setColor(colorUIResource);
            graphics.fillRect(n + 1, n2 + n4 - 5, n3 - 2, 4);
            if (this.isActive(component)) {
                JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 1, this.insets.top, 5, n5 + 1);
                JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getWindowTitleColors(), n3 - 5 - 1, this.insets.top, 5, n5 + 1);
                graphics.setColor(colorUIResource2);
                JTattooUtilities.fillInverseHorGradient(graphics, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 1, this.insets.top + n5 + 1, 4, n4 - n5 - 5);
                JTattooUtilities.fillInverseHorGradient(graphics, AbstractLookAndFeel.getTheme().getWindowTitleColors(), n3 - 5, this.insets.top + n5 + 1, 4, n4 - n5 - 5);
            } else {
                JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 1, this.insets.top, 5, n5 + 1);
                JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), n3 - 5 - 1, this.insets.top, 5, n5 + 1);
                graphics.setColor(colorUIResource2);
                JTattooUtilities.fillInverseHorGradient(graphics, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 1, this.insets.top + n5 + 1, 4, n4 - n5 - 5);
                JTattooUtilities.fillInverseHorGradient(graphics, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), n3 - 5, this.insets.top + n5 + 1, 4, n4 - n5 - 5);
            }
            graphics.setColor(colorUIResource3);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            graphics.drawLine(n + 5 - 1, n2 + this.insets.top + n5, n + 5 - 1, n2 + n4 - 5);
            graphics.drawLine(n + n3 - 5, n2 + this.insets.top + n5, n + n3 - 5, n2 + n4 - 5);
            graphics.drawLine(n + 5 - 1, n2 + n4 - 5, n + n3 - 5, n2 + n4 - 5);
        }
    }

    public static class PopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        protected static final Font logoFont = new Font("Dialog", 1, 12);
        protected Insets logoInsets = new Insets(2, 18, 1, 1);
        protected Insets insets = new Insets(2, 1, 1, 1);

        public boolean hasLogo() {
            return AbstractLookAndFeel.getTheme().getLogoString() != null && AbstractLookAndFeel.getTheme().getLogoString().length() > 0;
        }

        public void paintLogo(Graphics2D graphics2D, int n, int n2) {
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D2 = bufferedImage.createGraphics();
            ColorUIResource colorUIResource = AbstractLookAndFeel.getTheme().getMenuSelectionBackgroundColorDark();
            ColorUIResource colorUIResource2 = AbstractLookAndFeel.getTheme().getMenuSelectionBackgroundColor();
            Color[] colorArray = ColorHelper.createColorArr(colorUIResource, colorUIResource2, 32);
            JTattooUtilities.fillHorGradient(graphics2D2, colorArray, 0, 0, n, n2);
            graphics2D2.setFont(logoFont);
            FontMetrics fontMetrics = graphics2D2.getFontMetrics();
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.setToRotation(4.71238898038469);
            graphics2D2.setTransform(affineTransform);
            int n3 = -n2 + 4;
            int n4 = fontMetrics.getAscent() + 2;
            graphics2D2.setColor(ColorHelper.darker(colorUIResource2, 20.0));
            graphics2D2.drawString(JTattooUtilities.getClippedText(AbstractLookAndFeel.getTheme().getLogoString(), fontMetrics, n2 - 16), n3 - 1, n4 + 1);
            graphics2D2.setColor(Color.white);
            graphics2D2.drawString(JTattooUtilities.getClippedText(AbstractLookAndFeel.getTheme().getLogoString(), fontMetrics, n2 - 16), n3, n4);
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n, n2);
            TexturePaint texturePaint = new TexturePaint(bufferedImage, double_);
            graphics2D.setPaint(texturePaint);
            graphics2D.fillRect(0, 0, n, n2);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            int n5 = this.getBorderInsets((Component)component).left - 1;
            ColorUIResource colorUIResource = AbstractLookAndFeel.getMenuSelectionBackgroundColor();
            ColorUIResource colorUIResource2 = AbstractLookAndFeel.getMenuBackgroundColor();
            Color color = ColorHelper.darker(AbstractLookAndFeel.getMenuSelectionBackgroundColor(), 20.0);
            graphics.setColor(colorUIResource);
            graphics.fillRect(n, n2, n5, n4);
            if (this.hasLogo()) {
                this.paintLogo((Graphics2D)graphics, n5, n4);
            }
            graphics.setColor(color);
            boolean bl = false;
            JPopupMenu jPopupMenu = (JPopupMenu)component;
            if (jPopupMenu.getInvoker() != null) {
                bl = jPopupMenu.getInvoker().getParent() instanceof JMenuBar;
            }
            if (bl) {
                graphics.drawLine(n + n5, n2, n + n3, n2);
            } else {
                graphics.drawLine(n, n2, n + n3, n2);
            }
            graphics.drawLine(n, n2, n, n2 + n4);
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4);
            graphics.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
            graphics.drawLine(n + n5, n2, n + n5, n2 + n4);
        }

        public Insets getBorderInsets(Component component) {
            if (this.hasLogo()) {
                return this.logoInsets;
            }
            return this.insets;
        }
    }

    public static class MenuItemBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JMenuItem jMenuItem = (JMenuItem)component;
            ButtonModel buttonModel = jMenuItem.getModel();
            Color color = ColorHelper.darker(AbstractLookAndFeel.getMenuSelectionBackgroundColor(), 20.0);
            graphics.setColor(color);
            if (component.getParent() instanceof JMenuBar) {
                if (buttonModel.isArmed() || buttonModel.isSelected()) {
                    graphics.drawLine(n, n2, n + n3 - 1, n2);
                    graphics.drawLine(n, n2 + 1, n, n2 + n4 - 1);
                    graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 1);
                }
            } else if (buttonModel.isArmed() || component instanceof JMenu && buttonModel.isSelected()) {
                graphics.drawLine(n, n2, n + n3 - 1, n2);
                graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            }
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            Color color = ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 50.0);
            if (buttonModel.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed() || buttonModel.isSelected()) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Composite composite = graphics2D.getComposite();
                    graphics.setColor(color);
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.15f);
                    graphics2D.setComposite(alphaComposite);
                    graphics.setColor(Color.black);
                    graphics.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
                    graphics2D.setComposite(composite);
                } else if (buttonModel.isRollover()) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Composite composite = graphics2D.getComposite();
                    graphics.setColor(color);
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.4f);
                    graphics2D.setComposite(alphaComposite);
                    graphics.setColor(Color.white);
                    graphics.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
                    graphics2D.setComposite(composite);
                }
            }
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ToggleButtonBorder
    implements Border,
    UIResource {
        private static final Insets borderInsets = new Insets(3, 6, 4, 6);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 30.0);
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(Color.white);
            graphics2D.drawRoundRect(n, n2, n3 - 1, n4 - 1, 4, 4);
            graphics2D.setColor(color);
            graphics2D.drawRoundRect(n, n2, n3 - 1, n4 - 2, 4, 4);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }

        public Insets getBorderInsets(Component component) {
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        private static final Insets borderInsets = new Insets(3, 6, 3, 6);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 30.0);
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(Color.white);
            graphics2D.drawRoundRect(n, n2, n3 - 1, n4 - 1, 6, 6);
            graphics2D.setColor(color);
            graphics2D.drawRoundRect(n, n2, n3 - 1, n4 - 2, 6, 6);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }

        public Insets getBorderInsets(Component component) {
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

