/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.PaintEvent;
import java.beans.Beans;
import java.lang.reflect.Constructor;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ProxyActions;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.application.View;
import org.jdesktop.application.utils.AppHelper;
import org.jdesktop.application.utils.PlatformType;

@ProxyActions(value={"cut", "copy", "paste", "delete"})
public abstract class Application
extends AbstractBean {
    public static final String KEY_APPLICATION_TITLE = "Application.title";
    public static final String KEY_APPLICATION_ICON = "Application.icon";
    public static final String KEY_APPLICATION_VENDOR_ID = "Application.vendorId";
    private static final Logger logger = Logger.getLogger(Application.class.getName());
    private static Application application = null;
    private final List<ExitListener> exitListeners = new CopyOnWriteArrayList<ExitListener>();
    private final ApplicationContext context = new ApplicationContext();
    protected boolean ready;

    protected Application() {
    }

    public static synchronized <T extends Application> void launch(final Class<T> clazz, final String[] stringArray) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Application.application = (Application)Application.create(clazz);
                    application.initialize(stringArray);
                    application.startup();
                    application.waitForReady();
                }
                catch (Exception exception) {
                    String string = String.format("Application %s failed to launch", clazz);
                    logger.log(Level.SEVERE, string, exception);
                    throw new Error(string, exception);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    static <T extends Application> T create(Class<T> clazz) throws Exception {
        Application application;
        block13: {
            Constructor<T> constructor;
            if (!Beans.isDesignTime()) {
                try {
                    System.setProperty("java.net.useSystemProxies", "true");
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            if (!(constructor = clazz.getDeclaredConstructor(new Class[0])).isAccessible()) {
                try {
                    constructor.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            application = (Application)constructor.newInstance(new Object[0]);
            ApplicationContext applicationContext = application.getContext();
            applicationContext.setApplicationClass(clazz);
            applicationContext.setApplication(application);
            ResourceMap resourceMap = applicationContext.getResourceMap();
            resourceMap.putResource("platform", (Object)AppHelper.getPlatform());
            if (!Beans.isDesignTime()) {
                String string = "Application.lookAndFeel";
                String string2 = resourceMap.getString(string, new Object[0]);
                String string3 = string2 == null ? "system" : string2;
                try {
                    if (string3.equalsIgnoreCase("system")) {
                        String string4 = UIManager.getSystemLookAndFeelClassName();
                        UIManager.setLookAndFeel(string4);
                        break block13;
                    }
                    if (string3.equalsIgnoreCase("nimbus")) {
                        for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
                            if (!"Nimbus".equals(lookAndFeelInfo.getName())) continue;
                            UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                            break block13;
                        }
                        break block13;
                    }
                    if (!string3.equalsIgnoreCase("default")) {
                        UIManager.setLookAndFeel(string3);
                    }
                }
                catch (Exception exception) {
                    String string5 = "Couldn't set LookandFeel " + string + " = \"" + string2 + "\"";
                    logger.log(Level.WARNING, string5, exception);
                }
            }
        }
        return (T)application;
    }

    void waitForReady() {
        new DoWaitForEmptyEventQ().execute();
    }

    protected void initialize(String[] stringArray) {
    }

    protected abstract void startup();

    protected void ready() {
    }

    protected void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForEmptyEventQ(JPanel jPanel) {
        boolean bl = false;
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        while (!bl) {
            NotifyingEvent notifyingEvent = new NotifyingEvent(jPanel);
            eventQueue.postEvent(notifyingEvent);
            NotifyingEvent notifyingEvent2 = notifyingEvent;
            synchronized (notifyingEvent2) {
                while (!notifyingEvent.isDispatched()) {
                    try {
                        notifyingEvent.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                bl = notifyingEvent.isEventQEmpty();
            }
        }
    }

    public final void exit() {
        this.exit(null);
    }

    public void exit(final EventObject eventObject) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (ExitListener exitListener : Application.this.exitListeners) {
                    if (exitListener.canExit(eventObject)) continue;
                    return;
                }
                try {
                    for (ExitListener exitListener : Application.this.exitListeners) {
                        try {
                            exitListener.willExit(eventObject);
                        }
                        catch (Exception exception) {
                            logger.log(Level.WARNING, "ExitListener.willExit() failed", exception);
                        }
                    }
                    Application.this.shutdown();
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "unexpected error in Application.shutdown()", exception);
                }
                finally {
                    Application.this.end();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void end() {
        Runtime.getRuntime().exit(0);
    }

    public void addExitListener(ExitListener exitListener) {
        this.exitListeners.add(exitListener);
    }

    public void removeExitListener(ExitListener exitListener) {
        this.exitListeners.remove(exitListener);
    }

    public ExitListener[] getExitListeners() {
        int n = this.exitListeners.size();
        return this.exitListeners.toArray(new ExitListener[n]);
    }

    @Action
    public void quit(ActionEvent actionEvent) {
        this.exit(actionEvent);
    }

    public final ApplicationContext getContext() {
        return this.context;
    }

    public static synchronized <T extends Application> T getInstance(Class<T> clazz) {
        if (Beans.isDesignTime() && application == null) {
            try {
                application = Application.create(clazz);
            }
            catch (Exception exception) {
                String string = String.format("Couldn't construct %s", clazz);
                Logger.getLogger(Application.class.getName()).log(Level.SEVERE, string, exception);
                throw new Error(string, exception);
            }
        }
        Application.checkApplicationLaunched();
        return (T)((Application)clazz.cast(application));
    }

    public static synchronized Application getInstance() {
        if (Beans.isDesignTime() && application == null) {
            application = new DesignTimeApplication();
        }
        Application.checkApplicationLaunched();
        return application;
    }

    private static void checkApplicationLaunched() throws IllegalStateException {
        if (application == null) {
            throw new IllegalStateException("Application is not launched.");
        }
    }

    public void show(View view) {
        Window window = (Window)view.getRootPane().getParent();
        if (window != null) {
            window.pack();
            window.setVisible(true);
        }
    }

    public void hide(View view) {
        view.getRootPane().getParent().setVisible(false);
    }

    public boolean isReady() {
        return this.ready;
    }

    private static final class DesignTimeApplication
    extends Application {
        protected DesignTimeApplication() {
            ApplicationContext applicationContext = this.getContext();
            applicationContext.setApplicationClass(this.getClass());
            applicationContext.setApplication(this);
            ResourceMap resourceMap = applicationContext.getResourceMap();
            resourceMap.setPlatform(PlatformType.DEFAULT);
        }

        @Override
        protected void startup() {
        }
    }

    public static interface ExitListener
    extends EventListener {
        public boolean canExit(EventObject var1);

        public void willExit(EventObject var1);
    }

    private class DoWaitForEmptyEventQ
    extends Task<Void, Void> {
        private final JPanel placeHolder;

        DoWaitForEmptyEventQ() {
            super(Application.this);
            this.placeHolder = new JPanel();
        }

        @Override
        protected Void doInBackground() {
            Application.this.waitForEmptyEventQ(this.placeHolder);
            return null;
        }

        @Override
        protected void finished() {
            Application.this.ready = true;
            Application.this.ready();
        }
    }

    private static class NotifyingEvent
    extends PaintEvent
    implements ActiveEvent {
        private boolean dispatched = false;
        private boolean qEmpty = false;

        NotifyingEvent(Component component) {
            super(component, 801, null);
        }

        synchronized boolean isDispatched() {
            return this.dispatched;
        }

        synchronized boolean isEventQEmpty() {
            return this.qEmpty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatch() {
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            NotifyingEvent notifyingEvent = this;
            synchronized (notifyingEvent) {
                this.qEmpty = eventQueue.peekEvent() == null;
                this.dispatched = true;
                this.notifyAll();
            }
        }
    }
}

